/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.ConfigFilesService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.utils.ClassLoaderService;
import com.mulesoft.runtime.upgrade.tool.utils.JarFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultConfigFilesService
implements ConfigFilesService {
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private ClassLoaderService classLoaderService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    public static final String TO_REVIEW_FOLDER_NAME = "to_review";
    public static final String READY_FOLDER_NAME = "ready";
    public static final String ORIGINAL_FILES_NEW_DISTRO_FOLDER = "new";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigFilesService.class);
    static final String CONFIGS_FILES_JAR_NAME_PREFIX = "mule-config-files-";
    static final String CONFIGS_FILES_JARS_DIRECTORY_INSIDE_UPGRADE_TOOL = "mule-config-files/";

    public Path getResolvedConflictsFolder() {
        return Paths.get(this.upgradeConfigService.getUpgradeToolFolderName(), this.upgradeConfigService.getConfigFilesResolvedConflictsFolderName());
    }

    public String getSolveConflictsDocsPage() {
        return this.upgradeConfigService.getDocsPage() + "#" + this.upgradeConfigService.getDocsSolveConfigConflictsSection();
    }

    String getConfigsFileJarPath(Path muleHome) throws IOException {
        if (this.checkConfigsFileJarExistenceInsideUpgradeTool(muleHome)) {
            String version = this.muleDistroService.detectMuleVersion(muleHome);
            return this.extractConfigFilesJarFromUpgradeTool(version, muleHome);
        }
        if (this.checkConfigsFileJarExistenceInsideMuleDistro(muleHome)) {
            return this.resolveConfigsFilesJarPathInDistro(muleHome);
        }
        throw new FileNotFoundException("The Mule Runtime config Jar file was NOT found neither in the Mule Distribution " + muleHome + " nor inside the upgrade tool configs files jars.");
    }

    String extractConfigFilesJarFromUpgradeTool(String version, Path muleHome) throws IOException {
        Optional configFilesJarURLOptional = this.resolveConfigsFilesJarPathInUpgradeTool(version);
        if (configFilesJarURLOptional.isPresent()) {
            String configFilesJarInUpgradeToolPath = (String)configFilesJarURLOptional.get();
            File destExtractedFile = this.getJarInUpgradeToolExtractionDestination(muleHome, configFilesJarInUpgradeToolPath).toFile();
            Resource configsFileJarInsideTool = this.classLoaderService.getResourceFromClasspath(configFilesJarInUpgradeToolPath);
            FileUtils.copyInputStreamToFile((InputStream)configsFileJarInsideTool.getInputStream(), (File)destExtractedFile);
            return destExtractedFile.getAbsolutePath();
        }
        throw new FileNotFoundException("The Configs Jar file was not found inside the upgrade tool configs files jars.");
    }

    Path getJarInUpgradeToolExtractionDestination(Path muleHome, String configFilesJarInUpgradeToolPath) {
        String configFilesJarName = Paths.get(configFilesJarInUpgradeToolPath, new String[0]).getFileName().toString();
        return this.getResolvedConflictsFolderInDistro(muleHome).resolve(configFilesJarName);
    }

    boolean checkConfigsFileJarExistenceInsideUpgradeTool(Path muleHome) throws FileNotFoundException {
        String currentVersion = this.muleDistroService.detectMuleVersion(muleHome);
        return this.checkConfigsFileJarExistenceInsideUpgradeTool(currentVersion);
    }

    boolean configFileIsInReadyFolder(Path muleHome, String configFilePath) {
        Path configFileResolvedDestination = this.getReadyConfigFileDestination(muleHome, configFilePath);
        return Files.exists(configFileResolvedDestination, new LinkOption[0]);
    }

    public Path getResolvedConflictsFolderInDistro(Path muleHome) {
        return muleHome.resolve(this.getResolvedConflictsFolder());
    }

    boolean checkConfigsFileJarExistenceInsideUpgradeTool(String version) {
        Optional configsFileJarInUpgradeTool = this.resolveConfigsFilesJarPathInUpgradeTool(version);
        return configsFileJarInUpgradeTool.isPresent();
    }

    boolean checkConfigsFileJarExistenceInsideMuleDistro(Path muleHome) throws FileNotFoundException {
        String configsFileJarInDistro = this.resolveConfigsFilesJarPathInDistro(muleHome);
        if (Files.exists(Paths.get(configsFileJarInDistro, new String[0]), new LinkOption[0])) {
            LOGGER.debug("Mule Runtime config files jar [{}] was found inside the distribution.", (Object)configsFileJarInDistro);
            return true;
        }
        LOGGER.debug("Mule Runtime config files jar [{}] was NOT found inside the distribution.", (Object)configsFileJarInDistro);
        return false;
    }

    String resolveConfigsFilesJarName(String version) {
        return CONFIGS_FILES_JAR_NAME_PREFIX + version + ".jar";
    }

    String resolveConfigsFilesJarNameInUpgradeTool(String version) {
        return CONFIGS_FILES_JARS_DIRECTORY_INSIDE_UPGRADE_TOOL + this.resolveConfigsFilesJarName(version);
    }

    Optional<String> resolveConfigsFilesJarPathInUpgradeTool(String version) {
        String configFilesJarPathInUpgradeTool = this.resolveConfigsFilesJarNameInUpgradeTool(version);
        URL configsFileJarInsideUpgradeToolURL = this.classLoaderService.getURLByResourcePath(configFilesJarPathInUpgradeTool);
        if (configsFileJarInsideUpgradeToolURL == null) {
            LOGGER.debug("Mule Runtime config files jar was NOT found in upgrade tool under resources path [{}]", (Object)configFilesJarPathInUpgradeTool);
            return Optional.empty();
        }
        LOGGER.debug("Mule Runtime config files jar was found in upgrade tool under resources path [{}]", (Object)configFilesJarPathInUpgradeTool);
        return Optional.of(configFilesJarPathInUpgradeTool);
    }

    String resolveConfigsFilesJarPathInDistro(Path muleHome) throws FileNotFoundException {
        String currentVersion = this.muleDistroService.detectMuleVersion(muleHome);
        Path configsFileJarWithVersion = this.muleDistroService.getLibMuleJarDirectoryPath().resolve(this.resolveConfigsFilesJarName(currentVersion));
        return muleHome.resolve(configsFileJarWithVersion).toAbsolutePath().toString();
    }

    public boolean checkConflicts(Path oldMule, Path newMule, boolean isDryRunMode) throws IOException {
        String configsFileJarPathInNewDistro;
        String configsFileJarPathInOldDistro;
        LOGGER.debug("Checking Mule Runtime Config files conflicts between distributions [{}] and [{}]...", (Object)oldMule, (Object)newMule);
        this.validateConfigFilesJarsExistencesInBothDistros(oldMule, newMule);
        try {
            configsFileJarPathInOldDistro = this.getConfigsFileJarPath(oldMule);
            configsFileJarPathInNewDistro = this.getConfigsFileJarPath(newMule);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Upgrading from/to this version caused an unexpected error trying to obtain the Mule Runtime configs files. Please create a ticket to support.", e);
        }
        List configFilesInOldDistroJar = JarFileUtils.getJarEntries((String)configsFileJarPathInOldDistro);
        boolean configFilesCheckIsFine = true;
        for (String configFilePathInOldDistroJar : configFilesInOldDistroJar) {
            byte[] configFileContentInOldDistro = JarFileUtils.getFileContentInByteArray((String)configsFileJarPathInOldDistro, (String)configFilePathInOldDistroJar);
            byte[] configFileContentInNewDistro = JarFileUtils.getFileContentInByteArray((String)configsFileJarPathInNewDistro, (String)configFilePathInOldDistroJar);
            if (this.configFileIsInReadyFolder(oldMule, configFilePathInOldDistroJar)) {
                LOGGER.debug("The config File '{}' was found in the '{}' folder. Will proceed without checking conflicts in this config file.", (Object)configFilePathInOldDistroJar, (Object)this.getReadyFolderInDistro(oldMule));
                continue;
            }
            if (this.configFileWasRemovedFromDistro(oldMule, configFilePathInOldDistroJar)) {
                LOGGER.debug("The config File '{}' was removed from the original version. Make sure you don't need it to keep your system working.", (Object)configFilePathInOldDistroJar);
                continue;
            }
            if (!this.userConfigFileHasChanges(oldMule, configFilePathInOldDistroJar, configFileContentInOldDistro)) {
                this.copyNewConfigFileToReadyFolder(oldMule, configsFileJarPathInNewDistro, configFilePathInOldDistroJar, configFileContentInNewDistro, isDryRunMode);
                continue;
            }
            if (this.configFileHasChanges(configFileContentInOldDistro, configFileContentInNewDistro)) {
                configFilesCheckIsFine = false;
                this.showConfigFileWithConflictErrorMessage(oldMule, configFilePathInOldDistroJar);
                this.copyUserConfigFileWithConflictsToReviewFolder(oldMule, configFilePathInOldDistroJar, isDryRunMode);
                this.copyOriginalConfigFileInNewConflictsFolderAsReference(oldMule, newMule, configFilePathInOldDistroJar, configsFileJarPathInNewDistro, configFileContentInNewDistro, isDryRunMode);
                continue;
            }
            this.copyUserConfigFileWoutConflictsToReadyFolder(oldMule, configFilePathInOldDistroJar, isDryRunMode);
        }
        this.deleteAuxConfigFileJars(oldMule, configsFileJarPathInNewDistro, configsFileJarPathInNewDistro);
        return configFilesCheckIsFine;
    }

    private void showConfigFileWithConflictErrorMessage(Path oldMule, String configFilePathInOldDistroJar) {
        String errorMessage = "The config file '{}' was updated in the new version, make sure the one you want to use with the changes needed is in the '{}' folder [{}] as it is required before being able to re-run the upgrade command again.";
        LOGGER.error(errorMessage, new Object[]{configFilePathInOldDistroJar, this.getReadyFolderName(), this.getReadyConfigFileDestination(oldMule, configFilePathInOldDistroJar)});
    }

    private boolean configFileWasRemovedFromDistro(Path oldMule, String configFileNameInOldDistroJar) {
        return !Files.isRegularFile(Paths.get(oldMule.toString(), configFileNameInOldDistroJar), new LinkOption[0]);
    }

    private void validateConfigFilesJarsExistencesInBothDistros(Path oldMule, Path newMule) throws FileNotFoundException {
        if (!this.checkConfigFilesJarsExistencesInsideBothDistributions(oldMule, newMule)) {
            throw new FileNotFoundException(String.format("Mule Runtime config files jars NOT found for both distributions [%s] and [%s]", oldMule, newMule));
        }
        LOGGER.debug("Mule Runtime config files jars successfully found for both distributions [{}] and [{}]", (Object)oldMule, (Object)newMule);
    }

    void deleteAuxConfigFileJars(Path oldMuleHome, String configsFileJarPathInOldDistro, String configsFileJarPathInNewDistro) {
        Path configsFileJarOldDistro = Paths.get(configsFileJarPathInOldDistro, new String[0]);
        Path configsFileJarNewDistro = Paths.get(configsFileJarPathInNewDistro, new String[0]);
        this.deleteIfExistsInsideResolvedConflictsFolder(configsFileJarOldDistro, oldMuleHome);
        this.deleteIfExistsInsideResolvedConflictsFolder(configsFileJarNewDistro, oldMuleHome);
    }

    private void deleteIfExistsInsideResolvedConflictsFolder(Path configsFileJar, Path muleHome) {
        Path resolvedConflictsFolder = this.getResolvedConflictsFolderInDistro(muleHome);
        if (Files.exists(configsFileJar, new LinkOption[0]) && configsFileJar.getParent().equals(resolvedConflictsFolder)) {
            FileUtils.deleteQuietly((File)configsFileJar.toFile());
        }
    }

    void copyUserConfigFileWoutConflictsToReadyFolder(Path muleHome, String configFileName, boolean isDryRun) throws IOException {
        File sourceFile = this.getConfConfigFileDestination(muleHome, configFileName).toFile();
        File destFile = this.getReadyConfigFileDestination(muleHome, configFileName).toFile();
        this.fileSystemService.copyFile(sourceFile, destFile, isDryRun);
    }

    public String getToReviewFolderName() {
        return TO_REVIEW_FOLDER_NAME;
    }

    public String getReadyFolderName() {
        return READY_FOLDER_NAME;
    }

    String getNewFolderName() {
        return ORIGINAL_FILES_NEW_DISTRO_FOLDER;
    }

    public Path getToReviewFolderInDistro(Path muleHome) {
        return this.getResolvedConflictsFolderInDistro(muleHome).resolve(this.getToReviewFolderName());
    }

    public Path getToReviewConfigFileDestination(Path muleHome, String configFilePath) {
        Path configFileName = Paths.get(configFilePath, new String[0]).getFileName();
        return this.getToReviewFolderInDistro(muleHome).resolve(configFileName);
    }

    public Path getReadyFolderInDistro(Path muleHome) {
        return this.getResolvedConflictsFolderInDistro(muleHome).resolve(this.getReadyFolderName());
    }

    public Path getReadyConfigFileDestination(Path muleHome, String configFilePath) {
        Path configFileName = Paths.get(configFilePath, new String[0]).getFileName();
        return this.getReadyFolderInDistro(muleHome).resolve(configFileName);
    }

    Path getNewConfigFileDestination(Path muleHomeOld, Path muleHomeNew, String configFilePath) {
        Path configFileName = Paths.get(configFilePath, new String[0]).getFileName();
        return this.getNewFolderInDistro(muleHomeOld, muleHomeNew).resolve(configFileName);
    }

    public Path getConfFolderInDistro(Path muleHome) {
        return muleHome.resolve(this.muleDistroService.getConfigFolder());
    }

    public Path getConfConfigFileDestination(Path muleHome, String configFilePath) {
        Path configFileName = Paths.get(configFilePath, new String[0]).getFileName();
        return this.getConfFolderInDistro(muleHome).resolve(configFileName);
    }

    void copyUserConfigFileWithConflictsToReviewFolder(Path muleHome, String configFilePath, boolean isDryRun) throws IOException {
        File sourceFile = this.getConfConfigFileDestination(muleHome, configFilePath).toFile();
        File destFile = this.getToReviewConfigFileDestination(muleHome, configFilePath).toFile();
        this.fileSystemService.copyFile(sourceFile, destFile, isDryRun);
    }

    private void copyOriginalConfigFileInNewConflictsFolderAsReference(Path muleHomeOld, Path muleHomeNew, String configFilePath, String configsFileJarPathInNewDistro, byte[] newConfigFileContent, boolean isDryRun) throws IOException {
        File destFileNewInDistro = this.getNewConfigFileDestination(muleHomeOld, muleHomeNew, configFilePath).toFile();
        LOGGER.trace("Copying file [{}{}] to [{}]...", new Object[]{configsFileJarPathInNewDistro, configFilePath, destFileNewInDistro});
        if (!isDryRun) {
            FileUtils.writeByteArrayToFile((File)destFileNewInDistro, (byte[])newConfigFileContent);
        }
    }

    Path getNewFolderInDistro(Path muleHomeOld, Path muleHomeNew) {
        return this.getResolvedConflictsFolderInDistro(muleHomeOld).resolve("new-" + muleHomeNew.getFileName());
    }

    boolean configFileHasChanges(byte[] configFileContentInOldDistro, byte[] configFileContentInNewDistro) throws IOException {
        return !this.fileSystemService.areHashesBetweenFilesEqual(configFileContentInOldDistro, configFileContentInNewDistro);
    }

    boolean checkConfigFilesJarsExistencesInsideBothDistributions(Path oldMulePath, Path newMulePath) throws FileNotFoundException {
        LOGGER.debug("Checking mule-config-files jar existence...");
        return this.checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(oldMulePath) && this.checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(newMulePath);
    }

    boolean checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(Path muleHome) throws FileNotFoundException {
        return this.checkConfigsFileJarExistenceInsideMuleDistro(muleHome) || this.checkConfigsFileJarExistenceInsideUpgradeTool(muleHome);
    }

    public void copyFinalConfigFiles(Path oldMule, boolean isDryRunMode) throws IOException {
        Path readyFolderInDistro = this.getReadyFolderInDistro(oldMule);
        Path confFolderInDistro = oldMule.resolve(this.muleDistroService.getConfigFolder());
        LOGGER.debug("Copying mule runtime distribution config files from [{}] to [{}].", (Object)readyFolderInDistro, (Object)oldMule.resolve(this.muleDistroService.getConfigFolder()));
        ArrayList includedPaths = new ArrayList();
        ArrayList excludedPaths = new ArrayList();
        this.fileSystemService.copyFiles(readyFolderInDistro, confFolderInDistro, includedPaths, excludedPaths, isDryRunMode);
        if (!isDryRunMode) {
            Path resolvedConflictsFolder = this.getResolvedConflictsFolderInDistro(oldMule);
            FileUtils.deleteDirectory((File)resolvedConflictsFolder.toFile());
        }
    }

    private void copyNewConfigFileToReadyFolder(Path muleHomeOld, String configsFileJarPathInNewDistro, String configFilePath, byte[] newConfigFileContent, boolean isDryRun) throws IOException {
        File destFileInReadyFolder = this.getReadyConfigFileDestination(muleHomeOld, configFilePath).toFile();
        LOGGER.trace("Copying file [{}{}] to [{}]...", new Object[]{configsFileJarPathInNewDistro, configFilePath, destFileInReadyFolder});
        if (!isDryRun) {
            FileUtils.writeByteArrayToFile((File)destFileInReadyFolder, (byte[])newConfigFileContent);
        }
    }

    private boolean userConfigFileHasChanges(Path muleHome, String configFilePath, byte[] originalOldDistroConfigFileContent) throws IOException {
        byte[] userConfigFileContent = FileUtils.readFileToByteArray((File)this.getConfConfigFileDestination(muleHome, configFilePath).toFile());
        return this.configFileHasChanges(userConfigFileContent, originalOldDistroConfigFileContent);
    }
}

