/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.service.api.ConfigFilesService;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleStatusService;
import com.mulesoft.runtime.upgrade.tool.utils.ClassLoaderService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultMuleDistroService
implements MuleDistroService {
    private static final Pattern GET_VERSION_MULE_DIRNAME_PATTERN = Pattern.compile("4\\.(\\d+)\\.(\\d+)");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleDistroService.class);
    private static final String MULE_CLUSTER_PROPERTIES_INNER_PATH = ".mule/mule-cluster.properties";
    public static final Path LIB_MULE_JAR_DIRECTORY_PATH = Paths.get("lib", "mule");
    public static final Path CONFIG_FOLDER = Paths.get("conf", new String[0]);
    private static final Pattern MULE_CORE_JAR_FILE_NAME_PATTERN = Pattern.compile("^mule-core-((?:\\d+\\.){2}\\d+(?:-\\w+)?)\\.jar$");
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private MuleStatusService muleStatusService;
    @Autowired
    private ClassLoaderService classLoaderService;
    @Autowired
    private DescriptorService descriptorService;
    @Autowired
    private MuleDistroService distroService;
    @Autowired
    private ConfigFilesService configFilesService;

    public MuleDistribution initMuleDistro(Path muleHome) throws IOException {
        LOGGER.debug("Initializing Mule runtime distro object for location [{}]", (Object)muleHome);
        this.fileSystemService.checkIsADirectory(muleHome);
        String muleVersion = this.detectMuleVersion(muleHome);
        return new MuleDistribution.Builder().location(muleHome).version(muleVersion).build();
    }

    public void looksLikeADistro(Path muleDistroLocation) throws IOException {
        this.fileSystemService.checkIsADirectory(muleDistroLocation);
        this.detectMuleVersion(muleDistroLocation);
    }

    public boolean checkClusterModeIsActive(Path currentMuleDistroPropertiesFilePath) throws IOException {
        LOGGER.debug("Checking if cluster mode is active...");
        String currentMuleDistroPropertiesFile = currentMuleDistroPropertiesFilePath.resolve(MULE_CLUSTER_PROPERTIES_INNER_PATH).toString();
        File file = new File(currentMuleDistroPropertiesFile);
        if (this.isClusterModeActive(file, currentMuleDistroPropertiesFile)) {
            LOGGER.warn("A cluster configuration was found in this Mule Runtime installation. You will need to execute the upgrade process for every node in the cluster.");
            return true;
        }
        return false;
    }

    public boolean isClusterModeActive(File propertiesFile, String currentMuleDistroPropertiesFile) throws IOException {
        if (propertiesFile.exists()) {
            String muleClusterId;
            try (FileInputStream fileInputStream = new FileInputStream(currentMuleDistroPropertiesFile);){
                Properties myPropertyFile = new Properties();
                myPropertyFile.load(fileInputStream);
                muleClusterId = myPropertyFile.getProperty("mule.clusterId");
            }
            return muleClusterId != null && !muleClusterId.isEmpty();
        }
        return false;
    }

    public String detectMuleVersion(Path muleHome) throws FileNotFoundException {
        LOGGER.debug("Detecting Mule Runtime version for distribution located at: [{}]", (Object)muleHome);
        File muleCoreJarDirectory = this.checkLibMuleJarDirectoryExists(muleHome);
        File[] files = this.findFilesByRegex(muleCoreJarDirectory, MULE_CORE_JAR_FILE_NAME_PATTERN);
        if (files.length != 1) {
            throw new FileNotFoundException(String.format("Mule Core jar artifact does not exists at the expected location [%s]", muleCoreJarDirectory));
        }
        Matcher matcher = MULE_CORE_JAR_FILE_NAME_PATTERN.matcher(files[0].getName());
        matcher.find();
        String muleVersion = matcher.group(1);
        LOGGER.debug("Detected mule version for distro at [{}] is: [{}]", (Object)muleHome, (Object)muleVersion);
        return muleVersion;
    }

    private File[] findFilesByRegex(File muleCoreJarDirectory, Pattern patternFileFilter) {
        RegexFileFilter fileFilter = new RegexFileFilter(patternFileFilter);
        return muleCoreJarDirectory.listFiles((FileFilter)fileFilter);
    }

    private File checkLibMuleJarDirectoryExists(Path muleHome) throws FileNotFoundException {
        File muleCoreJarDirectory = muleHome.resolve(LIB_MULE_JAR_DIRECTORY_PATH).toFile();
        if (!muleCoreJarDirectory.exists()) {
            throw new FileNotFoundException(String.format("Expected dir [%s] does not exist. Given path [%s] might not correspond to an actual distro", muleCoreJarDirectory, muleHome));
        }
        return muleCoreJarDirectory;
    }

    public boolean checkFilesDescriptorsExistencesInsideBothDistributions(Path oldMulePath, Path newMulePath) throws IOException {
        LOGGER.debug("Checking file descriptor existence...");
        return this.descriptorService.checkFileDescriptorExistenceInsideMuleDistroOrInsideUpgradeTool(oldMulePath) && this.descriptorService.checkFileDescriptorExistenceInsideMuleDistroOrInsideUpgradeTool(newMulePath);
    }

    public Path getLibMuleJarDirectoryPath() {
        return LIB_MULE_JAR_DIRECTORY_PATH;
    }

    public Path getConfigFolder() {
        return CONFIG_FOLDER;
    }

    public boolean checkMisleadingMuleDirName(Path currentMule) {
        String muleDirName = currentMule.getFileName().toString();
        Matcher matchMuleDirName = GET_VERSION_MULE_DIRNAME_PATTERN.matcher(muleDirName);
        return matchMuleDirName.find();
    }
}

