/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain.enums;

import static java.nio.file.Paths.get;
import static java.util.EnumSet.allOf;
import static java.util.stream.Collectors.toList;

import java.nio.file.Path;
import java.util.List;

/**
 * Defines additional paths different to the one defined in {@link FileToBeExcluded} (files and folders) that must be excluded
 * during the file description comparison when performing a backup and upgrade process.
 */
public enum AdditionalPathToBeExcluded {

  WRAPPER_ADDITIONAL(get("conf", "wrapper-additional.conf")), SERVER_PLUGINS(get("server-plugins", "mule-agent-plugin", ".")), AM(
      get("am", "."));

  private final Path path;

  /**
   * Gets the list of all {@link Path} defined by all the values of this enumeration.
   *
   * @return list of all paths defined by each of the value of this enumeration.
   */
  public static List<Path> getAllPaths() {
    return allOf(AdditionalPathToBeExcluded.class).stream().map(AdditionalPathToBeExcluded::getPath).collect(toList());
  }

  AdditionalPathToBeExcluded(Path path) {
    this.path = path;
  }

  public Path getPath() {
    return path;
  }
}
