/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.runtime.upgrade.tool.utils;

import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * Utils for command options
 */
public class CommandUtils {

  private CommandUtils() {
    throw new IllegalStateException("Utility class");
  }

  public static final String NO_MULE_HOME_ERROR_MSG =
      "Unable to guess a MULE_HOME candidate, use -o to specify a valid MULE_HOME";

  /**
   * Check existence of current MULE_HOME
   *
   * @return return Path, if it doesn't detect any MULE_HOME returns null
   */

  public static Path guessCurrentMuleHome() {
    String userDir = System.getProperty("user.dir");
    Path currentMulePath = userDir.endsWith("tools") ? Paths.get(userDir).getParent() : null;
    return currentMulePath;
  }

}
