/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;

/**
 * A services for Mule distribution patches handling.
 */
public interface DistroPatchService {

  /**
   * Retrieves all the file paths of the applied patches of a given Mule Runtime Distribution if any.
   *
   * @param muleDistribution location of the Mule distribution where backup could reside.
   * @throws FileNotFoundException if patches dir is not found within the given mule distro location.
   */
  List<File> getAppliedPatches(Path muleDistribution) throws FileNotFoundException;

  /**
   * Retrieves all the applied patches of a given Mule Runtime Distribution if any using relative paths.
   *
   * @param muleDistribution location of the Mule distribution where patches could reside.
   * @throws FileNotFoundException if patches dir is not found within the given mule distro location.
   */
  List<File> getAppliedPatchesWithRelativePaths(Path muleDistribution) throws FileNotFoundException;

  /**
   * Get patches dir inside the Mule Distribution path passed as parameter
   *
   * @param muleDistribution location of the Mule distribution to get the patches dir.
   * @return The PATCHES_DIR resolved path from the muleDistribution parameter passed
   */
  Path getPatchesDir(Path muleDistribution);
}
