/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import com.mulesoft.runtime.upgrade.tool.service.api.StatusService;
import com.mulesoft.runtime.upgrade.tool.utils.CommandUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@CommandLine.Command(name="status", description={"Shows if current Mule Distribution complies preconditions for being upgraded, lists possibles commands to execute, shows backup information and current Mule Distribution."})
public class StatusCommand
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusCommand.class);
    @CommandLine.Option(names={"-o", "--old-mule-distro"}, description={"File path of Mule Runtime distribution to process current status."})
    Path oldMuleDistro;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this help message"})
    boolean usageHelpRequested;
    @Autowired
    private StatusService statusService;

    @Override
    public Integer call() throws IOException {
        LOGGER.info("Initializing status process...");
        Path path = this.oldMuleDistro = this.oldMuleDistro != null ? this.oldMuleDistro : CommandUtils.guessCurrentMuleHome();
        if (this.oldMuleDistro == null) {
            LOGGER.error("Unable to guess a MULE_HOME candidate, use -o to specify a valid MULE_HOME");
            System.exit(1);
        }
        this.statusService.statusCommandExecute(this.oldMuleDistro);
        return 0;
    }

    public void setOldMuleDistro(Path oldMuleDistro) {
        this.oldMuleDistro = oldMuleDistro;
    }
}

