/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleStatusService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultMuleStatusService
implements MuleStatusService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleStatusService.class);
    private static final Path UNIX_MULE_BINARY = Paths.get("bin", "mule");
    private static final Path WINDOWS_MULE_BINARY = Paths.get("bin", "mule.bat");
    private static final String NOT_RUNNING_EXPECTED_UNIX_OUTPUT_PATTERN = "(?s).*not running.*";
    private static final String NOT_RUNNING_EXPECTED_WINDOWS_OUTPUT_PATTERN = "(?s).*(Running: No|not installed).*";
    @Autowired
    private FileSystemService fileSystemService;

    public void checkStopped(Path muleLocation) throws IOException {
        LOGGER.debug("Checking if Mule runtime at [{}] is stopped", (Object)muleLocation);
        String[] queryMuleStatusCommand = this.getQueryMuleStatusCommand(muleLocation);
        String processOutput = this.sanitizeProcessOutput(this.executeQueryStatusCommand(queryMuleStatusCommand));
        if (!this.processOutputMatchesExpectedStoppedPattern(processOutput)) {
            throw new IllegalStateException(String.format("Mule runtime at [%s] is running", muleLocation));
        }
    }

    private String[] getQueryMuleStatusCommand(Path muleLocation) throws FileNotFoundException {
        String muleBinary = this.resolveMuleBinary(muleLocation).toAbsolutePath().toString();
        String[] queryMuleStatusCommand = new String[]{muleBinary, "status"};
        return queryMuleStatusCommand;
    }

    protected Path getMuleBinaryPath() {
        return this.fileSystemService.isWindowsOs() ? WINDOWS_MULE_BINARY : UNIX_MULE_BINARY;
    }

    protected String getEnvVariable(String envVariableName) {
        return System.getenv(envVariableName);
    }

    protected String executeQueryStatusCommand(String[] command) throws IOException {
        String stringCommand = Arrays.toString(command);
        LOGGER.debug("Figuring out if Mule is running by using command {}", (Object)stringCommand);
        Process status = new ProcessBuilder(command).redirectErrorStream(true).start();
        status.getOutputStream().close();
        return IOUtils.toString((InputStream)status.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    private Path resolveMuleBinary(Path muleLocation) throws FileNotFoundException {
        Path muleBinary = muleLocation.resolve(this.getMuleBinaryPath());
        if (!muleBinary.toFile().exists()) {
            throw new FileNotFoundException(String.format("Mule binary does not exists at the expected location [%s]", muleBinary));
        }
        return muleBinary;
    }

    private String sanitizeProcessOutput(String processOutput) {
        return processOutput.replace("\u0000", "");
    }

    private boolean processOutputMatchesExpectedStoppedPattern(String processOutput) {
        return this.fileSystemService.isWindowsOs() ? processOutput.matches(NOT_RUNNING_EXPECTED_WINDOWS_OUTPUT_PATTERN) : processOutput.matches(NOT_RUNNING_EXPECTED_UNIX_OUTPUT_PATTERN);
    }
}

