/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.domain.SemVer;
import com.mulesoft.runtime.upgrade.tool.domain.enums.RollbackPrecondition;
import com.mulesoft.runtime.upgrade.tool.domain.enums.UpgradePrecondition;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.ConfigFilesService;
import com.mulesoft.runtime.upgrade.tool.service.api.DistroPatchService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleStatusService;
import com.mulesoft.runtime.upgrade.tool.service.api.PreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import com.mulesoft.runtime.upgrade.tool.utils.ClassLoaderService;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultPreconditionsValidatorService
implements PreconditionsValidatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPreconditionsValidatorService.class);
    public static final String NOT_ALL_PRECONDITIONS_WERE_MET_PREFIX = "Not all preconditions are met";
    public static final String UPGRADE_EXCEPTION_MESSAGE_NOT_ALL_PRECONDITIONS_WERE_MET = "Not all preconditions are met to perform the upgrade. Review the log for details.";
    public static final String ROLLBACK_EXCEPTION_MESSAGE_NOT_ALL_PRECONDITIONS_WERE_MET = "Not all preconditions are met to perform the rollback. Review the log for details.";
    public static final String CONFIG_FILES_CONFLICTS_WERE_FOUND_PREFIX = "Config Files conflicts were found";
    public static final String UPGRADE_EXCEPTION_MESSAGE_USER_DISAGREE = "User interruption, finishing execution.";
    public static final String UNSUPPORTED_MULE_VERSION_FOR_UPGRADE_MESSAGE = "Your Mule version is not supported for an upgrade, you need a version equal or superior to 4.1.5.";
    @Autowired
    private BackupService backupService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private MuleStatusService statusService;
    @Autowired
    private UserInteractionService userInteractionService;
    @Autowired
    private DistroPatchService patchService;
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private ClassLoaderService classLoaderService;
    @Autowired
    private ConfigFilesService configFilesService;

    public void checkUpgradeReadiness(MuleDistribution oldMule, MuleDistribution newMule, boolean force, boolean isDryRun) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the upgrade are met...");
        EnumMap<UpgradePrecondition, Boolean> preconditionsMet = new EnumMap<UpgradePrecondition, Boolean>(UpgradePrecondition.class);
        EnumMap<UpgradePrecondition, Boolean> consentPreconditionsMet = new EnumMap<UpgradePrecondition, Boolean>(UpgradePrecondition.class);
        preconditionsMet.put(UpgradePrecondition.OLD_AND_NEW_MULE_VERSIONS_ARE_SUPPORTED, this.checkMuleUpgradeIsSupported(oldMule.getVersion(), newMule.getVersion()));
        preconditionsMet.put(UpgradePrecondition.NEW_MULE_IS_NEWER, this.checkNewMuleIsNewer(oldMule.getVersion(), newMule.getVersion()));
        preconditionsMet.put(UpgradePrecondition.OLD_MULE_WRITING_PERMISSIONS, this.checkWritingPermissions(oldMule.getLocation()));
        preconditionsMet.put(UpgradePrecondition.NEW_MULE_READING_PERMISSIONS, this.checkReadingPermissions(newMule.getLocation()));
        preconditionsMet.put(UpgradePrecondition.FILE_SYSTEM_SPACE, this.checkEnoughUsableSpace(oldMule.getLocation(), newMule.getLocation()));
        preconditionsMet.put(UpgradePrecondition.OLD_MULE_NOT_RUNNING, this.isMuleStopped(oldMule.getLocation()));
        preconditionsMet.put(UpgradePrecondition.CONFIG_FILES_CONFLICTS, this.checkConflictsInConfigFiles(oldMule.getLocation(), newMule.getLocation(), isDryRun));
        if (preconditionsMet.values().contains(false)) {
            throw new IllegalStateException(UPGRADE_EXCEPTION_MESSAGE_NOT_ALL_PRECONDITIONS_WERE_MET);
        }
        consentPreconditionsMet.put(UpgradePrecondition.CONSENT_TO_OVERWRITE_BACKUP, this.getConsentForOverwritingBackup(oldMule.getLocation(), force));
        consentPreconditionsMet.put(UpgradePrecondition.CONSENT_TO_REMOVE_APPLIED_PATCHES, this.getConsentForRemovingAppliedPatches(oldMule.getLocation(), force));
        if (consentPreconditionsMet.values().contains(false)) {
            throw new IllegalStateException(UPGRADE_EXCEPTION_MESSAGE_USER_DISAGREE);
        }
    }

    private boolean checkNewMuleIsNewer(SemVer oldDistro, SemVer newDistro) {
        if (oldDistro.compareTo(newDistro) >= 0) {
            LOGGER.error("Version of new Mule distribution {} should be newer than old Mule distribution: {}", (Object)newDistro, (Object)oldDistro);
            return false;
        }
        return true;
    }

    public void checkRollbackReadiness(Path muleDistroLocation) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the rollback are met...");
        EnumMap<RollbackPrecondition, Boolean> preconditionsMet = new EnumMap<RollbackPrecondition, Boolean>(RollbackPrecondition.class);
        preconditionsMet.put(RollbackPrecondition.BACKUP, this.checkBackupExistence(muleDistroLocation));
        preconditionsMet.put(RollbackPrecondition.BACKUP_INTEGRITY, this.checkBackupIntegrity(muleDistroLocation));
        preconditionsMet.put(RollbackPrecondition.WRITING_PERMISSIONS, this.checkWritingPermissions(muleDistroLocation));
        preconditionsMet.put(RollbackPrecondition.MULE_NOT_RUNNING, this.isMuleStopped(muleDistroLocation));
        if (preconditionsMet.values().contains(false)) {
            throw new IllegalStateException(ROLLBACK_EXCEPTION_MESSAGE_NOT_ALL_PRECONDITIONS_WERE_MET);
        }
    }

    public boolean getConsentForOverwritingBackup(Path distroLocation, boolean force) throws IOException {
        Optional backupDescriptor = this.backupService.readBackupDescriptor(distroLocation);
        if (!backupDescriptor.isPresent()) {
            LOGGER.debug("No existent backup found for Mule Runtime distribution: [{}]", (Object)distroLocation);
            return true;
        }
        LOGGER.info("Backup found for Mule Runtime distribution: [{}]", (Object)distroLocation);
        String backupDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
        LOGGER.info(backupDescriptorPrettyFormatted);
        if (force) {
            LOGGER.debug("Consent to overwrite backup is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("overwrite backup", "Could backup be overwritten?", false);
    }

    private boolean getConsentForRemovingAppliedPatches(Path distroLocation, boolean force) throws IOException {
        List appliedPatches = this.patchService.getAppliedPatches(distroLocation);
        if (appliedPatches.isEmpty()) {
            LOGGER.debug("No applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
            return true;
        }
        LOGGER.info("Applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
        String appliedPatchesListPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatAppliedPatches((List)appliedPatches));
        LOGGER.info(appliedPatchesListPrettyFormatted);
        if (force) {
            LOGGER.debug("Consent to remove applied patches is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("remove patches", "Could patched be removed?", false);
    }

    public boolean checkBackupExistence(Path muleDistroLocation) throws IOException {
        Optional backupDescriptor = this.backupService.readBackupDescriptor(muleDistroLocation);
        if (!backupDescriptor.isPresent()) {
            LOGGER.error("Backup does not exist for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
        } else {
            LOGGER.debug("Backup found for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
            String backUpDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
            LOGGER.debug(backUpDescriptorPrettyFormatted);
        }
        return backupDescriptor.isPresent();
    }

    public List<String> checkBackupIntegrityAndGetErrorMessage(Path muleDistroLocation) throws IOException {
        if (!this.backupService.checkIntegrity(muleDistroLocation)) {
            return this.getBackupIntegrityErrorMessages(muleDistroLocation);
        }
        return new LinkedList<String>();
    }

    public List<String> getBackupIntegrityErrorMessages(Path muleDistroLocation) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        String backupErrorMessage = String.format("Backup integrity check wasn't successful for Mule Runtime distribution: [%s]", muleDistroLocation);
        errorMessages.add(backupErrorMessage);
        return errorMessages;
    }

    public boolean checkBackupIntegrity(Path muleDistroLocation) throws IOException {
        if (this.backupService.checkIntegrity(muleDistroLocation)) {
            LOGGER.debug("Backup integrity check was successful for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
            return true;
        }
        this.getBackupIntegrityErrorMessages(muleDistroLocation).stream().forEachOrdered(arg_0 -> ((Logger)LOGGER).error(arg_0));
        return false;
    }

    public boolean checkMuleUpgradeIsSupported(SemVer currentMule, SemVer newMule) {
        SemVer lowestSupportedVersion = SemVer.valueOf((String)"4.1.5");
        if (currentMule.compareTo(lowestSupportedVersion) < 0 || newMule.compareTo(lowestSupportedVersion) < 0) {
            LOGGER.error(UNSUPPORTED_MULE_VERSION_FOR_UPGRADE_MESSAGE);
            return false;
        }
        return true;
    }

    private boolean checkWritingPermissions(Path muleDistroLocation) {
        try {
            this.fileSystemService.checkWritingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Writing permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error validating required writing permissions under Mule distribution [%s]", muleDistroLocation), (Throwable)e);
            return false;
        }
    }

    private boolean checkEnoughUsableSpace(Path oldMule, Path newMule) {
        try {
            this.fileSystemService.checkEnoughUsableSpace(oldMule, newMule, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("There's enough disk space for performing the upgrade.");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("There's not enough disk space for performing the upgrade.");
            return false;
        }
    }

    private boolean checkReadingPermissions(Path muleDistroLocation) {
        try {
            this.fileSystemService.checkReadingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Reading permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error validating required reading permissions under Mule distribution [%s]", muleDistroLocation), (Throwable)e);
            return false;
        }
    }

    private boolean isMuleStopped(Path muleDistroLocation) throws IOException {
        try {
            this.statusService.checkStopped(muleDistroLocation);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Mule Runtime should be stopped.");
            return false;
        }
        LOGGER.debug("Mule Distribution located at [{}] is stopped.", (Object)muleDistroLocation);
        return true;
    }

    private boolean checkConflictsInConfigFiles(Path oldMule, Path newMule, boolean isDryRunMode) throws IOException {
        if (this.configFilesService.checkConflicts(oldMule, newMule, isDryRunMode)) {
            LOGGER.debug("Config Files conflicts check was successful for Mule Runtime distributions: [{}] and [{}]", (Object)oldMule, (Object)newMule);
            return true;
        }
        String docsPage = this.configFilesService.getSolveConflictsDocsPage();
        LOGGER.error("Config Files conflicts were found for Mule Runtime distributions: [{}] and [{}]. Check the files located at [{}] and after review each file move them to the [{}] folder. Finally run the upgrade command again. For more details please go to the docs page '{}'", new Object[]{oldMule, newMule, oldMule.relativize(this.configFilesService.getToReviewFolderInDistro(oldMule)), oldMule.relativize(this.configFilesService.getReadyFolderInDistro(oldMule)), docsPage});
        return false;
    }
}

