/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.CommandOptions;
import com.mulesoft.runtime.upgrade.tool.domain.enums.FileToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.PreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.RollbackService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRollbackService
implements RollbackService {
    public static final String USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE = "User has rejected to proceed with the rollback process";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRollbackService.class);
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private PreconditionsValidatorService preconditionsValidatorService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private UserInteractionService userInteractionService;
    @Autowired
    private DescriptorService descriptorService;
    @Autowired
    private BackupService backupService;

    public void rollback(Path muleDistroLocation, CommandOptions commandOptions) throws IOException {
        LOGGER.info("Preparing rollback process...");
        this.fileSystemService.checkIsADirectory(muleDistroLocation);
        this.preconditionsValidatorService.checkRollbackReadiness(muleDistroLocation);
        this.muleDistroService.checkClusterModeIsActive(muleDistroLocation);
        try {
            this.descriptorService.compareMuleDistros(muleDistroLocation);
        }
        catch (Exception e) {
            LOGGER.warn("Failed while comparing specified version with the backup. Will continue with the upgrade process.\n\tError message: {}", (Object)e.getMessage());
        }
        this.requestUsersConfirmation(commandOptions.isForce());
        try {
            LOGGER.info("Rolling back the Mule Runtime distribution.");
            this.copyBackFiles(muleDistroLocation, commandOptions.isDryRun());
            LOGGER.info("Rollback process finished successfully.");
            if (this.muleDistroService.checkMisleadingMuleDirName(muleDistroLocation)) {
                LOGGER.warn("A version in your MULE_HOME directory name was detected: {}, beware it may not match the current installed version inside the directory.", (Object)muleDistroLocation);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to copy back files from the backup. Consider re-trying the operation after having solved the underlying failure condition, if any", e);
        }
        this.fileSystemService.deleteUpgradeFolderIfEmpty(muleDistroLocation, commandOptions.isDryRun());
    }

    private void requestUsersConfirmation(boolean force) throws IOException {
        if (!force && !this.userInteractionService.confirmAction("rollback upgrade", "Do you want to proceed with the rollback?", false)) {
            throw new IllegalStateException(USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE);
        }
    }

    protected void copyBackFiles(Path distroLocation, boolean isDryRunMode) throws IOException {
        Path backupFolder = this.backupService.getBackupDestDir(distroLocation);
        LOGGER.debug("Copying backed up files from [{}] to [{}]...", (Object)backupFolder, (Object)distroLocation);
        this.fileSystemService.copyFiles(backupFolder, distroLocation, PathDefinitionUtils.getAllDefinedPaths(), FileToBeExcluded.getAllPaths(), isDryRunMode);
    }
}

