/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.excel;

import com.mulesoft.weave.model.Evaluable;
import com.mulesoft.weave.model.EvaluationContext;
import com.mulesoft.weave.model.structure.ArraySeq;
import com.mulesoft.weave.model.structure.KeyValuePair;
import com.mulesoft.weave.model.structure.ObjectSeq;
import com.mulesoft.weave.model.structure.QualifiedName;
import com.mulesoft.weave.model.structure.schema.Schema;
import com.mulesoft.weave.model.types.ArrayType$;
import com.mulesoft.weave.model.types.BooleanType$;
import com.mulesoft.weave.model.types.DateTimeType$;
import com.mulesoft.weave.model.types.KeyType$;
import com.mulesoft.weave.model.types.LocalDateTimeType$;
import com.mulesoft.weave.model.types.LocalDateType$;
import com.mulesoft.weave.model.types.NumberType$;
import com.mulesoft.weave.model.types.ObjectType$;
import com.mulesoft.weave.model.types.StringType$;
import com.mulesoft.weave.model.types.TimeType$;
import com.mulesoft.weave.model.values.Value;
import com.mulesoft.weave.module.ConfigurableReaderWriter;
import com.mulesoft.weave.module.excel.ExcelSettings;
import com.mulesoft.weave.module.pojo.writer.converter.DataConverter;
import com.mulesoft.weave.module.pojo.writer.converter.DataConverter$;
import com.mulesoft.weave.module.pojo.writer.converter.JavaDataConverter;
import com.mulesoft.weave.module.writer.Writer;
import com.mulesoft.weave.parser.location.Location;
import com.mulesoft.weave.parser.location.LocationCapable;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u00015\u00111\"\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\ta!\\8ek2,'BA\u0004\t\u0003\u00159X-\u0019<f\u0015\tI!\"\u0001\u0005nk2,7o\u001c4u\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\r]\u0014\u0018\u000e^3s\u0013\tIbC\u0001\u0004Xe&$XM\u001d\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005\u0011qn\u001d\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n!![8\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\u000e%\u0001\u0004a\u0002bB\u0016\u0001\u0005\u0004%\t\u0005L\u0001\tg\u0016$H/\u001b8hgV\tQ\u0006\u0005\u0002)]%\u0011qF\u0001\u0002\u000e\u000bb\u001cW\r\\*fiRLgnZ:\t\rE\u0002\u0001\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005\u0003\u00054\u0001!\u0015\r\u0011\"\u00015\u0003\t9(-F\u00016!\t1\u0014)D\u00018\u0015\tA\u0014(A\u0005tiJ,\u0017-\\5oO*\u0011!hO\u0001\u0005qN\u001chM\u0003\u0002={\u0005\u0019\u0001o\\5\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u0012Qb\u0015-T'\u001a;vN]6c_>\\\u0007\u0002\u0003#\u0001\u0011\u0003\u0005\u000b\u0015B\u001b\u0002\u0007]\u0014\u0007\u0005C\u0003G\u0001\u0011\u0005s)\u0001\u0004sKN,H\u000e^\u000b\u0002\u0011B\u0011q\"S\u0005\u0003\u0015B\u00111!\u00118z\u0011\u0015a\u0005\u0001\"\u0011N\u0003)9(/\u001b;f-\u0006dW/\u001a\u000b\u0003\u001dj#\"a\u0014*\u0011\u0005=\u0001\u0016BA)\u0011\u0005\u0011)f.\u001b;\t\u000bM[\u00059\u0001+\u0002\u0007\r$\b\u0010\u0005\u0002V16\taK\u0003\u0002X\r\u0005)Qn\u001c3fY&\u0011\u0011L\u0016\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\b\"B.L\u0001\u0004a\u0016!\u0002<bYV,\u0007GA/f!\rq\u0016mY\u0007\u0002?*\u0011\u0001MV\u0001\u0007m\u0006dW/Z:\n\u0005\t|&!\u0002,bYV,\u0007C\u00013f\u0019\u0001!\u0011B\u001a.\u0002\u0002\u0003\u0005)\u0011A4\u0003\u0007}#\u0013'\u0005\u0002i\u0011B\u0011q\"[\u0005\u0003UB\u0011qAT8uQ&tw\rC\u0003m\u0001\u0011\u0005Q.\u0001\u0006xe&$Xm\u00155fKR$2A\u001c9z)\tyu\u000eC\u0003TW\u0002\u000fA\u000bC\u0003rW\u0002\u0007!/A\u0005tQ\u0016,GOT1nKB\u00111O\u001e\b\u0003\u001fQL!!\u001e\t\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kBAQA_6A\u0002m\fAb\u001d5fKR\u001cuN\u001c;f]R\u0004\"\u0001`@\u000e\u0003uT!A ,\u0002\u0013M$(/^2ukJ,\u0017bAA\u0001{\nA\u0011I\u001d:bsN+\u0017\u000fC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u001f\u0011|wK]5uK\u001aK'o\u001d;S_^$\u0002\"!\u0003\u0002\u000e\u0005]\u0011\u0011\u0005\u000b\u0004\u001f\u0006-\u0001BB*\u0002\u0004\u0001\u000fA\u000b\u0003\u0005\u0002\u0010\u0005\r\u0001\u0019AA\t\u0003\u0015\u0019\b.Z3u!\r1\u00141C\u0005\u0004\u0003+9$AC*Y'N35\u000b[3fi\"A\u0011\u0011DA\u0002\u0001\u0004\tY\"\u0001\u0005s_^4\u0016\r\\;f!\ra\u0018QD\u0005\u0004\u0003?i(!C(cU\u0016\u001cGoU3r\u0011!\t\u0019#a\u0001A\u0002\u0005\u0015\u0012A\u0002:po:+X\u000eE\u0002\u0010\u0003OI1!!\u000b\u0011\u0005\rIe\u000e\u001e\u0005\b\u0003[\u0001A\u0011AA\u0018\u0003)!wn\u0016:ji\u0016\u0014vn\u001e\u000b\u0007\u0003c\t)$a\u0010\u0015\u0007=\u000b\u0019\u0004\u0003\u0004T\u0003W\u0001\u001d\u0001\u0016\u0005\t\u0003o\tY\u00031\u0001\u0002:\u0005\u0019!o\\<\u0011\u0007Y\nY$C\u0002\u0002>]\u0012\u0001b\u0015-T'\u001a\u0013vn\u001e\u0005\t\u00033\tY\u00031\u0001\u0002\u001c!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013!C<sSR,7)\u001a7m)\u0019\t9%a\u0013\u0002VQ\u0019q*!\u0013\t\rM\u000b\t\u0005q\u0001U\u0011!\ti%!\u0011A\u0002\u0005=\u0013\u0001B2fY2\u00042ANA)\u0013\r\t\u0019f\u000e\u0002\n'b\u001b6KR\"fY2D\u0001\"a\u0016\u0002B\u0001\u0007\u0011\u0011L\u0001\nG\u0016dGNV1mk\u0016\u0004D!a\u0017\u0002`A!a,YA/!\r!\u0017q\f\u0003\f\u0003C\n)&!A\u0001\u0002\u000b\u0005qMA\u0002`IIBq!!\u001a\u0001\t\u0003\t9'A\ttKR\u001cU\r\u001c7ECR\fgi\u001c:nCR$RaTA5\u0003WB\u0001\"!\u0014\u0002d\u0001\u0007\u0011q\n\u0005\b\u0003[\n\u0019\u00071\u0001s\u0003\u00191wN]7bi\"9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0014!B2m_N,G#A(")
public class ExcelWriter
implements Writer {
    private final OutputStream os;
    private final ExcelSettings settings;
    private SXSSFWorkbook wb;
    private volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
            return this.wb;
        }
    }

    public void startDocument(LocationCapable location) {
        Writer.class.startDocument((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.class.defineNamespace((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public void endDocument(LocationCapable location) {
        Writer.class.endDocument((Writer)this, (LocationCapable)location);
    }

    public void flush() {
        Writer.class.flush((Writer)this);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.class.setOption((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    public SXSSFWorkbook wb() {
        return this.bitmap$0 ? this.wb : this.wb$lzycompute();
    }

    public Object result() {
        return this.os;
    }

    public void writeValue(Value<?> value, EvaluationContext ctx) {
        ObjectSeq objectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ObjectType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
        objectSeq.foreach((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExcelWriter $outer;
            private final EvaluationContext ctx$1;

            public final void apply(Value<KeyValuePair> keyValuePairValue) {
                KeyValuePair keyValuePair = (KeyValuePair)keyValuePairValue.evaluate(this.ctx$1);
                String sheetName = ((QualifiedName)keyValuePair._1().evaluate(this.ctx$1)).name();
                ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ArrayType$.MODULE$.coerce$default$2(), this.ctx$1).evaluate(this.ctx$1);
                this.$outer.writeSheet(sheetName, sheetContent, this.ctx$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$1 = ctx$1;
            }
        });
        this.wb().write(this.os);
    }

    public void writeSheet(String sheetName, ArraySeq sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ObjectType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ObjectType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        while (rowValue.hasNext()) {
            SXSSFCell headerCell = row0.createCell(colNumber);
            Value cellValue = (Value)rowValue.next();
            KeyValuePair keyValuePair = (KeyValuePair)cellValue.evaluate(ctx);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), KeyType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        while (rowValue.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)((Evaluable)rowValue.next()).evaluate(ctx))._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = (String)StringType$.MODULE$.coerce(value, StringType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, BooleanType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, NumberType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, TimeType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern((String)"HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, DateTimeType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, LocalDateType$.MODULE$.coerce$default$2(), ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.schema(ctx).map((Function1)new Serializable(this, ctx){
                public static final long serialVersionUID = 0L;
                private final EvaluationContext ctx$2;

                public final Schema apply(Value<Schema> x$1) {
                    return (Schema)x$1.evaluate(this.ctx$2);
                }
                {
                    this.ctx$2 = ctx$2;
                }
            }), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.os.close();
    }

    public ExcelWriter(OutputStream os) {
        this.os = os;
        ConfigurableReaderWriter.class.$init$((ConfigurableReaderWriter)this);
        Writer.class.$init$((Writer)this);
        this.settings = new ExcelSettings();
    }
}

