/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.flatfile;

import com.mulesoft.flatfile.schema.EdiSchema;
import com.mulesoft.flatfile.schema.YamlReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SchemaCache$ {
    public static final SchemaCache$ MODULE$;
    private final ConcurrentHashMap<String, Tuple2<Object, EdiSchema>> schemaFileCache;
    private final WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> contextMapCache;

    static {
        new SchemaCache$();
    }

    public ConcurrentHashMap<String, Tuple2<Object, EdiSchema>> schemaFileCache() {
        return this.schemaFileCache;
    }

    public WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> contextMapCache() {
        return this.contextMapCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EdiSchema loadCachedFileSchema(File file) {
        EdiSchema ediSchema;
        String abspath = file.getAbsolutePath();
        if (this.schemaFileCache().containsKey(abspath)) {
            Tuple2 tuple2;
            Tuple2<Object, EdiSchema> tuple22 = this.schemaFileCache().get(abspath);
            if (tuple22 == null) throw new MatchError(tuple22);
            long modified = tuple22._1$mcJ$sp();
            EdiSchema schema = (EdiSchema)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)modified), (Object)schema);
            long modified2 = tuple23._1$mcJ$sp();
            EdiSchema schema2 = (EdiSchema)tuple23._2();
            if (modified2 >= file.lastModified()) {
                ediSchema = schema2;
                return ediSchema;
            } else {
                this.schemaFileCache().remove(abspath);
                ediSchema = this.fileToCache$1(file, abspath);
            }
            return ediSchema;
        } else {
            ediSchema = this.fileToCache$1(file, abspath);
        }
        return ediSchema;
    }

    public EdiSchema loadCachedClasspathSchema(String path, ClassLoader ctx, ConcurrentHashMap<String, EdiSchema> map) {
        EdiSchema ediSchema;
        if (map.containsKey(path)) {
            ediSchema = map.get(path);
        } else {
            InputStream inputStream;
            InputStream is0 = this.getClass().getResourceAsStream(path);
            if (is0 == null) {
                String relpath = path.startsWith("/") ? path.substring(1) : path;
                InputStream is1 = this.getClass().getClassLoader().getResourceAsStream(relpath);
                if (is1 == null) {
                    InputStream is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(relpath);
                    if (is2 == null) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file ", " not found on any classpath"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                    }
                    inputStream = is2;
                } else {
                    inputStream = is1;
                }
            } else {
                inputStream = is0;
            }
            InputStream is = inputStream;
            InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));
            EdiSchema schema = new YamlReader().loadYaml((Reader)reader, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            map.put(path, schema);
            ediSchema = schema;
        }
        return ediSchema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EdiSchema loadCached(String path) {
        EdiSchema ediSchema;
        File file = new File(path);
        if (file.exists()) {
            ediSchema = this.loadCachedFileSchema(file);
            return ediSchema;
        }
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> weakHashMap = this.contextMapCache();
        synchronized (weakHashMap) {
            ConcurrentHashMap<String, Object> concurrentHashMap;
            if (this.contextMapCache().containsKey(context)) {
                concurrentHashMap = this.contextMapCache().get(context);
            } else {
                ConcurrentHashMap newmap = new ConcurrentHashMap();
                this.contextMapCache().put(context, newmap);
                concurrentHashMap = newmap;
            }
            ConcurrentHashMap<String, EdiSchema> concurrentHashMap2 = concurrentHashMap;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : weakHashMap
            ConcurrentHashMap<String, EdiSchema> ctxmap = concurrentHashMap2;
            ediSchema = this.loadCachedClasspathSchema(path, context, ctxmap);
            return ediSchema;
        }
    }

    private final EdiSchema fileToCache$1(File file$1, String abspath$1) {
        long modified = file$1.lastModified();
        FileReader reader = new FileReader(file$1);
        EdiSchema schema = new YamlReader().loadYaml((Reader)reader, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        this.schemaFileCache().put(abspath$1, (Tuple2<Object, EdiSchema>)new Tuple2((Object)BoxesRunTime.boxToLong((long)modified), (Object)schema));
        return schema;
    }

    private SchemaCache$() {
        MODULE$ = this;
        this.schemaFileCache = new ConcurrentHashMap();
        this.contextMapCache = new WeakHashMap();
    }
}

