/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.model.values.coercion;

import com.mulesoft.weave.model.EvaluationContext;
import com.mulesoft.weave.model.structure.schema.Schema;
import com.mulesoft.weave.model.types.DateTimeType$;
import com.mulesoft.weave.model.types.NumberType$;
import com.mulesoft.weave.model.types.StringType$;
import com.mulesoft.weave.model.types.Type;
import com.mulesoft.weave.model.values.NumberValue;
import com.mulesoft.weave.model.values.NumberValue$;
import com.mulesoft.weave.model.values.Value;
import com.mulesoft.weave.model.values.coercion.NumberCoercer$;
import com.mulesoft.weave.model.values.coercion.ValueCoercer;
import com.mulesoft.weave.model.values.coercion.exception.InvalidNumberException;
import com.mulesoft.weave.model.values.coercion.exception.InvalidUnitException;
import com.mulesoft.weave.model.values.coercion.exception.UnsupportedTypeCoercionException;
import com.mulesoft.weave.model.values.coercion.exception.UnsupportedTypeCoercionException$;
import com.mulesoft.weave.parser.ast.structure.schema.TimeUnit$;
import com.mulesoft.weave.parser.location.LocationCapable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import spire.math.Number;
import spire.math.Number$;

public final class NumberCoercer$
implements ValueCoercer<NumberValue> {
    public static final NumberCoercer$ MODULE$;

    static {
        new NumberCoercer$();
    }

    @Override
    public NumberValue coerce(Value<?> c, Option<Value<Schema>> schema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        block5: {
            Number number;
            block3: {
                Type type;
                Type type2;
                block4: {
                    Type type3;
                    block2: {
                        Type type4;
                        type2 = c.valueType(evaluationContext);
                        if (type2 == null || !(type4 = type2).isInstanceOf(NumberType$.MODULE$)) break block2;
                        number = (Number)c.evaluate(evaluationContext);
                        break block3;
                    }
                    if (type2 == null || !(type3 = type2).isInstanceOf(DateTimeType$.MODULE$)) break block4;
                    number = this.toNumber(((ZonedDateTime)c.evaluate(evaluationContext)).withZoneSameInstant((ZoneId)ZoneOffset.UTC), schema, locationCapable, evaluationContext);
                    break block3;
                }
                if (type2 == null || !(type = type2).isInstanceOf(StringType$.MODULE$)) break block5;
                number = this.parseNumber((String)c.evaluate(evaluationContext), schema, locationCapable, evaluationContext);
            }
            Number number2 = number;
            return NumberValue$.MODULE$.apply(number2, locationCapable, schema);
        }
        throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$4());
    }

    public Number toNumber(ZonedDateTime zonedDateTime, Option<Value<Schema>> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Option numberMaybe = withSchema.flatMap((Function1)new Serializable(zonedDateTime, locationCapable, ctx){
            public static final long serialVersionUID = 0L;
            public final ZonedDateTime zonedDateTime$1;
            public final LocationCapable locationCapable$1;
            private final EvaluationContext ctx$1;

            public final Option<Number> apply(Value<Schema> schema) {
                return ((Schema)schema.evaluate(this.ctx$1)).unit().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final Number apply(String unit2) {
                        return NumberCoercer$.MODULE$.com$mulesoft$weave$model$values$coercion$NumberCoercer$$toNumber$1(this.$outer.zonedDateTime$1, unit2, this.$outer.zonedDateTime$1, this.$outer.locationCapable$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.zonedDateTime$1 = zonedDateTime$1;
                this.locationCapable$1 = locationCapable$1;
                this.ctx$1 = ctx$1;
            }
        });
        return (Number)numberMaybe.getOrElse((Function0)new Serializable(zonedDateTime){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime zonedDateTime$1;

            public final Number apply() {
                return Number$.MODULE$.apply(NumberCoercer$.MODULE$.com$mulesoft$weave$model$values$coercion$NumberCoercer$$toEpochSecond$1(this.zonedDateTime$1));
            }
            {
                this.zonedDateTime$1 = zonedDateTime$1;
            }
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Number parseNumber(String str, Option<Value<Schema>> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Option<Value<Schema>> option = withSchema;
        if (option instanceof Some) {
            Number number;
            Some some = (Some)option;
            Value schema = (Value)some.x();
            Schema schemaValue = (Schema)schema.evaluate(ctx);
            Option<String> option2 = schemaValue.format();
            if (option2 instanceof Some) {
                Number number2;
                Some some2 = (Some)option2;
                String f = (String)some2.x();
                DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DecimalFormatSymbols apply(String locale2) {
                        return DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale2));
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DecimalFormatSymbols apply() {
                        return DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
                    }
                });
                DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                formatter.setParseBigDecimal(true);
                java.lang.Number number3 = formatter.parse(str);
                if (number3 instanceof Integer) {
                    Integer n = (Integer)number3;
                    number2 = Number$.MODULE$.apply(n.intValue());
                } else if (number3 instanceof Long) {
                    Long l = (Long)number3;
                    number2 = Number$.MODULE$.apply(l.longValue());
                } else if (number3 instanceof Double) {
                    Double d = (Double)number3;
                    number2 = Number$.MODULE$.apply(d.doubleValue());
                } else if (number3 instanceof Float) {
                    Float f2 = (Float)number3;
                    number2 = Number$.MODULE$.apply(f2.floatValue());
                } else if (number3 instanceof BigInteger) {
                    BigInteger bigInteger = (BigInteger)number3;
                    number2 = Number$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger));
                } else {
                    if (!(number3 instanceof BigDecimal)) throw new MatchError((Object)number3);
                    BigDecimal bigDecimal = (BigDecimal)number3;
                    number2 = Number$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
                }
                number = number2;
                return number;
            } else {
                number = Number$.MODULE$.apply(str);
            }
            return number;
        }
        try {
            return Number$.MODULE$.apply(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNumberException(locationCapable.location(), str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNumberException(locationCapable.location(), str);
        }
    }

    public final long com$mulesoft$weave$model$values$coercion$NumberCoercer$$toEpochSecond$1(ZonedDateTime zonedDateTime$1) {
        return zonedDateTime$1.toEpochSecond();
    }

    public final Number com$mulesoft$weave$model$values$coercion$NumberCoercer$$toNumber$1(ZonedDateTime zonedDateTime, String unit2, ZonedDateTime zonedDateTime$1, LocationCapable locationCapable$1) {
        block4: {
            Number number;
            block3: {
                String string;
                block2: {
                    string = unit2.toLowerCase();
                    String string2 = TimeUnit$.MODULE$.MILLISECONDS();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    number = Number$.MODULE$.apply(zonedDateTime.toInstant().toEpochMilli());
                    break block3;
                }
                String string4 = TimeUnit$.MODULE$.SECONDS();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                number = Number$.MODULE$.apply(this.com$mulesoft$weave$model$values$coercion$NumberCoercer$$toEpochSecond$1(zonedDateTime$1));
            }
            return number;
        }
        throw new InvalidUnitException(locationCapable$1.location(), unit2);
    }

    private NumberCoercer$() {
        MODULE$ = this;
    }
}

