/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.parser.phase;

import com.mulesoft.weave.grammar.BinaryOpIdentifier;
import com.mulesoft.weave.grammar.TernaryOpIdentifier;
import com.mulesoft.weave.grammar.UnaryOpIdentifier;
import com.mulesoft.weave.parser.annotation.OpDefinitionAnnotation;
import com.mulesoft.weave.parser.ast.AstNode;
import com.mulesoft.weave.parser.ast.operators.BinaryOpNode;
import com.mulesoft.weave.parser.ast.operators.TernaryOpNode;
import com.mulesoft.weave.parser.ast.operators.UnaryOpNode;
import com.mulesoft.weave.parser.phase.AstNodeTransformer;
import com.mulesoft.weave.parser.phase.ParsingContext;
import com.mulesoft.weave.sdk.WeaveSdk;
import com.mulesoft.weave.ts.OpDefinition;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u001b\t9r\n\u001d#fM&t\u0017\u000e^5p]R\u0013\u0018M\\:g_JlWM\u001d\u0006\u0003\u0007\u0011\tQ\u0001\u001d5bg\u0016T!!\u0002\u0004\u0002\rA\f'o]3s\u0015\t9\u0001\"A\u0003xK\u00064XM\u0003\u0002\n\u0015\u0005AQ.\u001e7fg>4GOC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!AE!ti:{G-\u001a+sC:\u001chm\u001c:nKJDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005U\u0001\u0001\"B\u000f\u0001\t\u0003r\u0012!\u0003;sC:\u001chm\u001c:n)\ry\"E\u000b\t\u0003\u001f\u0001J!!\t\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006Gq\u0001\r\u0001J\u0001\u0005]>$W\r\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005\u0019\u0011m\u001d;\n\u0005%2#aB!ti:{G-\u001a\u0005\u0006Wq\u0001\r\u0001L\u0001\bG>tG/\u001a=u!\t)R&\u0003\u0002/\u0005\tq\u0001+\u0019:tS:<7i\u001c8uKb$\b")
public class OpDefinitionTransformer
implements AstNodeTransformer {
    @Override
    public void transform(AstNode node, ParsingContext context) {
        WeaveSdk sdk = context.weaveSdk();
        AstNode astNode = node;
        if (astNode instanceof BinaryOpNode) {
            BinaryOpNode binaryOpNode = (BinaryOpNode)astNode;
            BinaryOpIdentifier opId = binaryOpNode.opId();
            String name = opId.name();
            Seq<OpDefinition> definitions = sdk.binaryOpDefinitionsWith(name);
            node.annotate(new OpDefinitionAnnotation(definitions));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (astNode instanceof UnaryOpNode) {
            UnaryOpNode unaryOpNode = (UnaryOpNode)astNode;
            UnaryOpIdentifier opId = unaryOpNode.opId();
            String name = opId.name();
            Seq<OpDefinition> definitions = sdk.unaryOpDefinitionsWith(name);
            node.annotate(new OpDefinitionAnnotation(definitions));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (astNode instanceof TernaryOpNode) {
            TernaryOpNode ternaryOpNode = (TernaryOpNode)astNode;
            TernaryOpIdentifier opId = ternaryOpNode.opId();
            String name = opId.name();
            Seq<OpDefinition> definitions = sdk.ternaryOpDefinitionsWith(name);
            node.annotate(new OpDefinitionAnnotation(definitions));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

