/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.ts;

import com.mulesoft.weave.parser.InvalidTypeMessage$;
import com.mulesoft.weave.parser.NotEnoughArgumentMessage$;
import com.mulesoft.weave.parser.TooManyArgumentMessage$;
import com.mulesoft.weave.parser.ast.functions.FunctionNode;
import com.mulesoft.weave.ts.DataGraph;
import com.mulesoft.weave.ts.DataGraph$;
import com.mulesoft.weave.ts.DynamicReturnType;
import com.mulesoft.weave.ts.Edge;
import com.mulesoft.weave.ts.Edge$;
import com.mulesoft.weave.ts.EdgeLabels$;
import com.mulesoft.weave.ts.FunctionType;
import com.mulesoft.weave.ts.FunctionTypeParameter;
import com.mulesoft.weave.ts.FunctionTypeParameter$;
import com.mulesoft.weave.ts.Node;
import com.mulesoft.weave.ts.TypeHelper$;
import com.mulesoft.weave.ts.UnknownType;
import com.mulesoft.weave.ts.WeaveType;
import com.mulesoft.weave.ts.WeaveTypeParametersContext;
import com.mulesoft.weave.ts.WeaveTypeResolutionContext;
import com.mulesoft.weave.ts.WeaveTypeResolver;
import com.mulesoft.weave.ts.WeaveTypeResolver$class;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;

public final class FunctionCallNodeResolver$
implements WeaveTypeResolver {
    public static final FunctionCallNodeResolver$ MODULE$;

    static {
        new FunctionCallNodeResolver$();
    }

    @Override
    public boolean supportsPartialResolution() {
        return WeaveTypeResolver$class.supportsPartialResolution(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<WeaveType> execute(Node node, WeaveTypeResolutionContext ctx) {
        Edge functionReference = (Edge)node.incomingEdges().head();
        WeaveType functionType = functionReference.incomingType();
        Seq parameters = (Seq)node.incomingEdges().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Edge edge) {
                return edge.label().equals(EdgeLabels$.MODULE$.PARAMETER());
            }
        });
        Seq parameterTypes = (Seq)parameters.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WeaveType apply(Edge x$6) {
                return x$6.incomingType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        WeaveType weaveType = functionType;
        if (weaveType instanceof FunctionType) {
            None$ none$;
            FunctionType functionType2 = (FunctionType)weaveType;
            Seq<FunctionTypeParameter> args = functionType2.args();
            WeaveType returnType = functionType2.returnType();
            WeaveTypeParametersContext typeParametersContext = new WeaveTypeParametersContext();
            if (this.validateArgumentTypes(node, (Seq<WeaveType>)parameterTypes, args, typeParametersContext, ctx)) {
                None$ none$2;
                WeaveType weaveType2 = returnType;
                if (weaveType2 instanceof DynamicReturnType) {
                    None$ none$3;
                    DynamicReturnType dynamicReturnType = (DynamicReturnType)weaveType2;
                    FunctionNode functionNode = dynamicReturnType.node();
                    Option<DataGraph> subGraph = ctx.getFunctionSubGraph(functionNode, (Seq<WeaveType>)parameterTypes);
                    Option<DataGraph> option = subGraph;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DataGraph dataGraph = (DataGraph)some.x();
                        Node function = (Node)dataGraph.findNode(functionNode).get();
                        boolean alreadyConnected = node.incomingEdges().exists((Function1)new Serializable(function){
                            public static final long serialVersionUID = 0L;
                            private final Node function$1;

                            public final boolean apply(Edge x$7) {
                                Node node = x$7.source();
                                Node node2 = this.function$1;
                                return !(node != null ? !((Object)node).equals(node2) : node2 != null);
                            }
                            {
                                this.function$1 = function$1;
                            }
                        });
                        Object object = alreadyConnected ? BoxedUnit.UNIT : new Edge(function, node, Edge$.MODULE$.apply$default$3(), Edge$.MODULE$.apply$default$4(), Edge$.MODULE$.apply$default$5());
                        none$3 = function.resultType();
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        DataGraph functionGraph = DataGraph$.MODULE$.apply(ctx.currentGraph(), ctx.scope(), functionNode, (Seq<WeaveType>)parameterTypes);
                        new Edge((Node)functionGraph.findNode(functionNode).get(), node, Edge$.MODULE$.apply$default$3(), Edge$.MODULE$.apply$default$4(), Edge$.MODULE$.apply$default$5());
                        ctx.rootGraph().addSubGraph(functionGraph);
                        ctx.addFunctionSubGraph(functionNode, (Seq<WeaveType>)parameterTypes, functionGraph);
                        functionGraph.initialize(ctx);
                        none$3 = None$.MODULE$;
                    }
                    none$2 = none$3;
                } else {
                    none$2 = new Some((Object)TypeHelper$.MODULE$.resolveTypeVariable(returnType, typeParametersContext, ctx));
                }
                none$ = none$2;
                return none$;
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        FunctionType expectedType = new FunctionType((Seq<FunctionTypeParameter>)((Seq)parameterTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FunctionTypeParameter apply(WeaveType x$8) {
                return new FunctionTypeParameter("arg", x$8, FunctionTypeParameter$.MODULE$.apply$default$3());
            }
        }, Seq$.MODULE$.canBuildFrom())), new UnknownType());
        if (TypeHelper$.MODULE$.canBeAssignedTo(functionType, expectedType, TypeHelper$.MODULE$.canBeAssignedTo$default$3())) return None$.MODULE$;
        node.error(InvalidTypeMessage$.MODULE$.apply(expectedType, functionType));
        return None$.MODULE$;
    }

    public boolean validateArgumentTypes(Node node, Seq<WeaveType> parameterTypes, Seq<FunctionTypeParameter> args, WeaveTypeParametersContext typeParametersContext, WeaveTypeResolutionContext ctx) {
        boolean bl;
        if (parameterTypes.size() > args.size()) {
            node.error(TooManyArgumentMessage$.MODULE$.apply((Seq<WeaveType>)((Seq)args.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WeaveType apply(FunctionTypeParameter x$9) {
                    return x$9.wtype();
                }
            }, Seq$.MODULE$.canBuildFrom())), parameterTypes));
            bl = false;
        } else {
            Seq requiredArgumentTypes = (Seq)args.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FunctionTypeParameter x$10) {
                    return !x$10.optional();
                }
            });
            if (parameterTypes.size() < requiredArgumentTypes.size()) {
                node.error(NotEnoughArgumentMessage$.MODULE$.apply((Seq<WeaveType>)((Seq)requiredArgumentTypes.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final WeaveType apply(FunctionTypeParameter x$11) {
                        return x$11.wtype();
                    }
                }, Seq$.MODULE$.canBuildFrom())), parameterTypes));
                bl = false;
            } else {
                bl = requiredArgumentTypes.size() == parameterTypes.size() ? !((IterableLike)requiredArgumentTypes.zip(parameterTypes, Seq$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(node, typeParametersContext, ctx){
                    public static final long serialVersionUID = 0L;
                    private final Node node$2;
                    private final WeaveTypeParametersContext typeParametersContext$1;
                    private final WeaveTypeResolutionContext ctx$1;

                    public final boolean apply(Tuple2<FunctionTypeParameter, WeaveType> arguments) {
                        boolean bl;
                        WeaveType expectedType = ((FunctionTypeParameter)arguments._1()).wtype();
                        WeaveType actualType = FunctionCallNodeResolver$.MODULE$.inferDynamicTypes(expectedType, (WeaveType)arguments._2(), this.typeParametersContext$1, this.ctx$1);
                        if (TypeHelper$.MODULE$.canBeAssignedTo(actualType, expectedType, this.typeParametersContext$1)) {
                            TypeHelper$.MODULE$.bindTypeParameters(expectedType, actualType, this.typeParametersContext$1);
                            bl = false;
                        } else {
                            this.node$2.error(InvalidTypeMessage$.MODULE$.apply(expectedType, actualType));
                            bl = true;
                        }
                        return bl;
                    }
                    {
                        this.node$2 = node$2;
                        this.typeParametersContext$1 = typeParametersContext$1;
                        this.ctx$1 = ctx$1;
                    }
                }) : !((IterableLike)args.zip(parameterTypes, Seq$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(node, typeParametersContext, ctx){
                    public static final long serialVersionUID = 0L;
                    private final Node node$2;
                    private final WeaveTypeParametersContext typeParametersContext$1;
                    private final WeaveTypeResolutionContext ctx$1;

                    public final boolean apply(Tuple2<FunctionTypeParameter, WeaveType> arguments) {
                        boolean bl;
                        WeaveType expectedType = ((FunctionTypeParameter)arguments._1()).wtype();
                        WeaveType actualType = FunctionCallNodeResolver$.MODULE$.inferDynamicTypes(expectedType, (WeaveType)arguments._2(), this.typeParametersContext$1, this.ctx$1);
                        if (TypeHelper$.MODULE$.canBeAssignedTo(actualType, expectedType, this.typeParametersContext$1)) {
                            TypeHelper$.MODULE$.bindTypeParameters(expectedType, actualType, this.typeParametersContext$1);
                            bl = false;
                        } else {
                            this.node$2.error(InvalidTypeMessage$.MODULE$.apply(expectedType, actualType));
                            bl = true;
                        }
                        return bl;
                    }
                    {
                        this.node$2 = node$2;
                        this.typeParametersContext$1 = typeParametersContext$1;
                        this.ctx$1 = ctx$1;
                    }
                });
            }
        }
        return bl;
    }

    public WeaveType inferDynamicTypes(WeaveType expectedType, WeaveType actualType, WeaveTypeParametersContext typeParametersContext, WeaveTypeResolutionContext ctx) {
        TypeHelper$.MODULE$.bindTypeParameters(actualType, expectedType, typeParametersContext);
        return TypeHelper$.MODULE$.resolveTypeVariable(actualType, typeParametersContext, ctx);
    }

    private FunctionCallNodeResolver$() {
        MODULE$ = this;
        WeaveTypeResolver$class.$init$(this);
    }
}

