/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJResourceFile;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.IJClassContainer;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.TypedAnnotationWriter;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JPackage
implements IJDeclaration,
IJGenerable,
IJClassContainer<JDefinedClass>,
IJAnnotatable,
Comparable<JPackage>,
IJDocCommentable {
    private final String m_sName;
    private final JCodeModel m_aOwner;
    private final Map<String, JDefinedClass> m_aClasses = new TreeMap<String, JDefinedClass>();
    private final Set<AbstractJResourceFile> m_aResources = new HashSet<AbstractJResourceFile>();
    private final Map<String, JDefinedClass> m_aUpperCaseClassMap;
    private List<JAnnotationUse> m_aAnnotations;
    private JDocComment m_aJavaDoc;

    protected JPackage(@Nonnull String string, @Nonnull JCodeModel jCodeModel) {
        JCValueEnforcer.notNull(string, "Name");
        if (string.equals(".")) {
            throw new IllegalArgumentException("Package name . is not allowed");
        }
        JCValueEnforcer.notNull(jCodeModel, "CodeModel");
        this.m_aOwner = jCodeModel;
        this.m_sName = string;
        this.m_aUpperCaseClassMap = this.m_aOwner.isCaseSensitiveFileSystem ? null : new HashMap<String, JDefinedClass>();
    }

    @Override
    @Nullable
    public IJClassContainer<?> parentContainer() {
        return this.parent();
    }

    @Nullable
    public JPackage parent() {
        if (this.isUnnamed()) {
            return null;
        }
        int n = this.m_sName.lastIndexOf(46);
        if (n < 0) {
            return this.m_aOwner.rootPackage();
        }
        return this.m_aOwner._package(this.m_sName.substring(0, n));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    @Nonnull
    public JPackage getPackage() {
        return this;
    }

    @Override
    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string) throws JClassAlreadyExistsException {
        return this._class(n, string, EClassType.CLASS);
    }

    @Override
    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string, @Nonnull EClassType eClassType) throws JClassAlreadyExistsException {
        if (this.m_aClasses.containsKey(string)) {
            throw new JClassAlreadyExistsException(this.m_aClasses.get(string));
        }
        JDefinedClass jDefinedClass = new JDefinedClass(this, n, string, eClassType);
        if (this.m_aUpperCaseClassMap != null) {
            String string2 = string.toUpperCase();
            JDefinedClass jDefinedClass2 = this.m_aUpperCaseClassMap.get(string2);
            if (jDefinedClass2 != null) {
                throw new JClassAlreadyExistsException(jDefinedClass2);
            }
            this.m_aUpperCaseClassMap.put(string2, jDefinedClass);
        }
        this.m_aClasses.put(string, jDefinedClass);
        return jDefinedClass;
    }

    @Override
    @Nonnull
    public JDefinedClass _class(@Nonnull String string) throws JClassAlreadyExistsException {
        return this._class(1, string);
    }

    @Nullable
    public JDefinedClass _getClass(@Nullable String string) {
        return this.m_aClasses.get(string);
    }

    @Override
    public int compareTo(@Nonnull JPackage jPackage) {
        return this.m_sName.compareTo(jPackage.m_sName);
    }

    @Override
    @Nonnull
    public JDefinedClass _interface(int n, @Nonnull String string) throws JClassAlreadyExistsException {
        return this._class(n, string, EClassType.INTERFACE);
    }

    @Override
    @Nonnull
    public JDefinedClass _interface(@Nonnull String string) throws JClassAlreadyExistsException {
        return this._interface(1, string);
    }

    @Override
    @Nonnull
    public JDefinedClass _annotationTypeDeclaration(int n, @Nonnull String string) throws JClassAlreadyExistsException {
        return this._class(n, string, EClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    @Nonnull
    public JDefinedClass _annotationTypeDeclaration(@Nonnull String string) throws JClassAlreadyExistsException {
        return this._annotationTypeDeclaration(1, string);
    }

    @Override
    @Nonnull
    public JDefinedClass _enum(int n, @Nonnull String string) throws JClassAlreadyExistsException {
        return this._class(n, string, EClassType.ENUM);
    }

    @Override
    @Nonnull
    public JDefinedClass _enum(@Nonnull String string) throws JClassAlreadyExistsException {
        return this._enum(1, string);
    }

    @Nonnull
    public AbstractJResourceFile addResourceFile(@Nonnull AbstractJResourceFile abstractJResourceFile) {
        JCValueEnforcer.notNull(abstractJResourceFile, "ResourceFile");
        this.m_aResources.add(abstractJResourceFile);
        return abstractJResourceFile;
    }

    public boolean hasResourceFile(@Nullable String string) {
        for (AbstractJResourceFile abstractJResourceFile : this.m_aResources) {
            if (!abstractJResourceFile.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Iterator<AbstractJResourceFile> propertyFiles() {
        return this.m_aResources.iterator();
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJavaDoc == null) {
            this.m_aJavaDoc = new JDocComment(this.owner());
        }
        return this.m_aJavaDoc;
    }

    public void remove(@Nonnull AbstractJClass abstractJClass) {
        if (abstractJClass._package() != this) {
            throw new IllegalArgumentException("the specified class (" + abstractJClass.fullName() + ") is not a member of this package (" + this.name() + "), or it is a referenced class");
        }
        this.m_aClasses.remove(abstractJClass.name());
        if (this.m_aUpperCaseClassMap != null) {
            this.m_aUpperCaseClassMap.remove(abstractJClass.name().toUpperCase());
        }
    }

    @Nonnull
    public AbstractJClass ref(@Nonnull String string) throws ClassNotFoundException {
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("JClass name contains '.': " + string);
        }
        String string2 = this.isUnnamed() ? "" : this.m_sName + '.';
        string2 = string2 + string;
        return this.m_aOwner.ref(Class.forName(string2));
    }

    @Nonnull
    public JPackage subPackage(@Nonnull String string) {
        if (this.isUnnamed()) {
            return this.owner()._package(string);
        }
        return this.owner()._package(this.m_sName + '.' + string);
    }

    @Override
    @Nonnull
    public Collection<JDefinedClass> classes() {
        return this.m_aClasses.values();
    }

    public boolean isDefined(@Nullable String string) {
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (!jDefinedClass.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.m_sName.length() == 0;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final JCodeModel owner() {
        return this.m_aOwner;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        if (this.isUnnamed()) {
            throw new IllegalArgumentException("the root package cannot be annotated");
        }
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.m_aOwner.ref(clazz));
    }

    @Override
    @Nonnull
    public <W extends IJAnnotationWriter<?>> W annotate2(@Nonnull Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableList(this.m_aAnnotations);
    }

    @Nonnull
    File toPath(@Nonnull File file) {
        if (this.m_sName == null) {
            return file;
        }
        return new File(file, this.m_sName.replace('.', File.separatorChar));
    }

    @Override
    public void declare(@Nonnull JFormatter jFormatter) {
        if (this.m_sName.length() != 0) {
            jFormatter.print("package").print(this.m_sName).print(';').newline();
        }
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print(this.m_sName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build(AbstractCodeWriter abstractCodeWriter, AbstractCodeWriter abstractCodeWriter2) throws IOException {
        for (JDefinedClass object2 : this.m_aClasses.values()) {
            if (object2.isHidden()) continue;
            JFormatter jFormatter = this._createJavaSourceFileWriter(abstractCodeWriter, object2.name());
            jFormatter.write(object2);
            jFormatter.close();
        }
        if (this.m_aAnnotations != null || this.m_aJavaDoc != null) {
            Iterator<AbstractJResourceFile> iterator = this._createJavaSourceFileWriter(abstractCodeWriter, "package-info");
            if (this.m_aJavaDoc != null) {
                ((JFormatter)((Object)iterator)).generable(this.m_aJavaDoc);
            }
            if (this.m_aAnnotations != null) {
                for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
                    ((JFormatter)((Object)iterator)).generable(jAnnotationUse).newline();
                }
            }
            ((JFormatter)((Object)iterator)).declaration(this);
            ((JFormatter)((Object)iterator)).close();
        }
        for (AbstractJResourceFile abstractJResourceFile : this.m_aResources) {
            AbstractCodeWriter abstractCodeWriter3 = abstractJResourceFile.isResource() ? abstractCodeWriter2 : abstractCodeWriter;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(abstractCodeWriter3.openBinary(this, abstractJResourceFile.name()));
            try {
                abstractJResourceFile.build(bufferedOutputStream);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    boolean buildsErrorTypeRefs() {
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden() || !jDefinedClass.containsErrorTypes()) continue;
            return true;
        }
        return false;
    }

    int countArtifacts() {
        int n = 0;
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden()) continue;
            ++n;
        }
        if (this.m_aAnnotations != null || this.m_aJavaDoc != null) {
            ++n;
        }
        return n += this.m_aResources.size();
    }

    @Nonnull
    private JFormatter _createJavaSourceFileWriter(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull String string) throws IOException {
        SourcePrintWriter sourcePrintWriter = abstractCodeWriter.openSource(this, string + ".java");
        return new JFormatter(sourcePrintWriter);
    }
}

