/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JTypeVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractJGenerifiableImpl
implements IJGenerifiable,
IJDeclaration,
IJOwned {
    private Map<String, JTypeVar> _typeVariables;

    @Override
    public void declare(@Nonnull JFormatter jFormatter) {
        if (this._typeVariables != null && !this._typeVariables.isEmpty()) {
            jFormatter.print('<');
            int n = 0;
            for (JTypeVar jTypeVar : this._typeVariables.values()) {
                if (n++ > 0) {
                    jFormatter.print(',');
                }
                jFormatter.declaration(jTypeVar);
            }
            jFormatter.print('\uffff');
        }
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string) {
        JTypeVar jTypeVar = new JTypeVar(this.owner(), string);
        if (this._typeVariables == null) {
            this._typeVariables = new LinkedHashMap<String, JTypeVar>(3);
        } else if (this._typeVariables.containsKey(string)) {
            throw new IllegalArgumentException("A type parameter with name '" + string + "' is already present!");
        }
        this._typeVariables.put(string, jTypeVar);
        return jTypeVar;
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string, @Nonnull Class<?> clazz) {
        return this.generify(string, this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string, @Nonnull AbstractJClass abstractJClass) {
        return this.generify(string).bound(abstractJClass);
    }

    @Override
    @Nonnull
    public JTypeVar[] typeParams() {
        if (this._typeVariables == null) {
            return AbstractJClass.EMPTY_ARRAY;
        }
        return this._typeVariables.values().toArray(new JTypeVar[this._typeVariables.size()]);
    }

    @Override
    @Nonnull
    public List<JTypeVar> typeParamList() {
        if (this._typeVariables == null) {
            return Collections.emptyList();
        }
        return new ArrayList<JTypeVar>(this._typeVariables.values());
    }
}

