/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JCast
extends AbstractJExpressionImpl {
    private final AbstractJType _type;
    private final IJExpression _object;

    protected JCast(@Nonnull AbstractJType abstractJType, @Nonnull IJExpression iJExpression) {
        this._type = abstractJType;
        this._object = iJExpression;
    }

    @Nonnull
    public AbstractJType type() {
        return this._type;
    }

    @Nonnull
    public IJExpression object() {
        return this._object;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print("((").generable(this._type).print(')').generable(this._object).print(')');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JCast jCast = (JCast)object;
        return JCEqualsHelper.isEqual(this._type.fullName(), jCast._type.fullName()) && JCEqualsHelper.isEqual(this._object, jCast._object);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this._type.fullName(), this._object);
    }
}

