/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.json.reader;

import com.mulesoft.weave.module.json.reader.IndexedJsonReaderToken;
import com.mulesoft.weave.module.json.reader.JsonKeyToken;
import com.mulesoft.weave.module.json.reader.JsonTokenType$;
import com.mulesoft.weave.module.json.reader.JsonValueToken;
import com.mulesoft.weave.module.xml.reader.XmlTokenHelper$;

public final class JsonTokenHelper$ {
    public static final JsonTokenHelper$ MODULE$;
    private final int TOKEN_TYPE_LEN;
    private final int DEPTH_LEN;
    private final int HASH_LEN;
    private final int KEY_LENGTH_LEN;
    private final int VALUE_LENGTH_LEN;
    private final int HASH_RIGHT_BITS;
    private final int DEPTH_RIGHT_BITS;
    private final int TOKEN_TYPE_RIGHT_BITS;
    private final long MAX_TOKEN_TYPE;
    private final long MAX_DEPTH;
    private final long MAX_HASH;
    private final long MAX_KEY_LEN;
    private final long MAX_VALUE_LEN;
    private final long MASK_TOKEN_TYPE;
    private final long MASK_DEPTH;
    private final long MASK_HASH;
    private final long MASK_KEY_LEN;
    private final long MASK_VALUE_LEN;

    static {
        new JsonTokenHelper$();
    }

    public int TOKEN_TYPE_LEN() {
        return this.TOKEN_TYPE_LEN;
    }

    public int DEPTH_LEN() {
        return this.DEPTH_LEN;
    }

    public int HASH_LEN() {
        return this.HASH_LEN;
    }

    public int KEY_LENGTH_LEN() {
        return this.KEY_LENGTH_LEN;
    }

    public int VALUE_LENGTH_LEN() {
        return this.VALUE_LENGTH_LEN;
    }

    public int HASH_RIGHT_BITS() {
        return this.HASH_RIGHT_BITS;
    }

    public int DEPTH_RIGHT_BITS() {
        return this.DEPTH_RIGHT_BITS;
    }

    public int TOKEN_TYPE_RIGHT_BITS() {
        return this.TOKEN_TYPE_RIGHT_BITS;
    }

    public long MAX_TOKEN_TYPE() {
        return this.MAX_TOKEN_TYPE;
    }

    public long MAX_DEPTH() {
        return this.MAX_DEPTH;
    }

    public long MAX_HASH() {
        return this.MAX_HASH;
    }

    public long MAX_KEY_LEN() {
        return this.MAX_KEY_LEN;
    }

    public long MAX_VALUE_LEN() {
        return this.MAX_VALUE_LEN;
    }

    public long MASK_TOKEN_TYPE() {
        return this.MASK_TOKEN_TYPE;
    }

    public long MASK_DEPTH() {
        return this.MASK_DEPTH;
    }

    public long MASK_HASH() {
        return this.MASK_HASH;
    }

    public long MASK_KEY_LEN() {
        return this.MASK_KEY_LEN;
    }

    public long MASK_VALUE_LEN() {
        return this.MASK_VALUE_LEN;
    }

    public IndexedJsonReaderToken createTrue(int depth, long offset) {
        return this.create(JsonTokenType$.MODULE$.True(), depth, offset, 4L);
    }

    public IndexedJsonReaderToken createFalse(int depth, long offset) {
        return this.create(JsonTokenType$.MODULE$.False(), depth, offset, 5L);
    }

    public IndexedJsonReaderToken createNull(int depth, long offset) {
        return this.create(JsonTokenType$.MODULE$.Null(), depth, offset, 4L);
    }

    public IndexedJsonReaderToken createKey(String keyName, int tokenType, int depth, long offset, long length) {
        return new JsonKeyToken(offset, tokenType, depth, length, XmlTokenHelper$.MODULE$.hash12Bit(keyName));
    }

    public IndexedJsonReaderToken create(int tokenType, int depth, long offset, long length) {
        return new JsonValueToken(offset, tokenType, depth, length);
    }

    private JsonTokenHelper$() {
        MODULE$ = this;
        this.TOKEN_TYPE_LEN = 4;
        this.DEPTH_LEN = 12;
        this.HASH_LEN = 16;
        this.KEY_LENGTH_LEN = 32;
        this.VALUE_LENGTH_LEN = 48;
        this.HASH_RIGHT_BITS = this.KEY_LENGTH_LEN();
        this.DEPTH_RIGHT_BITS = this.HASH_LEN() + this.HASH_RIGHT_BITS();
        this.TOKEN_TYPE_RIGHT_BITS = this.DEPTH_LEN() + this.DEPTH_RIGHT_BITS();
        this.MAX_TOKEN_TYPE = XmlTokenHelper$.MODULE$.lengthToMask(this.TOKEN_TYPE_LEN());
        this.MAX_DEPTH = XmlTokenHelper$.MODULE$.lengthToMask(this.DEPTH_LEN());
        this.MAX_HASH = XmlTokenHelper$.MODULE$.lengthToMask(this.HASH_LEN());
        this.MAX_KEY_LEN = XmlTokenHelper$.MODULE$.lengthToMask(this.KEY_LENGTH_LEN());
        this.MAX_VALUE_LEN = XmlTokenHelper$.MODULE$.lengthToMask(this.VALUE_LENGTH_LEN());
        this.MASK_TOKEN_TYPE = this.MAX_TOKEN_TYPE() << this.TOKEN_TYPE_RIGHT_BITS();
        this.MASK_DEPTH = this.MAX_DEPTH() << this.DEPTH_RIGHT_BITS();
        this.MASK_HASH = this.MAX_HASH() << this.HASH_RIGHT_BITS();
        this.MASK_KEY_LEN = this.MAX_KEY_LEN();
        this.MASK_VALUE_LEN = this.MAX_VALUE_LEN();
    }
}

