/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.pel;

import com.mulesoft.weave.pel.CompilationError;
import com.mulesoft.weave.pel.FailurePeregrineCompilationResult;
import com.mulesoft.weave.pel.PelSyntaxExampleGenerator$delayedInit$body;
import com.mulesoft.weave.pel.PeregrineCompilationResult;
import com.mulesoft.weave.pel.PeregrineCompiler;
import com.mulesoft.weave.pel.SuccessPeregrineCompilationResult;
import java.util.Map;
import scala.App;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class PelSyntaxExampleGenerator$
implements App {
    public static PelSyntaxExampleGenerator$ MODULE$;
    private PeregrineCompiler peregrineCompiler;
    private Map<String, String> dwToPelFunctions;
    private String[] allowedInputs;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new PelSyntaxExampleGenerator$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    private PeregrineCompiler peregrineCompiler() {
        return this.peregrineCompiler;
    }

    private Map<String, String> dwToPelFunctions() {
        return this.dwToPelFunctions;
    }

    private String[] allowedInputs() {
        return this.allowedInputs;
    }

    public void translate(String dw) {
        PeregrineCompilationResult peregrineCompilationResult = this.peregrineCompiler().compile(dw, this.dwToPelFunctions(), this.allowedInputs());
        if (peregrineCompilationResult instanceof SuccessPeregrineCompilationResult) {
            SuccessPeregrineCompilationResult successPeregrineCompilationResult = (SuccessPeregrineCompilationResult)peregrineCompilationResult;
            String pelExpression = successPeregrineCompilationResult.pelExpression();
            Predef$.MODULE$.println((Object)new StringBuilder(12).append(" DW: ").append(dw).append("\nPEL: ").append(pelExpression).append("\n").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (peregrineCompilationResult instanceof FailurePeregrineCompilationResult) {
            FailurePeregrineCompilationResult failurePeregrineCompilationResult = (FailurePeregrineCompilationResult)peregrineCompilationResult;
            CompilationError[] errors = failurePeregrineCompilationResult.errors();
            Predef$.MODULE$.println((Object)new StringBuilder(37).append("FAIL|:(  DW: ").append(dw).append(" -> compilation error: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])errors)).mkString("Array(", ", ", ")")).append("\n").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)peregrineCompilationResult);
        }
    }

    public final void delayedEndpoint$com$mulesoft$weave$pel$PelSyntaxExampleGenerator$1() {
        this.peregrineCompiler = new PeregrineCompiler();
        this.dwToPelFunctions = Map.ofEntries(Map.entry("dw::Core::++", "++"), Map.entry("dw::Core::contains", "contains"), Map.entry("dw::Core::splitBy", "splitBy"), Map.entry("dw::Core::trim", "trim"), Map.entry("dw::Core::lower", "lower"), Map.entry("dw::Core::upper", "upper"), Map.entry("dw::Core::sizeOf", "sizeOf"), Map.entry("dw::Core::uuid", "uuid"), Map.entry("dw::Core::isEmpty", "isEmpty"), Map.entry("dw::core::Strings::substringBefore", "substringBefore"), Map.entry("dw::core::Strings::substringAfter", "substringAfter"), Map.entry("dw::core::Strings::substringBeforeLast", "substringBeforeLast"), Map.entry("dw::core::Strings::substringAfterLast", "substringAfterLast"), Map.entry("dw::core::Binaries::toBase64", "toBase64"), Map.entry("dw::core::Binaries::fromBase64", "fromBase64"));
        this.allowedInputs = (String[])((Object[])new String[]{"payload", "attributes", "vars", "authentication"});
        Predef$.MODULE$.println((Object)"\n// PEL Iteration #1 support\n");
        this.translate("attributes.queryParams.q");
        this.translate("attributes.queryParams['q']");
        this.translate("uuid()");
        this.translate("\"hi\" ++ \"by\"");
        Predef$.MODULE$.println((Object)"\n///////////\n// TCK\n///////////");
        Predef$.MODULE$.println((Object)"\n// literals\n");
        this.translate("\"hi\"");
        this.translate("123");
        this.translate("-12.34");
        this.translate("true");
        this.translate("false");
        this.translate("|2021-09-06|");
        this.translate("|23:57:59|");
        this.translate("|23:57:59Z|");
        this.translate("|2021-09-06T23:57:59|");
        this.translate("|2021-09-06T23:57:59Z|");
        this.translate("[]");
        this.translate("[\"one\", 2, three]");
        Predef$.MODULE$.println((Object)"\n// operators\n");
        this.translate("a > b");
        this.translate("a < b");
        this.translate("a >= b");
        this.translate("a <= b");
        this.translate("a == b");
        this.translate("a != b");
        this.translate("a and b");
        this.translate("a or b");
        this.translate("!a");
        this.translate("not a");
        Predef$.MODULE$.println((Object)"\n// selectors\n");
        this.translate("a");
        this.translate("a.b");
        this.translate("a.b.c");
        this.translate("a[0]");
        this.translate("a['b'][0]");
        Predef$.MODULE$.println((Object)"\n// functions\n");
        this.translate("uuid()");
        this.translate("upper(\"hi\")");
        this.translate("\"hi\" ++ \"by\"");
        Predef$.MODULE$.println((Object)"\n// flow control\n");
        this.translate("if (false) \"a\" else \"b\"");
        Predef$.MODULE$.println((Object)"\n// misc\n");
        this.translate("a default \"b\"");
        Predef$.MODULE$.println();
    }

    private PelSyntaxExampleGenerator$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new PelSyntaxExampleGenerator$delayedInit$body(this));
    }
}

