/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.runtime.operator.stringops;

import com.mulesoft.weave.runtime.operator.stringops.Inflector;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public abstract class Inflector$class {
    public static String titleize(Inflector $this, String word) {
        return new StringOps(Predef$.MODULE$.augmentString("\\b([a-z])")).r().replaceAllIn((CharSequence)$this.humanize($this.underscore(word)), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Regex.Match x$1) {
                return x$1.group(0).toUpperCase(Locale.ENGLISH);
            }
        });
    }

    public static String humanize(Inflector $this, String word) {
        return $this.capitalize(word.replace("_", " "));
    }

    public static String camelize(Inflector $this, String word) {
        String w = $this.pascalize(word);
        return new StringBuilder().append((Object)w.substring(0, 1).toLowerCase(Locale.ENGLISH)).append((Object)w.substring(1)).toString();
    }

    public static String pascalize(Inflector $this, String word) {
        List lst = Predef$.MODULE$.refArrayOps((Object[])word.split("_")).toList();
        String string = (String)lst.headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return new StringBuilder().append((Object)s.substring(0, 1).toUpperCase(Locale.ENGLISH)).append((Object)s.substring(1)).toString();
            }
        }).get();
        return ((List)((List)lst.tail()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return new StringBuilder().append((Object)s.substring(0, 1).toUpperCase()).append((Object)s.substring(1)).toString();
            }
        }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)string).mkString("");
    }

    public static String underscore(Inflector $this, String word) {
        Regex spacesPattern = new StringOps(Predef$.MODULE$.augmentString("[-\\s]")).r();
        Regex firstPattern = new StringOps(Predef$.MODULE$.augmentString("([A-Z]+)([A-Z][a-z])")).r();
        Regex secondPattern = new StringOps(Predef$.MODULE$.augmentString("([a-z\\d])([A-Z])")).r();
        String replacementPattern = "$1_$2";
        return spacesPattern.replaceAllIn((CharSequence)secondPattern.replaceAllIn((CharSequence)firstPattern.replaceAllIn((CharSequence)word, replacementPattern), replacementPattern), "_").toLowerCase();
    }

    public static String capitalize(Inflector $this, String word) {
        return new StringBuilder().append((Object)word.substring(0, 1).toUpperCase(Locale.ENGLISH)).append((Object)word.substring(1).toLowerCase(Locale.ENGLISH)).toString();
    }

    public static String uncapitalize(Inflector $this, String word) {
        return new StringBuilder().append((Object)word.substring(0, 1).toLowerCase(Locale.ENGLISH)).append((Object)word.substring(1)).toString();
    }

    public static String ordinalize(Inflector $this, String word) {
        return Inflector$class.ordanize($this, new StringOps(Predef$.MODULE$.augmentString(word)).toInt(), word);
    }

    public static String ordinalize(Inflector $this, int number) {
        return Inflector$class.ordanize($this, number, ((Object)BoxesRunTime.boxToInteger((int)number)).toString());
    }

    private static String ordanize(Inflector $this, int number, String numberString) {
        String string;
        int nMod100 = number % 100;
        if (nMod100 >= 11 && nMod100 <= 13) {
            string = new StringBuilder().append((Object)numberString).append((Object)"th").toString();
        } else {
            int n = number % 10;
            switch (n) {
                default: {
                    string = new StringBuilder().append((Object)numberString).append((Object)"th").toString();
                    break;
                }
                case 3: {
                    string = new StringBuilder().append((Object)numberString).append((Object)"rd").toString();
                    break;
                }
                case 2: {
                    string = new StringBuilder().append((Object)numberString).append((Object)"nd").toString();
                    break;
                }
                case 1: {
                    string = new StringBuilder().append((Object)numberString).append((Object)"st").toString();
                }
            }
        }
        return string;
    }

    public static String dasherize(Inflector $this, String word) {
        return $this.underscore(word).replace('_', '-');
    }

    public static String pluralize(Inflector $this, String word) {
        return Inflector$class.applyRules($this, $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals(), word);
    }

    public static String singularize(Inflector $this, String word) {
        return Inflector$class.applyRules($this, $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars(), word);
    }

    private static Inflector.Rule tuple2Rule(Inflector $this, Tuple2 pair) {
        return $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$Rule().apply((Tuple2<String, String>)pair);
    }

    private static String applyRules(Inflector $this, List collection, String word) {
        while (true) {
            block7: {
                String string;
                block6: {
                    block5: {
                        if (!$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$uncountables().contains((Object)word.toLowerCase(Locale.ENGLISH))) break block5;
                        string = word;
                        break block6;
                    }
                    if (collection.isEmpty()) {
                        return word;
                    }
                    Option<String> m = ((Inflector.Rule)collection.head()).apply(word);
                    if (!m.isDefined()) break block7;
                    string = (String)m.get();
                }
                return string;
            }
            collection = (List)collection.tail();
        }
    }

    public static void addPlural(Inflector $this, String pattern, String replacement) {
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals_$eq((List<Inflector.Rule>)$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals().$colon$colon((Object)Inflector$class.tuple2Rule($this, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pattern), (Object)replacement))));
    }

    public static void addSingular(Inflector $this, String pattern, String replacement) {
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars_$eq((List<Inflector.Rule>)$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars().$colon$colon((Object)Inflector$class.tuple2Rule($this, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pattern), (Object)replacement))));
    }

    public static void addIrregular(Inflector $this, String singular, String plural) {
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals_$eq((List<Inflector.Rule>)$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals().$colon$colon((Object)Inflector$class.tuple2Rule($this, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"(").append((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(singular), 0))).append((Object)")").append((Object)singular.substring(1)).append((Object)"$").toString()), (Object)new StringBuilder().append((Object)"$1").append((Object)plural.substring(1)).toString()))));
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars_$eq((List<Inflector.Rule>)$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars().$colon$colon((Object)Inflector$class.tuple2Rule($this, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"(").append((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(plural), 0))).append((Object)")").append((Object)plural.substring(1)).append((Object)"$").toString()), (Object)new StringBuilder().append((Object)"$1").append((Object)singular.substring(1)).toString()))));
    }

    public static void addUncountable(Inflector $this, String word) {
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$uncountables_$eq((List<String>)$this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$uncountables().$colon$colon((Object)word));
    }

    public static String interpolate(Inflector $this, String text, Map vars) {
        return new StringOps(Predef$.MODULE$.augmentString("\\#\\{([^}]+)\\}")).r().replaceAllIn((CharSequence)text, (Function1)new Serializable($this, vars){
            public static final long serialVersionUID = 0L;
            private final Map vars$1;

            public final String apply(Regex.Match x$3) {
                Regex.Match match = x$3;
                Option option = Regex.Groups$.MODULE$.unapplySeq(match);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    String v = (String)((SeqLike)option.get()).apply(0);
                    String string = (String)this.vars$1.getOrElse((Object)v, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    return string;
                }
                throw new MatchError((Object)match);
            }
            {
                this.vars$1 = vars$1;
            }
        });
    }

    public static void $init$(Inflector $this) {
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$plurals_$eq((List<Inflector.Rule>)Nil$.MODULE$);
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$singulars_$eq((List<Inflector.Rule>)Nil$.MODULE$);
        $this.com$mulesoft$weave$runtime$operator$stringops$Inflector$$uncountables_$eq((List<String>)Nil$.MODULE$);
    }
}

