/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.interpreted.transform;

import com.mulesoft.weave.exception.InvalidNativeNameException;
import com.mulesoft.weave.grammar.literals.TypeLiteral$;
import com.mulesoft.weave.interpreted.node.ExistsSelectorNode;
import com.mulesoft.weave.interpreted.node.LiteralFunctionValueNode;
import com.mulesoft.weave.interpreted.node.NameSlot;
import com.mulesoft.weave.interpreted.node.NullSafeNode;
import com.mulesoft.weave.interpreted.node.ValueNode;
import com.mulesoft.weave.interpreted.node.structure.ArrayNode;
import com.mulesoft.weave.interpreted.node.structure.AttributesNode;
import com.mulesoft.weave.interpreted.node.structure.BooleanNode;
import com.mulesoft.weave.interpreted.node.structure.ConditionalNode;
import com.mulesoft.weave.interpreted.node.structure.DateTimeNode;
import com.mulesoft.weave.interpreted.node.structure.DynamicKeyNode;
import com.mulesoft.weave.interpreted.node.structure.FunctionParameterNode;
import com.mulesoft.weave.interpreted.node.structure.KeyNode$;
import com.mulesoft.weave.interpreted.node.structure.KeyValuePairNode;
import com.mulesoft.weave.interpreted.node.structure.LocalDateNode;
import com.mulesoft.weave.interpreted.node.structure.LocalDateTimeNode;
import com.mulesoft.weave.interpreted.node.structure.LocalTimeNode;
import com.mulesoft.weave.interpreted.node.structure.NameNode$;
import com.mulesoft.weave.interpreted.node.structure.NameValuePairNode;
import com.mulesoft.weave.interpreted.node.structure.NamespaceNode;
import com.mulesoft.weave.interpreted.node.structure.NullNode;
import com.mulesoft.weave.interpreted.node.structure.NumberNode;
import com.mulesoft.weave.interpreted.node.structure.ObjectNode$;
import com.mulesoft.weave.interpreted.node.structure.OverloadedFunctionNode;
import com.mulesoft.weave.interpreted.node.structure.PeriodNode;
import com.mulesoft.weave.interpreted.node.structure.RangeNode;
import com.mulesoft.weave.interpreted.node.structure.RegexNode;
import com.mulesoft.weave.interpreted.node.structure.StringInterpolationNode$;
import com.mulesoft.weave.interpreted.node.structure.StringNode;
import com.mulesoft.weave.interpreted.node.structure.StringValueUtils$;
import com.mulesoft.weave.interpreted.node.structure.TimeNode;
import com.mulesoft.weave.interpreted.node.structure.TimeZoneNode;
import com.mulesoft.weave.interpreted.node.structure.TypeNode;
import com.mulesoft.weave.interpreted.node.structure.UriNode;
import com.mulesoft.weave.interpreted.node.structure.schema.SchemaNode;
import com.mulesoft.weave.interpreted.transform.EngineStructureTransformations;
import com.mulesoft.weave.interpreted.transform.EngineStructureTransformations$;
import com.mulesoft.weave.model.types.AnyType$;
import com.mulesoft.weave.model.types.ArrayType$;
import com.mulesoft.weave.model.types.BinaryType$;
import com.mulesoft.weave.model.types.BooleanType$;
import com.mulesoft.weave.model.types.DateTimeType$;
import com.mulesoft.weave.model.types.FunctionType$;
import com.mulesoft.weave.model.types.LocalDateTimeType$;
import com.mulesoft.weave.model.types.LocalDateType$;
import com.mulesoft.weave.model.types.LocalTimeType$;
import com.mulesoft.weave.model.types.NamespaceType$;
import com.mulesoft.weave.model.types.NullType$;
import com.mulesoft.weave.model.types.NumberType$;
import com.mulesoft.weave.model.types.ObjectType$;
import com.mulesoft.weave.model.types.PeriodType$;
import com.mulesoft.weave.model.types.RangeType$;
import com.mulesoft.weave.model.types.StringType$;
import com.mulesoft.weave.model.types.TimeType$;
import com.mulesoft.weave.model.types.TimeZoneType$;
import com.mulesoft.weave.model.types.Type;
import com.mulesoft.weave.model.types.TypeType$;
import com.mulesoft.weave.model.types.UnionType;
import com.mulesoft.weave.model.types.UriType$;
import com.mulesoft.weave.model.values.FunctionValue;
import com.mulesoft.weave.model.values.Value;
import com.mulesoft.weave.module.native.NativeValueManager$;
import com.mulesoft.weave.parser.ast.AstNode;
import com.mulesoft.weave.parser.ast.AstNodeHelper$;
import com.mulesoft.weave.parser.ast.functions.FunctionNode;
import com.mulesoft.weave.parser.ast.structure.FromOrdinalLocalDateFormat$;
import com.mulesoft.weave.parser.ast.structure.FromUnknownLocalDateFormat$;
import com.mulesoft.weave.parser.ast.structure.FromWeekLocalDateFormat$;
import com.mulesoft.weave.parser.ast.structure.LocalDateFormat;
import com.mulesoft.weave.parser.ast.types.ArrayTypeNode;
import com.mulesoft.weave.parser.ast.types.FunctionTypeNode;
import com.mulesoft.weave.parser.ast.types.ObjectTypeNode;
import com.mulesoft.weave.parser.ast.types.SimpleTypeNode;
import com.mulesoft.weave.parser.ast.types.SimpleTypeNode$;
import com.mulesoft.weave.parser.ast.types.TypeParameterNode;
import com.mulesoft.weave.parser.ast.types.TypeTypeNode;
import com.mulesoft.weave.parser.ast.types.UnionTypeNode;
import com.mulesoft.weave.parser.ast.types.WeaveTypeNode;
import com.mulesoft.weave.parser.ast.variables.NameIdentifier;
import com.mulesoft.weave.parser.exception.InvalidDateLiteralException;
import com.mulesoft.weave.parser.location.Location;
import com.mulesoft.weave.scope.Reference;
import com.mulesoft.weave.scope.VariableScope;
import java.net.URI;
import java.util.Map;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.Period;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.TemporalAmount;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import spire.math.Number$;

public abstract class EngineStructureTransformations$class {
    public static DateTimeNode transformDateTimeNode(EngineStructureTransformations $this, String dateTime, Location location2) {
        try {
            return new DateTimeNode(ZonedDateTime.parse((CharSequence)dateTime));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidDateLiteralException(location2, dateTime);
        }
    }

    public static StringNode transformStringNode(EngineStructureTransformations $this, String v) {
        return new StringNode(StringValueUtils$.MODULE$.handleEscapeChars(v));
    }

    public static TimeNode transformTimeNode(EngineStructureTransformations $this, String time, Location location2) {
        try {
            return new TimeNode(OffsetTime.parse((CharSequence)time));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidDateLiteralException(location2, time);
        }
    }

    public static ValueNode transformStringInterpolationNode(EngineStructureTransformations $this, Seq v) {
        return StringInterpolationNode$.MODULE$.apply($this.transformSeq((Seq<AstNode>)v));
    }

    public static LocalDateTimeNode transformLocalDateTimeNode(EngineStructureTransformations $this, String dateTime, Location location2) {
        try {
            return new LocalDateTimeNode(LocalDateTime.parse((CharSequence)dateTime));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidDateLiteralException(location2, dateTime);
        }
    }

    public static UriNode transformUriNode(EngineStructureTransformations $this, String uri) {
        return new UriNode(URI.create(uri));
    }

    public static ConditionalNode transformConditionalNode(EngineStructureTransformations $this, AstNode value2, AstNode cond) {
        return new ConditionalNode((ValueNode)$this.transform(value2), (ValueNode)$this.transform(cond));
    }

    public static PeriodNode transformPeriodNode(EngineStructureTransformations $this, String period) {
        return new StringOps(Predef$.MODULE$.augmentString(period)).contains((Object)BoxesRunTime.boxToCharacter((char)'T')) ? new PeriodNode((TemporalAmount)Duration.parse((CharSequence)period)) : new PeriodNode((TemporalAmount)Period.parse((CharSequence)period));
    }

    public static RegexNode transformRegexNode(EngineStructureTransformations $this, String regex) {
        return new RegexNode(new Regex(regex, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
    }

    public static TypeNode transformTypeNode(EngineStructureTransformations $this, WeaveTypeNode weaveType, Location location2) {
        WeaveTypeNode weaveTypeNode;
        block9: {
            TypeNode typeNode;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        weaveTypeNode = weaveType;
                                        if (!(weaveTypeNode instanceof ObjectTypeNode)) break block2;
                                        ObjectTypeNode objectTypeNode = (ObjectTypeNode)weaveTypeNode;
                                        Option asSchema = objectTypeNode.asSchema();
                                        typeNode = new TypeNode((Type)ObjectType$.MODULE$, $this.transformOption((Option<AstNode>)asSchema));
                                        break block3;
                                    }
                                    if (!(weaveTypeNode instanceof FunctionTypeNode)) break block4;
                                    FunctionTypeNode functionTypeNode = (FunctionTypeNode)weaveTypeNode;
                                    Option asSchema = functionTypeNode.asSchema();
                                    typeNode = new TypeNode((Type)FunctionType$.MODULE$, $this.transformOption((Option<AstNode>)asSchema));
                                    break block3;
                                }
                                if (!(weaveTypeNode instanceof TypeTypeNode)) break block5;
                                TypeTypeNode typeTypeNode = (TypeTypeNode)weaveTypeNode;
                                Option asSchema = typeTypeNode.asSchema();
                                typeNode = new TypeNode((Type)TypeType$.MODULE$, $this.transformOption((Option<AstNode>)asSchema));
                                break block3;
                            }
                            if (!(weaveTypeNode instanceof ArrayTypeNode)) break block6;
                            ArrayTypeNode arrayTypeNode = (ArrayTypeNode)weaveTypeNode;
                            Option asSchema = arrayTypeNode.asSchema();
                            typeNode = new TypeNode((Type)ArrayType$.MODULE$, $this.transformOption((Option<AstNode>)asSchema));
                            break block3;
                        }
                        if (!(weaveTypeNode instanceof UnionTypeNode)) break block7;
                        UnionTypeNode unionTypeNode = (UnionTypeNode)weaveTypeNode;
                        WeaveTypeNode left = unionTypeNode.left();
                        WeaveTypeNode right = unionTypeNode.right();
                        typeNode = new TypeNode((Type)new UnionType((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Type[]{$this.transformTypeNode(left, location2).typeValue(), $this.transformTypeNode(right, location2).typeValue()}))), (Option<SchemaNode>)None$.MODULE$);
                        break block3;
                    }
                    if (!(weaveTypeNode instanceof SimpleTypeNode)) break block8;
                    SimpleTypeNode simpleTypeNode = (SimpleTypeNode)weaveTypeNode;
                    String typeId = simpleTypeNode.typeId();
                    Option asSchema = simpleTypeNode.asSchema();
                    typeNode = new TypeNode((Type)$this.typeMap().apply((Object)typeId), $this.transformOption((Option<AstNode>)asSchema));
                    break block3;
                }
                if (!(weaveTypeNode instanceof TypeParameterNode)) break block9;
                typeNode = new TypeNode((Type)AnyType$.MODULE$, (Option<SchemaNode>)None$.MODULE$);
            }
            return typeNode;
        }
        throw new MatchError((Object)weaveTypeNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TimeZoneNode transformTimeZoneNode(EngineStructureTransformations $this, String timeZone, Location location2) {
        TimeZoneNode timeZoneNode;
        try {
            timeZoneNode = new TimeZoneNode(ZoneOffset.of((String)timeZone));
            return timeZoneNode;
        }
        catch (Throwable throwable22) {
            Throwable throwable3 = throwable22;
            boolean bl = throwable3 instanceof DateTimeParseException ? true : throwable3 instanceof DateTimeException;
            if (!bl) throw throwable22;
            try {
                TimeZoneNode timeZoneNode2;
                timeZoneNode = timeZoneNode2 = new TimeZoneNode(LocalDateTime.now().atZone(ZoneId.of((String)timeZone, (Map)ZoneId.SHORT_IDS)).getOffset());
                return timeZoneNode;
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new InvalidDateLiteralException(location2, timeZone);
            }
        }
    }

    public static LocalDateNode transformLocalDateNode(EngineStructureTransformations $this, String value2, Option maybeFormat, Location location2) {
        try {
            Option option;
            block10: {
                LocalDate localDate;
                block9: {
                    block4: {
                        LocalDateFormat localDateFormat;
                        block8: {
                            LocalDate localDate2;
                            block6: {
                                block7: {
                                    block5: {
                                        option = maybeFormat;
                                        if (!(option instanceof Some)) break block4;
                                        Some some = (Some)option;
                                        LocalDateFormat format2 = (LocalDateFormat)some.x();
                                        localDateFormat = format2;
                                        if (!FromOrdinalLocalDateFormat$.MODULE$.equals(localDateFormat)) break block5;
                                        localDate2 = LocalDate.parse((CharSequence)value2, (DateTimeFormatter)DateTimeFormatter.ISO_ORDINAL_DATE);
                                        break block6;
                                    }
                                    if (!FromWeekLocalDateFormat$.MODULE$.equals(localDateFormat)) break block7;
                                    localDate2 = LocalDate.parse((CharSequence)value2, (DateTimeFormatter)DateTimeFormatter.ISO_WEEK_DATE);
                                    break block6;
                                }
                                if (!FromUnknownLocalDateFormat$.MODULE$.equals(localDateFormat)) break block8;
                                localDate2 = (LocalDate)Try$.MODULE$.apply((Function0)new Serializable($this, value2){
                                    public static final long serialVersionUID = 0L;
                                    private final String value$1;

                                    public final LocalDate apply() {
                                        return LocalDate.parse((CharSequence)this.value$1);
                                    }
                                    {
                                        this.value$1 = value$1;
                                    }
                                }).orElse((Function0)new Serializable($this, value2){
                                    public static final long serialVersionUID = 0L;
                                    public final String value$1;

                                    public final Try<LocalDate> apply() {
                                        return Try$.MODULE$.apply((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ EngineStructureTransformations$.anonfun.2 $outer;

                                            public final LocalDate apply() {
                                                return LocalDate.parse((CharSequence)this.$outer.value$1, (DateTimeFormatter)DateTimeFormatter.ISO_WEEK_DATE);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        this.value$1 = value$1;
                                    }
                                }).orElse((Function0)new Serializable($this, value2){
                                    public static final long serialVersionUID = 0L;
                                    public final String value$1;

                                    public final Try<LocalDate> apply() {
                                        return Try$.MODULE$.apply((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ EngineStructureTransformations$.anonfun.3 $outer;

                                            public final LocalDate apply() {
                                                return LocalDate.parse((CharSequence)this.$outer.value$1, (DateTimeFormatter)DateTimeFormatter.ISO_ORDINAL_DATE);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        this.value$1 = value$1;
                                    }
                                }).get();
                            }
                            localDate = localDate2;
                            break block9;
                        }
                        throw new MatchError((Object)localDateFormat);
                    }
                    if (!None$.MODULE$.equals(option)) break block10;
                    localDate = LocalDate.parse((CharSequence)value2);
                }
                LocalDate localDate3 = localDate;
                return new LocalDateNode(localDate3);
            }
            throw new MatchError((Object)option);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidDateLiteralException(location2, value2);
        }
    }

    public static NullNode transformNullNode(EngineStructureTransformations $this) {
        return new NullNode();
    }

    public static RangeNode transformRangeNode(EngineStructureTransformations $this, AstNode rangeStart, AstNode rangeEnd) {
        return new RangeNode((ValueNode)$this.transform(rangeStart), (ValueNode)$this.transform(rangeEnd));
    }

    public static ArrayNode transformArrayNode(EngineStructureTransformations $this, Seq v) {
        return new ArrayNode($this.transformSeq((Seq<AstNode>)v));
    }

    public static AttributesNode transformAttributesNode(EngineStructureTransformations $this, Seq attrs) {
        return new AttributesNode($this.transformSeq((Seq<AstNode>)attrs));
    }

    public static ValueNode transformObjectNode(EngineStructureTransformations $this, Seq elements) {
        return ObjectNode$.MODULE$.apply($this.transformSeq((Seq<AstNode>)elements));
    }

    public static ValueNode transformFunctionNode(EngineStructureTransformations $this, Seq args, AstNode body2, Option name) {
        ValueNode<Function1<Seq<Value<?>>, Value<?>>> valueNode;
        if (AstNodeHelper$.MODULE$.isNativeCall(body2, $this.scopeNavigator())) {
            NameIdentifier value2 = (NameIdentifier)AstNodeHelper$.MODULE$.getNativeIdentifierCall(body2).getOrElse((Function0)new Serializable($this, body2){
                public static final long serialVersionUID = 0L;
                private final AstNode body$1;

                public final Nothing$ apply() {
                    throw new InvalidNativeNameException("Native name must be a literal string.", (Location)this.body$1.location());
                }
                {
                    this.body$1 = body$1;
                }
            });
            FunctionValue functionValue = NativeValueManager$.MODULE$.getValue(value2);
            functionValue.name_$eq(name);
            valueNode = new LiteralFunctionValueNode(functionValue);
        } else {
            valueNode = new com.mulesoft.weave.interpreted.node.structure.FunctionNode($this.transformSeq((Seq<AstNode>)args), (ValueNode)$this.transform(body2), (Option<String>)name);
        }
        return valueNode;
    }

    public static Option transformFunctionNode$default$3(EngineStructureTransformations $this) {
        return None$.MODULE$;
    }

    public static OverloadedFunctionNode transformOverloadedFunctionNode(EngineStructureTransformations $this, Seq astFunctionNodes, Option name) {
        Seq functionNodes = (Seq)astFunctionNodes.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EngineStructureTransformations $outer;

            public final ValueNode<Object> apply(FunctionNode x$1) {
                return (ValueNode)this.$outer.transform((AstNode)x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new OverloadedFunctionNode(functionNodes, (Option<String>)name);
    }

    public static Option transformOverloadedFunctionNode$default$2(EngineStructureTransformations $this) {
        return None$.MODULE$;
    }

    public static NameValuePairNode transformNameValuePairNode(EngineStructureTransformations $this, AstNode key, AstNode value2, Option cond) {
        return new NameValuePairNode((ValueNode)$this.transform(key), (ValueNode)$this.transform(value2), $this.transformOption((Option<AstNode>)cond));
    }

    public static NamespaceNode transformNamespaceNode(EngineStructureTransformations $this, AstNode prefix) {
        return new NamespaceNode((NameSlot)$this.transform(prefix));
    }

    public static FunctionParameterNode transformFunctionParameter(EngineStructureTransformations $this, NameIdentifier variable, Option defaultValue, Option maybeWtype) {
        boolean bl;
        WeaveTypeNode typeNode = (WeaveTypeNode)maybeWtype.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final SimpleTypeNode apply() {
                return new SimpleTypeNode(TypeLiteral$.MODULE$.ANY_TYPE_NAME(), SimpleTypeNode$.MODULE$.apply$default$2());
            }
        });
        Seq references = $this.scopeNavigator().resolveReferencedBy(variable);
        if (references.isEmpty()) {
            bl = false;
        } else if (references.size() == 1) {
            VariableScope scopeOf = $this.scopeNavigator().scopeOf((AstNode)variable);
            bl = ((Reference)references.head()).scope().index() != scopeOf.index();
        } else {
            bl = true;
        }
        boolean materialize = bl;
        return new FunctionParameterNode((NameSlot)$this.transform((AstNode)variable), (TypeNode)$this.transform((AstNode)typeNode), $this.transformOption((Option<AstNode>)defaultValue), materialize);
    }

    public static LocalTimeNode transformLocalTimeNode(EngineStructureTransformations $this, String time, Location location2) {
        try {
            return new LocalTimeNode(LocalTime.parse((CharSequence)time));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidDateLiteralException(location2, time);
        }
    }

    public static KeyValuePairNode transformKeyValuePairNode(EngineStructureTransformations $this, AstNode key, AstNode value2, Option cond) {
        return new KeyValuePairNode((ValueNode)$this.transform(key), (ValueNode)$this.transform(value2), $this.transformOption((Option<AstNode>)cond));
    }

    public static ValueNode transformNameNode(EngineStructureTransformations $this, AstNode keyName, Option cond) {
        return NameNode$.MODULE$.apply((ValueNode)$this.transform(keyName), $this.transformOption((Option<AstNode>)cond));
    }

    public static NumberNode transformNumberNode(EngineStructureTransformations $this, String v) {
        return new NumberNode(Number$.MODULE$.apply(v));
    }

    public static BooleanNode transformBooleanNode(EngineStructureTransformations $this, String value2) {
        return new BooleanNode(new StringOps(Predef$.MODULE$.augmentString(value2)).toBoolean());
    }

    public static ValueNode transformKeyNode(EngineStructureTransformations $this, AstNode keyName, Option ns, Option attr) {
        return KeyNode$.MODULE$.apply((ValueNode)$this.transform(keyName), $this.transformOption((Option<AstNode>)ns), $this.transformOption((Option<AstNode>)attr));
    }

    public static DynamicKeyNode transformDynamicKeyNode(EngineStructureTransformations $this, AstNode keyName, Option attr) {
        return KeyNode$.MODULE$.apply((ValueNode)$this.transform(keyName), $this.transformOption((Option<AstNode>)attr));
    }

    public static NullSafeNode transformNullSafeNode(EngineStructureTransformations $this, AstNode selector) {
        return new NullSafeNode((ValueNode)$this.transform(selector));
    }

    public static ExistsSelectorNode transformExistsSelectorNode(EngineStructureTransformations $this, AstNode selectable) {
        return new ExistsSelectorNode((ValueNode)$this.transform(selectable));
    }

    public static void $init$(EngineStructureTransformations $this) {
        $this.com$mulesoft$weave$interpreted$transform$EngineStructureTransformations$_setter_$typeMap_$eq((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.STRING_TYPE_NAME()), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.BOOLEAN_TYPE_NAME()), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.NUMBER_TYPE_NAME()), (Object)NumberType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.RANGE_TYPE_NAME()), (Object)RangeType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.URI_TYPE_NAME()), (Object)UriType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.DATETIME_TYPE_NAME()), (Object)DateTimeType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.LOCALDATETIME_TYPE_NAME()), (Object)LocalDateTimeType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.DATE_TYPE_NAME()), (Object)LocalDateType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.LOCALTIME_TYPE_NAME()), (Object)LocalTimeType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.TIME_TYPE_NAME()), (Object)TimeType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.TIMEZONE_TYPE_NAME()), (Object)TimeZoneType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.PERIOD_TYPE_NAME()), (Object)PeriodType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.BINARY_TYPE_NAME()), (Object)BinaryType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.NULL_TYPE_NAME()), (Object)NullType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.ANY_TYPE_NAME()), (Object)AnyType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TypeLiteral$.MODULE$.NAME_SPACE_TYPE_NAME()), (Object)NamespaceType$.MODULE$)})));
    }
}

