/*
 * Decompiled with CFR 0.152.
 */
package com.muquit.libsodiumjna;

import com.muquit.libsodiumjna.SodiumKeyPair;
import com.muquit.libsodiumjna.SodiumSecretBox;
import com.muquit.libsodiumjna.exceptions.SodiumLibraryException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumLibrary {
    private static final Logger logger = LoggerFactory.getLogger(SodiumLibrary.class);
    private static String libPath;
    private static boolean initialized;

    private SodiumLibrary() {
    }

    public static void log(String msg) {
        System.out.println("MMMM: " + msg);
    }

    public static void setLibraryPath(String libraryPath) {
        libPath = libraryPath;
    }

    public static String getLibaryPath() {
        return libPath;
    }

    public static Sodium sodium() {
        if (libPath == null) {
            logger.info("libpath not set, throw exception");
            throw new RuntimeException("Please set the absolute path of the libsodium libary by calling SodiumLibrary.setLibraryPath(path)");
        }
        Sodium sodium = SingletonHelper.instance;
        if (!initialized) {
            int rc = sodium.sodium_init();
            if (rc == -1) {
                logger.error("ERROR: sodium_init() failed: " + rc);
                throw new RuntimeException("sodium_init() failed, rc=" + rc);
            }
            initialized = true;
        }
        return sodium;
    }

    public static byte[] cryptoSignOpen(byte[] sig, byte[] pk) throws SodiumLibraryException {
        byte[] m = new byte[sig.length];
        byte[] mlen = new byte[1];
        int rc = SodiumLibrary.sodium().crypto_sign_open(m, mlen[0], sig, sig.length, pk);
        if (rc == 0) {
            return m;
        }
        return new byte[1];
    }

    public static byte[] cryptoSign(byte[] m, byte[] sk) throws SodiumLibraryException {
        byte[] sm = new byte[SodiumLibrary.sodium().crypto_sign_bytes() + m.length];
        byte[] test = new byte[1];
        int rc = SodiumLibrary.sodium().crypto_sign(sm, test[0], m, m.length, sk);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_sign (combined mode, not detached) failed, returned " + rc + ", expected 0");
        }
        return sm;
    }

    public static boolean cryptoSignVerifyDetached(byte[] sig, byte[] msg, byte[] pk) throws SodiumLibraryException {
        int rc = SodiumLibrary.sodium().crypto_sign_verify_detached(sig, msg, msg.length, pk);
        if (rc == 0) {
            return true;
        }
        if (rc == -1) {
            return false;
        }
        throw new SodiumLibraryException("libsodium crypto_sign_verify_detached failed, returned " + rc + ", expected 0 (a match) or -1 (mismatched)");
    }

    public static byte[] cryptoSignDetached(byte[] msg, byte[] sk) throws SodiumLibraryException {
        byte[] sig = new byte[SodiumLibrary.sodium().crypto_sign_ed25519_bytes()];
        int rc = SodiumLibrary.sodium().crypto_sign_detached(sig, 0L, msg, msg.length, sk);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_sign_detached failed, returned " + rc + ", expected 0");
        }
        return sig;
    }

    public static SodiumKeyPair cryptoSignKeyPair() throws SodiumLibraryException {
        SodiumKeyPair kp = new SodiumKeyPair();
        byte[] publicKey = new byte[(int)SodiumLibrary.sodium().crypto_sign_publickeybytes()];
        byte[] privateKey = new byte[(int)SodiumLibrary.sodium().crypto_sign_secretkeybytes()];
        int rc = SodiumLibrary.sodium().crypto_sign_keypair(publicKey, privateKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_sign_keypair() failed, returned " + rc + ", expected 0");
        }
        kp.setPublicKey(publicKey);
        kp.setPrivateKey(privateKey);
        if (logger.isDebugEnabled()) {
            logger.debug("pk len: " + publicKey.length);
            logger.debug("sk len: " + privateKey.length);
        }
        return kp;
    }

    public static byte[] cryptoGenerichash(byte[] input, int length) throws SodiumLibraryException {
        byte[] hash = new byte[length];
        int rc = SodiumLibrary.sodium().crypto_generichash(hash, length, input, input.length, null, 0L);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_generichash failed, returned " + rc + ", expected 0");
        }
        return hash;
    }

    public static byte[] cryptoSignEdSkTOcurveSk(byte[] edSK) throws SodiumLibraryException {
        byte[] curveSK = new byte[SodiumLibrary.sodium().crypto_box_publickeybytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_sign_ed25519_sk_to_curve25519(curveSK, edSK);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_generichash failed, returned " + rc + ", expected 0");
        }
        return curveSK;
    }

    public static byte[] cryptoSignEdPkTOcurvePk(byte[] edPK) throws SodiumLibraryException {
        byte[] curvePK = new byte[SodiumLibrary.sodium().crypto_box_publickeybytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_sign_ed25519_pk_to_curve25519(curvePK, edPK);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_generichash failed, returned " + rc + ", expected 0");
        }
        return curvePK;
    }

    public static String libsodiumVersionString() {
        return SodiumLibrary.sodium().sodium_version_string();
    }

    public static byte[] randomBytes(int size) {
        byte[] buf = new byte[size];
        SodiumLibrary.sodium().randombytes_buf(buf, size);
        return buf;
    }

    public static byte[] cryptoPwhash(byte[] passwd, byte[] salt, long opsLimit, NativeLong memLimit, int algorithm) throws SodiumLibraryException {
        byte[] key = new byte[SodiumLibrary.sodium().crypto_box_seedbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_pwhash(key, key.length, passwd, passwd.length, salt, opsLimit, memLimit, algorithm);
        if (logger.isDebugEnabled()) {
            logger.debug(">>> NavtiveLong size: " + NativeLong.SIZE * 8 + " bits");
            logger.debug("crypto_pwhash returned: " + rc);
        }
        if (rc != 0) {
            throw new SodiumLibraryException("cryptoPwhash libsodium crypto_pwhash failed, returned " + rc + ", expected 0");
        }
        return key;
    }

    public static byte[] cryptoPwhashArgon2i(byte[] passwd, byte[] salt) throws SodiumLibraryException {
        int saltLength = SodiumLibrary.cryptoPwhashSaltBytes();
        if (salt.length != saltLength) {
            throw new SodiumLibraryException("salt is " + salt.length + ", it must be" + saltLength + " bytes");
        }
        byte[] key = new byte[SodiumLibrary.sodium().crypto_box_seedbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_pwhash(key, key.length, passwd, passwd.length, salt, SodiumLibrary.sodium().crypto_pwhash_opslimit_interactive(), SodiumLibrary.sodium().crypto_pwhash_memlimit_interactive(), SodiumLibrary.sodium().crypto_pwhash_alg_argon2id13());
        if (logger.isDebugEnabled()) {
            logger.debug(">>> NavtiveLong size: " + NativeLong.SIZE * 8 + " bits");
            logger.debug(">>> opslimit: " + SodiumLibrary.sodium().crypto_pwhash_opslimit_interactive());
            logger.debug(">>> memlimit: " + SodiumLibrary.sodium().crypto_pwhash_memlimit_interactive());
            logger.debug(">>> alg: " + SodiumLibrary.sodium().crypto_pwhash_alg_argon2id13());
            logger.debug("crypto_pwhash returned: " + rc);
        }
        if (rc != 0) {
            throw new SodiumLibraryException("cryptoPwhashArgon2i libsodium crypto_pwhash failed, returned " + rc + ", expected 0");
        }
        return key;
    }

    public static byte[] deriveKey(byte[] passwd, byte[] salt) throws SodiumLibraryException {
        return SodiumLibrary.cryptoPwhashArgon2i(passwd, salt);
    }

    public static String cryptoPwhashStr(byte[] password) throws SodiumLibraryException {
        byte[] hashedPassword = new byte[SodiumLibrary.sodium().crypto_pwhash_strbytes()];
        int rc = SodiumLibrary.sodium().crypto_pwhash_str(hashedPassword, password, password.length, SodiumLibrary.sodium().crypto_pwhash_opslimit_interactive(), SodiumLibrary.sodium().crypto_pwhash_memlimit_interactive());
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_pwhash_str failed, returned " + rc + ", expected 0");
        }
        String usAscii = new String(hashedPassword, StandardCharsets.US_ASCII);
        return usAscii;
    }

    public static boolean cryptoPwhashStrVerify(String usAsciiKey, byte[] password) {
        byte[] keyBytes = usAsciiKey.getBytes(StandardCharsets.US_ASCII);
        int rc = SodiumLibrary.sodium().crypto_pwhash_str_verify(keyBytes, password, password.length);
        return rc == 0;
    }

    public static byte[] cryptoPwhashScrypt(byte[] passwd, byte[] salt) throws SodiumLibraryException {
        NativeLong salt_length = SodiumLibrary.sodium().crypto_pwhash_scryptsalsa208sha256_saltbytes();
        if (salt.length != salt_length.intValue()) {
            throw new SodiumLibraryException("salt is " + salt.length + ", it must be" + salt_length + " bytes");
        }
        byte[] key = new byte[SodiumLibrary.sodium().crypto_box_seedbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_pwhash_scryptsalsa208sha256(key, key.length, passwd, passwd.length, salt, SodiumLibrary.sodium().crypto_pwhash_opslimit_interactive(), SodiumLibrary.sodium().crypto_pwhash_memlimit_interactive());
        if (logger.isDebugEnabled()) {
            logger.debug("crypto_pwhash_scryptsalsa208sha256 returned: " + rc);
        }
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_pwhash_scryptsalsa208sha256() failed, returned " + rc + ", expected 0");
        }
        return key;
    }

    public static byte[] cryptoPwhashScryptSalsa208Sha256(byte[] passwd, byte[] salt, Long opsLimit, NativeLong memLimit) throws SodiumLibraryException {
        NativeLong salt_length = SodiumLibrary.sodium().crypto_pwhash_scryptsalsa208sha256_saltbytes();
        if (salt.length != salt_length.intValue()) {
            throw new SodiumLibraryException("salt is " + salt.length + ", it must be" + salt_length + " bytes");
        }
        byte[] key = new byte[SodiumLibrary.sodium().crypto_box_seedbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_pwhash_scryptsalsa208sha256(key, key.length, passwd, passwd.length, salt, opsLimit, memLimit);
        if (logger.isDebugEnabled()) {
            logger.debug("crypto_pwhash_scryptsalsa208sha256 returned: " + rc);
        }
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_pwhash_scryptsalsa208sha256() failed, returned " + rc + ", expected 0");
        }
        return key;
    }

    public static byte[] cryptoSecretBoxEasy(byte[] message, byte[] nonce, byte[] key) throws SodiumLibraryException {
        int nonce_length = SodiumLibrary.sodium().crypto_secretbox_noncebytes().intValue();
        if (nonce_length != nonce.length) {
            throw new SodiumLibraryException("nonce is " + nonce.length + ", it must be" + nonce_length + " bytes");
        }
        byte[] cipherText = new byte[SodiumLibrary.sodium().crypto_box_macbytes().intValue() + message.length];
        int rc = SodiumLibrary.sodium().crypto_secretbox_easy(cipherText, message, message.length, nonce, key);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_secretbox_easy() failed, returned " + rc + ", expected 0");
        }
        return cipherText;
    }

    public static byte[] cryptoSecretBoxOpenEasy(byte[] cipherText, byte[] nonce, byte[] key) throws SodiumLibraryException {
        if (key.length != SodiumLibrary.sodium().crypto_secretbox_keybytes().intValue()) {
            throw new SodiumLibraryException("invalid key length " + key.length + " bytes");
        }
        if (nonce.length != SodiumLibrary.sodium().crypto_secretbox_noncebytes().intValue()) {
            throw new SodiumLibraryException("invalid nonce length " + nonce.length + " bytes");
        }
        byte[] decrypted = new byte[cipherText.length - SodiumLibrary.sodium().crypto_box_macbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_secretbox_open_easy(decrypted, cipherText, cipherText.length, nonce, key);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_secretbox_open_easy() failed, returned " + rc + ", expected 0");
        }
        return decrypted;
    }

    public static SodiumSecretBox cryptoSecretBoxDetached(byte[] message, byte[] nonce, byte[] key) throws SodiumLibraryException {
        if (key.length != SodiumLibrary.sodium().crypto_secretbox_keybytes().intValue()) {
            throw new SodiumLibraryException("invalid key length " + key.length + " bytes");
        }
        if (nonce.length != SodiumLibrary.sodium().crypto_secretbox_noncebytes().intValue()) {
            throw new SodiumLibraryException("invalid nonce length " + nonce.length + " bytes");
        }
        byte[] cipherText = new byte[message.length];
        byte[] mac = new byte[SodiumLibrary.sodium().crypto_secretbox_macbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_secretbox_detached(cipherText, mac, message, message.length, nonce, key);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_secretbox_detached() failed, returned " + rc + ", expected 0");
        }
        SodiumSecretBox secretBox = new SodiumSecretBox();
        secretBox.setCipherText(cipherText);
        secretBox.setMac(mac);
        return secretBox;
    }

    public static byte[] cryptoSecretBoxOpenDetached(SodiumSecretBox secretBox, byte[] nonce, byte[] key) throws SodiumLibraryException {
        if (key.length != SodiumLibrary.sodium().crypto_secretbox_keybytes().intValue()) {
            throw new SodiumLibraryException("invalid key length " + key.length + " bytes");
        }
        if (nonce.length != SodiumLibrary.sodium().crypto_secretbox_noncebytes().intValue()) {
            throw new SodiumLibraryException("invalid nonce length " + nonce.length + " bytes");
        }
        byte[] mac = secretBox.getMac();
        if (mac.length != SodiumLibrary.sodium().crypto_secretbox_macbytes().intValue()) {
            throw new SodiumLibraryException("invalid mac length " + mac.length + " bytes");
        }
        byte[] message = new byte[secretBox.getCipherText().length];
        byte[] cipherText = secretBox.getCipherText();
        int rc = SodiumLibrary.sodium().crypto_secretbox_open_detached(message, cipherText, mac, cipherText.length, nonce, key);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_secretbox_open_detached() failed, returned " + rc + ", expected 0");
        }
        return message;
    }

    public static byte[] cryptoAuth(byte[] message, byte[] key) throws SodiumLibraryException {
        byte[] mac = new byte[SodiumLibrary.sodium().crypto_auth_bytes().intValue()];
        int keySize = SodiumLibrary.sodium().crypto_auth_keybytes().intValue();
        if (key.length != keySize) {
            throw new SodiumLibraryException("Expected key size " + keySize + " bytes, but passed " + key.length + " bytes");
        }
        int rc = SodiumLibrary.sodium().crypto_auth(mac, message, message.length, key);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_auth() failed, returned " + rc + ", expected 0");
        }
        return mac;
    }

    public static boolean cryptoAuthVerify(byte[] mac, byte[] message, byte[] key) throws SodiumLibraryException {
        int keySize = SodiumLibrary.sodium().crypto_auth_keybytes().intValue();
        if (key.length != keySize) {
            throw new SodiumLibraryException("Expected key size " + keySize + " bytes, but passed " + key.length + " bytes");
        }
        int rc = SodiumLibrary.sodium().crypto_auth_verify(mac, message, message.length, key);
        if (rc == 0) {
            return true;
        }
        if (rc == -1) {
            return false;
        }
        return false;
    }

    public static SodiumKeyPair cryptoBoxKeyPair() throws SodiumLibraryException {
        SodiumKeyPair kp = new SodiumKeyPair();
        byte[] publicKey = new byte[SodiumLibrary.sodium().crypto_box_publickeybytes().intValue()];
        byte[] privateKey = new byte[SodiumLibrary.sodium().crypto_box_secretkeybytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_box_keypair(publicKey, privateKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_box_keypair() failed, returned " + rc + ", expected 0");
        }
        kp.setPublicKey(publicKey);
        kp.setPrivateKey(privateKey);
        if (logger.isDebugEnabled()) {
            logger.debug("pk len: " + publicKey.length);
            logger.debug("sk len: " + privateKey.length);
        }
        return kp;
    }

    public static byte[] cryptoPublicKey(byte[] privateKey) throws SodiumLibraryException {
        byte[] publicKey = new byte[SodiumLibrary.sodium().crypto_box_publickeybytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_scalarmult_base(publicKey, privateKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_scalrmult() failed, returned " + rc + ", expected 0");
        }
        return publicKey;
    }

    public static NativeLong cryptoBoxNonceBytes() {
        return SodiumLibrary.sodium().crypto_box_noncebytes();
    }

    public static NativeLong crytoBoxSeedBytes() {
        return SodiumLibrary.sodium().crypto_box_seedbytes();
    }

    public static NativeLong crytoBoxPublicKeyBytes() {
        return SodiumLibrary.sodium().crypto_box_publickeybytes();
    }

    public static NativeLong crytoBoxSecretKeyBytes() {
        return SodiumLibrary.sodium().crypto_box_secretkeybytes();
    }

    public static NativeLong cryptoBoxMacBytes() {
        return SodiumLibrary.sodium().crypto_box_macbytes();
    }

    public static NativeLong cryptoBoxSealBytes() {
        return SodiumLibrary.sodium().crypto_box_sealbytes();
    }

    public static NativeLong cryptoSecretBoxKeyBytes() {
        return SodiumLibrary.sodium().crypto_secretbox_keybytes();
    }

    public static NativeLong cryptoSecretBoxNonceBytes() {
        return SodiumLibrary.sodium().crypto_secretbox_noncebytes();
    }

    public static NativeLong cryptoSecretBoxMacBytes() {
        return SodiumLibrary.sodium().crypto_secretbox_macbytes();
    }

    public static int cryptoNumberSaltBytes() {
        return SodiumLibrary.sodium().crypto_pwhash_saltbytes();
    }

    public static int cryptoPwhashAlgArgon2i13() {
        return SodiumLibrary.sodium().crypto_pwhash_alg_argon2i13();
    }

    public static int cryptoPwhashAlgArgon2id13() {
        return SodiumLibrary.sodium().crypto_pwhash_alg_argon2id13();
    }

    public static int cryptoPwhashAlgDefault() {
        return SodiumLibrary.sodium().crypto_pwhash_alg_default();
    }

    public static int cryptoPwhashSaltBytes() {
        return SodiumLibrary.sodium().crypto_pwhash_saltbytes();
    }

    public static long cryptoPwHashOpsLimitInteractive() {
        return SodiumLibrary.sodium().crypto_pwhash_opslimit_interactive();
    }

    public static NativeLong cryptoPwHashMemLimitInterative() {
        return SodiumLibrary.sodium().crypto_pwhash_memlimit_interactive();
    }

    public static NativeLong cryptoPwHashScryptSalsa208Sha256SaltBytes() {
        return SodiumLibrary.sodium().crypto_pwhash_scryptsalsa208sha256_saltbytes();
    }

    public static byte[] cryptoBoxEasy(byte[] message, byte[] nonce, byte[] publicKey, byte[] privateKey) throws SodiumLibraryException {
        NativeLong nonce_len = SodiumLibrary.sodium().crypto_box_noncebytes();
        if (nonce.length != nonce_len.intValue()) {
            throw new SodiumLibraryException("nonce is " + nonce.length + "bytes, it must be" + nonce_len + " bytes");
        }
        byte[] cipherText = new byte[SodiumLibrary.sodium().crypto_box_macbytes().intValue() + message.length];
        int rc = SodiumLibrary.sodium().crypto_box_easy(cipherText, message, message.length, nonce, publicKey, privateKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_box_easy() failed, returned " + rc + ", expected 0");
        }
        return cipherText;
    }

    public static byte[] cryptoBoxOpenEasy(byte[] cipherText, byte[] nonce, byte[] publicKey, byte[] privateKey) throws SodiumLibraryException {
        NativeLong nonce_len = SodiumLibrary.sodium().crypto_box_noncebytes();
        if (nonce.length != nonce_len.intValue()) {
            throw new SodiumLibraryException("nonce is " + nonce.length + "bytes, it must be" + nonce_len + " bytes");
        }
        byte[] decrypted = new byte[cipherText.length - SodiumLibrary.sodium().crypto_box_macbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_box_open_easy(decrypted, cipherText, cipherText.length, nonce, publicKey, privateKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_box_open_easy() failed, returned " + rc + ", expected 0");
        }
        return decrypted;
    }

    public static byte[] cryptoBoxSeal(byte[] message, byte[] recipientPublicKey) throws SodiumLibraryException {
        if (logger.isDebugEnabled()) {
            logger.debug("message len: " + message.length);
        }
        byte[] cipherText = new byte[SodiumLibrary.sodium().crypto_box_sealbytes().intValue() + message.length];
        int rc = SodiumLibrary.sodium().crypto_box_seal(cipherText, message, message.length, recipientPublicKey);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_box_seal() failed, returned " + rc + ", expected 0");
        }
        return cipherText;
    }

    public static byte[] cryptoBoxSealOpen(byte[] cipherText, byte[] pk, byte[] sk) throws SodiumLibraryException {
        byte[] decrypted = new byte[cipherText.length - SodiumLibrary.sodium().crypto_box_sealbytes().intValue()];
        int rc = SodiumLibrary.sodium().crypto_box_seal_open(decrypted, cipherText, cipherText.length, pk, sk);
        if (rc != 0) {
            throw new SodiumLibraryException("libsodium crypto_box_seal_open() failed, returned " + rc + ", expected 0");
        }
        return decrypted;
    }

    static /* synthetic */ String access$000() {
        return libPath;
    }

    static {
        initialized = false;
    }

    public static interface Sodium
    extends Library {
        public int sodium_library_version_major();

        public int sodium_library_version_minor();

        public int sodium_init();

        public String sodium_version_string();

        public void randombytes_buf(byte[] var1, int var2);

        public int crypto_pwhash_alg_argon2i13();

        public int crypto_pwhash_alg_argon2id13();

        public int crypto_pwhash_alg_default();

        public int crypto_pwhash_saltbytes();

        public int crypto_pwhash_strbytes();

        public Pointer crypto_pwhash_strprefix();

        public long crypto_pwhash_opslimit_interactive();

        public NativeLong crypto_pwhash_memlimit_interactive();

        public long crypto_pwhash_opslimit_moderate();

        public NativeLong crypto_pwhash_memlimit_moderate();

        public long crypto_pwhash_opslimit_sensitive();

        public NativeLong crypto_pwhash_memlimit_sensitive();

        public NativeLong crypto_box_seedbytes();

        public NativeLong crypto_box_publickeybytes();

        public NativeLong crypto_box_secretkeybytes();

        public NativeLong crypto_box_noncebytes();

        public NativeLong crypto_box_macbytes();

        public NativeLong crypto_box_sealbytes();

        public NativeLong crypto_auth_bytes();

        public NativeLong crypto_auth_keybytes();

        public int crypto_pwhash(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, NativeLong var10, int var11);

        public int crypto_pwhash_scryptsalsa208sha256(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, NativeLong var10);

        public int crypto_pwhash_str(byte[] var1, byte[] var2, long var3, long var5, NativeLong var7);

        public int crypto_pwhash_str_verify(byte[] var1, byte[] var2, long var3);

        public NativeLong crypto_pwhash_scryptsalsa208sha256_saltbytes();

        public NativeLong crypto_secretbox_keybytes();

        public NativeLong crypto_secretbox_noncebytes();

        public NativeLong crypto_secretbox_macbytes();

        public int crypto_secretbox_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public int crypto_secretbox_open_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public int crypto_secretbox_detached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public int crypto_secretbox_open_detached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public int crypto_box_seal(byte[] var1, byte[] var2, long var3, byte[] var5);

        public int crypto_box_seal_open(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public int crypto_auth(byte[] var1, byte[] var2, long var3, byte[] var5);

        public int crypto_auth_verify(byte[] var1, byte[] var2, long var3, byte[] var5);

        public int crypto_box_keypair(byte[] var1, byte[] var2);

        public int crypto_scalarmult(byte[] var1, byte[] var2, byte[] var3);

        public int crypto_scalarmult_base(byte[] var1, byte[] var2);

        public int crypto_box_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6, byte[] var7);

        public int crypto_box_open_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6, byte[] var7);

        public long crypto_sign_secretkeybytes();

        public long crypto_sign_publickeybytes();

        public int crypto_sign_keypair(byte[] var1, byte[] var2);

        public int crypto_sign_ed25519_bytes();

        public int crypto_sign_bytes();

        public int crypto_sign_detached(byte[] var1, long var2, byte[] var4, long var5, byte[] var7);

        public int crypto_sign_verify_detached(byte[] var1, byte[] var2, long var3, byte[] var5);

        public int crypto_sign(byte[] var1, long var2, byte[] var4, long var5, byte[] var7);

        public int crypto_sign_open(byte[] var1, long var2, byte[] var4, long var5, byte[] var7);

        public int crypto_generichash(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, long var6);

        public int crypto_sign_ed25519_sk_to_curve25519(byte[] var1, byte[] var2);

        public int crypto_sign_ed25519_pk_to_curve25519(byte[] var1, byte[] var2);
    }

    private static final class SingletonHelper {
        public static final Sodium instance = (Sodium)Native.loadLibrary((String)SodiumLibrary.access$000(), Sodium.class);

        private SingletonHelper() {
        }
    }
}

