/*
 * Decompiled with CFR 0.152.
 */
package com.my.target;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.aa;
import com.my.target.ae;
import com.my.target.br;
import com.my.target.bs;
import com.my.target.common.BaseAd;
import com.my.target.cy;
import com.my.target.di;
import com.my.target.ir;
import com.my.target.l;
import com.my.target.z;
import java.util.ArrayList;

public class InstreamResearch
extends BaseAd {
    private final int duration;
    @NonNull
    private final Context context;
    private int state = 0;
    private int lastPosition = -1;
    @Nullable
    private InstreamResearchListener listener;
    @Nullable
    private z researchProgressTracker;
    @Nullable
    private aa researchViewabilityTracker;
    @Nullable
    private br banner;

    @NonNull
    public static InstreamResearch newResearch(int slotId, int duration, @NonNull Context context) {
        return new InstreamResearch(slotId, duration, context);
    }

    private InstreamResearch(int slotId, int duration, @NonNull Context context) {
        super(slotId, "instreamresearch");
        this.duration = duration;
        this.context = context;
        ae.c("InstreamResearch created. Version: 5.14.4");
    }

    public void load() {
        di di2 = this.metricFactory.de();
        l.a(this.adConfig, this.metricFactory, this.duration).a(this::handleResult).a((bs)((Object)di2), this.context);
    }

    public void registerPlayerView(@NonNull View v2) {
        if (this.researchViewabilityTracker != null) {
            this.researchViewabilityTracker.a(v2);
        }
    }

    public void unregisterPlayerView() {
        if (this.researchViewabilityTracker != null) {
            this.researchViewabilityTracker.a(null);
        }
    }

    public void trackPause() {
        if (this.state != 1) {
            ae.b("Unable to track pause, wrong state " + this.getReadableState(this.state));
            return;
        }
        this.trackEvent("playbackPaused");
        this.state = 2;
    }

    public void trackResume() {
        if (this.state != 2) {
            ae.b("VideoAdTracker error: unable to track resume, wrong state " + this.getReadableState(this.state));
            return;
        }
        this.trackEvent("playbackResumed");
        this.state = 1;
    }

    public void trackProgress(float progress) {
        if (this.state < 1) {
            this.trackEvent("playbackStarted");
            this.state = 1;
        }
        if (this.state > 1) {
            ae.a("Unable to track progress while state is: " + this.getReadableState(this.state));
            return;
        }
        int n2 = Math.round(progress);
        if (n2 < this.lastPosition) {
            this.trackEvent("rewind");
        } else if (n2 == this.lastPosition) {
            return;
        }
        this.lastPosition = n2;
        if (this.researchViewabilityTracker != null) {
            this.researchViewabilityTracker.c(n2);
        }
        if (this.researchProgressTracker != null) {
            this.researchProgressTracker.a(n2, this.duration, this.context);
        }
    }

    public void trackMute(boolean mute) {
        String string = mute ? "volumeOff" : "volumeOn";
        this.trackEvent(string);
    }

    public void trackFullscreen(boolean fullscreen) {
        String string = fullscreen ? "fullscreenOn" : "fullscreenOff";
        this.trackEvent(string);
    }

    public void setListener(@Nullable InstreamResearchListener listener) {
        this.listener = listener;
    }

    private void handleResult(@Nullable bs result, @Nullable String error) {
        if (result != null) {
            this.banner = result.bE();
            if (this.banner != null) {
                this.researchProgressTracker = z.a(this.banner.getStatHolder());
                this.researchViewabilityTracker = aa.b(this.banner.getStatHolder());
                if (this.listener != null) {
                    this.listener.onLoad(this);
                }
                return;
            }
        }
        if (this.listener != null) {
            this.listener.onNoData(this, error);
        }
    }

    private String getReadableState(int state) {
        switch (state) {
            default: {
                return "unknown";
            }
            case 0: {
                return "idle";
            }
            case 1: {
                return "started";
            }
            case 2: {
                return "paused";
            }
            case 3: 
        }
        return "completed";
    }

    private void trackEvent(@NonNull String type) {
        ArrayList<cy> arrayList;
        if (this.banner != null && !(arrayList = this.banner.getStatHolder().I(type)).isEmpty()) {
            ir.a(arrayList, this.context);
        }
    }

    public static interface InstreamResearchListener {
        public void onLoad(@NonNull InstreamResearch var1);

        public void onNoData(@NonNull InstreamResearch var1, @Nullable String var2);
    }
}

