/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.ads;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.R;
import com.my.target.a;
import com.my.target.ab;
import com.my.target.ae;
import com.my.target.bj;
import com.my.target.common.CustomParams;
import com.my.target.cu;
import com.my.target.di;
import com.my.target.fy;
import com.my.target.is;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MyTargetView
extends FrameLayout {
    @NonNull
    private final a adConfig;
    @NonNull
    private final AtomicBoolean isLoaded = new AtomicBoolean();
    @Nullable
    private MyTargetViewListener listener;
    @Nullable
    private bj engine;
    @NonNull
    private AdSize adSize;
    private boolean fixedSize = false;
    private boolean attached;

    @Nullable
    public MyTargetViewListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable MyTargetViewListener listener) {
        this.listener = listener;
    }

    public boolean isMediationEnabled() {
        return this.adConfig.isMediationEnabled();
    }

    public void setMediationEnabled(boolean mediationEnabled) {
        this.adConfig.setMediationEnabled(mediationEnabled);
    }

    @NonNull
    public CustomParams getCustomParams() {
        return this.adConfig.getCustomParams();
    }

    @NonNull
    public AdSize getSize() {
        return this.adSize;
    }

    public void setAdSize(@NonNull AdSize adSize) {
        if (adSize == null) {
            ae.a("AdSize cannot be null");
            return;
        }
        if (this.fixedSize && AdSize.isSame(this.adSize, adSize)) {
            return;
        }
        this.fixedSize = true;
        if (this.isLoaded.get() && (AdSize.isSame(this.adSize, AdSize.ADSIZE_300x250) || AdSize.isSame(adSize, AdSize.ADSIZE_300x250))) {
            ae.a("unable to switch size to/from 300x250");
            return;
        }
        if (this.engine != null) {
            this.engine.a(adSize);
            View view = this.getChildAt(0);
            if (view instanceof fy) {
                view.requestLayout();
            }
        }
        this.adSize = adSize;
        this.setFormat();
    }

    public void setSlotId(int slotId) {
        if (this.isLoaded.get()) {
            return;
        }
        this.adConfig.setSlotId(slotId);
    }

    public void setRefreshAd(boolean refreshAd) {
        this.adConfig.setRefreshAd(refreshAd);
    }

    public MyTargetView(@NonNull Context context) {
        this(context, null);
    }

    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        ae.c("MyTargetView created. Version: 5.14.4");
        this.adConfig = a.newConfig(0, "");
        this.adSize = AdSize.getAdSizeForCurrentOrientation(context);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = null;
        try {
            typedArray = context.obtainStyledAttributes(attrs, R.styleable.MyTargetView);
        }
        catch (Throwable throwable) {
            ae.a("unable to get view attributes: " + throwable.getMessage());
        }
        if (typedArray == null) {
            return;
        }
        int n2 = typedArray.getInt(R.styleable.MyTargetView_myTarget_slotId, 0);
        this.adConfig.setSlotId(n2);
        this.adConfig.setRefreshAd(typedArray.getBoolean(R.styleable.MyTargetView_myTarget_isRefreshAd, true));
        int n3 = typedArray.getInt(R.styleable.MyTargetView_myTarget_adSize, -1);
        if (n3 >= 0) {
            if (n3 != 3) {
                this.fixedSize = true;
            }
            this.adSize = AdSize.fromInt(n3, context);
        }
        typedArray.recycle();
    }

    @Deprecated
    public void init(int slotId) {
        this.init(slotId, true);
    }

    @Deprecated
    public void init(int slotId, boolean isRefreshAd) {
        this.init(slotId, 0, isRefreshAd);
    }

    @Deprecated
    public void init(int slotId, int adSize) {
        this.init(slotId, adSize, true);
    }

    @Deprecated
    public void init(int slotId, int adSize, boolean isRefreshAd) {
        this.setAdSize(AdSize.fromInt(adSize, this.getContext()));
        this.adConfig.setSlotId(slotId);
        this.adConfig.setRefreshAd(isRefreshAd);
        ae.a("MyTargetView initialized");
    }

    public final void load() {
        if (!this.isLoaded.compareAndSet(false, true)) {
            ae.a("MyTargetView doesn't support multiple load");
            return;
        }
        di.a a2 = di.z(this.adConfig.getSlotId());
        di di2 = a2.de();
        ae.a("MyTargetView load");
        this.setFormat();
        ab.a(this.adConfig, a2).a((result, error) -> this.handleResult((cu)result, error, a2)).a((cu)((Object)di2), this.getContext());
    }

    public void loadFromBid(@NonNull String bidId) {
        this.adConfig.setBidId(bidId);
        this.adConfig.setRefreshAd(false);
        this.load();
    }

    public final void handleSection(@NonNull cu section, @NonNull AdSize adSize) {
        di.a a2 = di.z(this.adConfig.getSlotId());
        di di2 = a2.de();
        ab.a(section, this.adConfig, a2).a((result, error) -> this.handleResult((cu)result, error, a2)).a((cu)((Object)di2), this.getContext());
    }

    @Nullable
    public String getAdSource() {
        if (this.engine != null) {
            return this.engine.ag();
        }
        return null;
    }

    public float getAdSourcePriority() {
        if (this.engine != null) {
            return this.engine.ah();
        }
        return 0.0f;
    }

    private void handleResult(@Nullable cu result, @Nullable String error, @NonNull di.a metricFactory) {
        if (this.listener == null) {
            return;
        }
        if (result == null) {
            this.listener.onNoAd(error == null ? "no ad" : error, this);
            return;
        }
        if (this.engine != null) {
            this.engine.destroy();
        }
        this.engine = bj.a(this, this.adConfig, metricFactory);
        this.engine.j(this.attached);
        this.engine.a(result);
        this.adConfig.setBidId(null);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.engine != null) {
            this.engine.onWindowFocusChanged(hasWindowFocus);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attached = true;
        if (this.engine != null) {
            this.engine.j(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.attached = false;
        if (this.engine != null) {
            this.engine.j(false);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.fixedSize) {
            this.updateAdaptiveSize();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
        }
        this.listener = null;
    }

    private void setFormat() {
        if (this.adSize == AdSize.ADSIZE_320x50) {
            this.adConfig.setFormat("standard_320x50");
        } else if (this.adSize == AdSize.ADSIZE_300x250) {
            this.adConfig.setFormat("standard_300x250");
        } else if (this.adSize == AdSize.ADSIZE_728x90) {
            this.adConfig.setFormat("standard_728x90");
        } else {
            this.adConfig.setFormat("standard");
        }
    }

    private void updateAdaptiveSize() {
        Context context = this.getContext();
        Point point = is.ac(context);
        int n2 = point.x;
        float f2 = point.y;
        if (n2 == this.adSize.width && (float)this.adSize.height <= f2 * 0.15f) {
            return;
        }
        this.adSize = AdSize.getAdSizeForCurrentOrientation(context);
        if (this.engine != null) {
            this.engine.a(this.adSize);
        }
    }

    public static interface MyTargetViewListener {
        public void onLoad(@NonNull MyTargetView var1);

        public void onNoAd(@NonNull String var1, @NonNull MyTargetView var2);

        public void onShow(@NonNull MyTargetView var1);

        public void onClick(@NonNull MyTargetView var1);
    }

    public static final class AdSize {
        public static final int BANNER_320x50 = 0;
        public static final int BANNER_300x250 = 1;
        public static final int BANNER_728x90 = 2;
        public static final int BANNER_ADAPTIVE = 3;
        public static final AdSize ADSIZE_320x50 = new AdSize(320, 50, 0);
        public static final AdSize ADSIZE_300x250 = new AdSize(300, 250, 1);
        public static final AdSize ADSIZE_728x90 = new AdSize(728, 90, 2);
        private static final int MIN_HEIGHT = 50;
        private static final float MAX_HEIGHT_PROPORTION = 0.15f;
        private final int width;
        private final int height;
        private final int widthPixels;
        private final int heightPixels;
        private final int type;

        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, int maxHeight, @NonNull Context context) {
            Point point = is.ac(context);
            float f2 = is.fN();
            return AdSize.getSize((float)width * f2, Math.min((float)maxHeight * f2, (float)point.y * 0.15f));
        }

        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, @NonNull Context context) {
            Point point = is.ac(context);
            return AdSize.getSize((float)width * is.fN(), (float)point.y * 0.15f);
        }

        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(@NonNull Context context) {
            Point point = is.ac(context);
            return AdSize.getSize(point.x, (float)point.y * 0.15f);
        }

        @NonNull
        private static AdSize getSize(float w2, float h2) {
            float f2 = is.fN();
            float f3 = w2 > 524.0f ? w2 / 728.0f * 90.0f : w2 / 320.0f * 50.0f;
            f3 = Math.min(f3, h2);
            f3 = Math.max(f3, 50.0f * f2);
            return new AdSize((int)(w2 / f2), (int)(f3 / f2), (int)w2, (int)f3, 3);
        }

        @NonNull
        private static AdSize fromInt(int adSize, @NonNull Context context) {
            AdSize adSize2;
            switch (adSize) {
                default: {
                    adSize2 = ADSIZE_320x50;
                    break;
                }
                case 1: {
                    adSize2 = ADSIZE_300x250;
                    break;
                }
                case 2: {
                    adSize2 = ADSIZE_728x90;
                    break;
                }
                case 3: {
                    adSize2 = AdSize.getAdSizeForCurrentOrientation(context);
                }
            }
            return adSize2;
        }

        private static boolean isSame(@NonNull AdSize adSize, @NonNull AdSize adSize2) {
            return adSize.height == adSize2.height && adSize.width == adSize2.width && adSize.type == adSize2.type;
        }

        private AdSize(int widthDp, int heightDp, int widthPixels, int heightPixels, int type) {
            this.width = widthDp;
            this.height = heightDp;
            this.widthPixels = widthPixels;
            this.heightPixels = heightPixels;
            this.type = type;
        }

        private AdSize(int widthDp, int heightDp, int type) {
            this.width = widthDp;
            this.height = heightDp;
            float f2 = is.fN();
            this.widthPixels = (int)((float)widthDp * f2);
            this.heightPixels = (int)((float)heightDp * f2);
            this.type = type;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidthPixels() {
            return this.widthPixels;
        }

        public int getHeightPixels() {
            return this.heightPixels;
        }

        public int getType() {
            return this.type;
        }
    }
}

