/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class MyTargetConfig {
    public final boolean isTrackingEnvironmentEnabled;
    public final boolean isTrackingLocationEnabled;
    @Nullable
    public final String[] testDevices;

    MyTargetConfig(boolean isTrackingEnvironmentEnabled, boolean isTrackingLocationEnabled, @Nullable String[] testDevices) {
        this.isTrackingEnvironmentEnabled = isTrackingEnvironmentEnabled;
        this.isTrackingLocationEnabled = isTrackingLocationEnabled;
        this.testDevices = testDevices;
    }

    public static final class Builder {
        private static final boolean DEFAULT_TRACKING_LOCATION = true;
        private static final boolean DEFAULT_TRACKING_ENVIRONMENT = true;
        boolean trackingEnvironment = true;
        boolean trackingLocation = true;
        @Nullable
        String[] testDevices;

        @NonNull
        public MyTargetConfig build() {
            return new MyTargetConfig(this.trackingEnvironment, this.trackingLocation, this.testDevices);
        }

        @NonNull
        public Builder from(@NonNull MyTargetConfig myTargetConfig) {
            this.trackingLocation = myTargetConfig.isTrackingLocationEnabled;
            this.trackingEnvironment = myTargetConfig.isTrackingEnvironmentEnabled;
            this.testDevices = myTargetConfig.testDevices;
            return this;
        }

        @NonNull
        public Builder withTrackingEnvironment(boolean enabled) {
            this.trackingEnvironment = enabled;
            return this;
        }

        @NonNull
        public Builder withTrackingLocation(boolean enabled) {
            this.trackingLocation = enabled;
            return this;
        }

        @NonNull
        public Builder withTestDevices(String ... testDevices) {
            this.testDevices = testDevices;
            return this;
        }
    }
}

