/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common;

import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.my.target.ae;
import com.my.target.af;
import com.my.target.common.MyTargetConfig;
import com.my.target.common.MyTargetPrivacy;
import com.my.target.fd;
import com.my.target.ig;
import com.my.target.ii;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MyTargetManager {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    @NonNull
    private static volatile MyTargetConfig myTargetConfig = new MyTargetConfig.Builder().build();

    public static void setDebugMode(boolean debugMode) {
        ae.enabled = debugMode;
        if (debugMode) {
            ae.a("Debug mode enabled");
        }
    }

    public static void setSdkConfig(@NonNull MyTargetConfig config) {
        myTargetConfig = config;
    }

    @NonNull
    public static MyTargetConfig getSdkConfig() {
        return myTargetConfig;
    }

    @WorkerThread
    @NonNull
    public static String getBidderToken(@NonNull Context context) {
        fd fd2 = fd.el();
        fd2.G(MyTargetPrivacy.currentPrivacy().isConsent());
        return fd2.getBidderToken(context);
    }

    @AnyThread
    public static void initSdk(@NonNull Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            ae.c("MyTarget cannot be initialized due to a null application context");
            return;
        }
        if (!INITIALIZED.compareAndSet(false, true)) {
            return;
        }
        ae.c("MyTarget initialization");
        af.a(() -> {
            ig.V(context2);
            fd.el().B(context2);
            ii.W(context2);
        });
    }
}

