/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common.models;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.LruCache;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.bt;

public final class ImageData
extends bt<Bitmap> {
    private static final int MIN_CACHE_SIZE = 0x500000;
    private static final int DEFAULT_CACHE_SIZE = 0x1E00000;
    @NonNull
    private static volatile LruCache<ImageData, Bitmap> memcache = new BitmapCache(0x1E00000);
    private volatile boolean useCache;

    @AnyThread
    public static void setCacheSize(int sizeInBytes) {
        if (sizeInBytes < 0x500000) {
            ae.a("setting cache size ignored: size should be >=5242880");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            memcache.resize(sizeInBytes);
        } else {
            memcache = new BitmapCache(sizeInBytes);
        }
    }

    @AnyThread
    public static void clearCache() {
        memcache.evictAll();
    }

    @NonNull
    public static ImageData newImageData(@NonNull String url) {
        return new ImageData(url);
    }

    @NonNull
    public static ImageData newImageData(@NonNull String url, int width, int height) {
        return new ImageData(url, width, height);
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.getData();
    }

    public void setBitmap(@Nullable Bitmap bitmap) {
        this.setData(bitmap);
    }

    @Override
    @Nullable
    public Bitmap getData() {
        if (this.useCache) {
            return (Bitmap)memcache.get((Object)this);
        }
        return (Bitmap)super.getData();
    }

    @Override
    public void setData(@Nullable Bitmap data) {
        if (this.useCache) {
            if (data == null) {
                memcache.remove((Object)this);
            } else {
                memcache.put((Object)this, (Object)data);
            }
        } else {
            super.setData(data);
        }
    }

    private ImageData(@NonNull String url) {
        super(url);
    }

    private ImageData(@NonNull String url, int width, int height) {
        super(url);
        this.width = width;
        this.height = height;
    }

    public void useCache(boolean use) {
        if (use == this.useCache) {
            return;
        }
        this.useCache = use;
        if (use) {
            Bitmap bitmap = (Bitmap)super.getData();
            if (bitmap != null) {
                super.setData(null);
                memcache.put((Object)this, (Object)bitmap);
            }
        } else {
            Bitmap bitmap = (Bitmap)memcache.remove((Object)this);
            super.setData(bitmap);
        }
    }

    @NonNull
    public String toString() {
        return "ImageData{url='" + this.url + '\'' + ", width=" + this.width + ", height=" + this.height + ", bitmap=" + this.getData() + '}';
    }

    static class BitmapCache
    extends LruCache<ImageData, Bitmap> {
        public BitmapCache(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(ImageData key, Bitmap value) {
            if (Build.VERSION.SDK_INT >= 19) {
                return value.getAllocationByteCount();
            }
            return value.getByteCount();
        }
    }
}

