/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;

public class StarsRatingView
extends View {
    private static final float ACCURACY = 0.2f;
    private static final int ORANGE = -552162;
    private static final int GRAY = -3355444;
    private static final float RAY_LENGTH = 0.45f;
    private static final Paint STAR_PAINT = new Paint();
    private int starSize;
    private float starPadding;
    private float rating;
    @Nullable
    private Bitmap starsBitmap;
    private boolean bitmapCreating;

    public StarsRatingView(@NonNull Context context) {
        super(context);
    }

    public void setStarSize(int starSize) {
        this.starSize = starSize;
    }

    public void setRating(float rating) {
        this.setContentDescription(Float.toString(rating));
        if (rating > 5.0f || rating < 0.0f) {
            ae.a("Rating is out of bounds: " + rating);
            this.rating = 0.0f;
        } else {
            this.rating = rating;
        }
        this.invalidate();
    }

    public void setStarsPadding(float padding) {
        this.starPadding = padding;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = this.starSize > 0 ? this.starSize : (this.starSize = View.MeasureSpec.getSize((int)heightMeasureSpec));
        int n3 = (int)((float)(n2 * 5) + this.starPadding * 4.0f);
        this.setMeasuredDimension(n3, n2);
    }

    protected void onDraw(Canvas canvas) {
        if (this.rating > 0.0f) {
            if (this.starsBitmap == null) {
                if (this.starSize > 0 && !this.bitmapCreating) {
                    this.bitmapCreating = true;
                    this.post(this::createBitmap);
                }
            } else {
                canvas.drawBitmap(this.starsBitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private void createBitmap() {
        if (this.starSize <= 0) {
            return;
        }
        int n2 = (int)Math.floor(this.rating);
        int n3 = (int)Math.ceil(5.0f - this.rating);
        boolean bl2 = this.rating - (float)n2 >= 0.2f;
        try {
            this.starsBitmap = Bitmap.createBitmap((int)((int)(((float)this.starSize + this.starPadding) * 5.0f)), (int)this.starSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ae.a("Unable to create rating bitmap because of OOME");
            return;
        }
        Canvas canvas = new Canvas(this.starsBitmap);
        int n4 = 0;
        this.drawStars(n4, this.starSize, -552162, canvas, n2);
        n4 = (int)((float)n4 + ((float)this.starSize + this.starPadding) * (float)n2);
        this.drawStars(n4, this.starSize, -3355444, canvas, n3);
        if (bl2) {
            this.drawOrangePartStar(n4, this.starSize, (float)((double)this.rating - Math.floor(this.rating)), canvas);
        }
        this.invalidate();
        this.bitmapCreating = false;
    }

    private void drawStars(int startPosition, int height, int color2, @NonNull Canvas canvas, int count) {
        STAR_PAINT.setColor(color2);
        Path path = this.drawStarPath(startPosition, height / 2, count);
        canvas.drawPath(path, STAR_PAINT);
    }

    @NonNull
    private Path drawStarPath(int offset, float radius, int count) {
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        double d2 = 0.6283185307179586;
        for (int i2 = 0; i2 < count; ++i2) {
            float f2 = (float)offset + radius + (float)i2 * radius * 2.0f + (float)i2 * this.starPadding;
            float f3 = radius;
            float f4 = radius * 0.45f;
            path.moveTo((float)((double)f2 + (double)radius * Math.sin(0.0)), 2.0f * radius - (float)((double)f3 + (double)radius * Math.cos(0.0)));
            path.lineTo((float)((double)f2 + (double)f4 * Math.sin(d2)), 2.0f * radius - (float)((double)f3 + (double)f4 * Math.cos(d2)));
            for (int i3 = 1; i3 < 5; ++i3) {
                path.lineTo((float)((double)f2 + (double)radius * Math.sin(2.0 * d2 * (double)i3)), 2.0f * radius - (float)((double)f3 + (double)radius * Math.cos(2.0 * d2 * (double)i3)));
                path.lineTo((float)((double)f2 + (double)f4 * Math.sin(2.0 * d2 * (double)i3 + d2)), 2.0f * radius - (float)((double)f3 + (double)f4 * Math.cos(2.0 * d2 * (double)i3 + d2)));
            }
        }
        path.close();
        return path;
    }

    private void drawOrangePartStar(int startPosition, int height, float orangePart, @NonNull Canvas canvas) {
        STAR_PAINT.setColor(-552162);
        Path path = this.drawStarPath(0, height / 2, 1);
        Rect rect = new Rect(startPosition, 0, (int)((float)startPosition + (float)height * orangePart), height);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)(orangePart * (float)height)), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawPath(path, STAR_PAINT);
        canvas.drawBitmap(bitmap, null, rect, STAR_PAINT);
    }

    static {
        STAR_PAINT.setAntiAlias(true);
        STAR_PAINT.setStyle(Paint.Style.FILL);
    }
}

