/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.at;
import com.my.target.cf;
import com.my.target.co;
import com.my.target.common.BaseAd;
import com.my.target.common.models.VideoData;
import com.my.target.cr;
import com.my.target.di;
import com.my.target.f;
import com.my.target.fo;
import com.my.target.ih;
import com.my.target.instreamads.InstreamAdPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InstreamAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @Nullable
    private co section;
    @Nullable
    private at engine;
    @Nullable
    private InstreamAdPlayer player;
    @Nullable
    private InstreamAdListener listener;
    private int loadingTimeoutSeconds = 10;
    private boolean isFullscreen;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float videoDuration;
    private float volume = 1.0f;

    public InstreamAd(int slotId, @NonNull Context context) {
        super(slotId, "instreamads");
        this.context = context;
        ae.c("InstreamAd created. Version: 5.14.4");
    }

    @NonNull
    public List<String> getVideoSectionNames() {
        if (this.section == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<cr<VideoData>> arrayList2 = this.section.ci();
        if (arrayList2.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        for (cr<VideoData> cr2 : arrayList2) {
            if (cr2.getBannersCount() <= 0 && !cr2.cu()) continue;
            arrayList.add(cr2.getName());
        }
        return arrayList;
    }

    @Nullable
    public InstreamAdListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable InstreamAdListener listener) {
        this.listener = listener;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            ae.a("unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            ae.a("ad loading timeout set to " + loadingTimeout + " seconds");
            this.loadingTimeoutSeconds = loadingTimeout;
        }
        if (this.engine != null) {
            this.engine.f(this.loadingTimeoutSeconds);
        }
    }

    public int getVideoQuality() {
        return this.adConfig.getVideoQuality();
    }

    public void setVideoQuality(int videoQuality) {
        this.adConfig.setVideoQuality(videoQuality);
    }

    @Nullable
    public InstreamAdPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable InstreamAdPlayer player) {
        this.player = player;
        if (this.engine != null) {
            this.engine.setPlayer(player);
        }
    }

    public void swapPlayer(@Nullable InstreamAdPlayer player) {
        this.player = player;
        if (this.engine != null) {
            this.engine.swapPlayer(player);
        }
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.isFullscreen = fullscreen;
        if (this.engine != null) {
            this.engine.setFullscreen(fullscreen);
        }
    }

    public float getVolume() {
        if (this.engine != null) {
            return this.engine.getVolume();
        }
        return this.volume;
    }

    public void setVolume(float volume) {
        if (Float.compare(volume, 0.0f) < 0 || Float.compare(volume, 1.0f) > 0) {
            ae.a("unable to set volume" + volume + ", volume must be in range [0..1]");
            return;
        }
        this.volume = volume;
        if (this.engine != null) {
            this.engine.setVolume(volume);
        }
    }

    @NonNull
    public float[] getMidPoints() {
        if (this.midpoints == null) {
            return new float[0];
        }
        return (float[])this.midpoints.clone();
    }

    public void load() {
        if (this.isLoadCalled()) {
            ae.a("InstreamAd doesn't support multiple load");
            return;
        }
        di di2 = this.metricFactory.de();
        f.a(this.adConfig, this.metricFactory, this.loadingTimeoutSeconds).a(this::handleResult).a((co)((Object)di2), this.context);
    }

    public void configureMidpoints(float videoDuration) {
        this.configureMidpoints(videoDuration, null);
    }

    public void configureMidpoints(float videoDuration, @Nullable float[] midpoints) {
        cr<VideoData> cr2;
        if (videoDuration <= 0.0f) {
            ae.a("midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (this.midpoints != null) {
            ae.a("midpoints already configured");
            return;
        }
        this.userMidpoints = midpoints;
        this.videoDuration = videoDuration;
        if (this.section != null && (cr2 = this.section.v("midroll")) != null) {
            this.midpoints = ih.a(cr2, this.userMidpoints, videoDuration);
            if (this.engine != null) {
                this.engine.a(this.midpoints);
            }
        }
    }

    public void configureMidpointsPercents(float videoDuration, @Nullable float[] midpointsPercents) {
        if (midpointsPercents == null) {
            this.configureMidpoints(videoDuration);
            return;
        }
        this.configureMidpoints(videoDuration, ih.a(videoDuration, midpointsPercents));
    }

    public void useDefaultPlayer() {
        this.useDefaultPlayer(true);
    }

    public void useDefaultPlayer(boolean useExoPlayer) {
        fo fo2 = new fo(this.context);
        fo2.setUseExoPlayer(useExoPlayer);
        this.setPlayer(fo2);
    }

    public void pause() {
        if (this.engine != null) {
            this.engine.pause();
        }
    }

    public void resume() {
        if (this.engine != null) {
            this.engine.resume();
        }
    }

    public void stop() {
        if (this.engine != null) {
            this.engine.stop();
        }
    }

    public void skip() {
        if (this.engine != null) {
            this.engine.skip();
        }
    }

    public void skipBanner() {
        if (this.engine != null) {
            this.engine.skipBanner();
        }
    }

    public void handleClick() {
        if (this.engine != null) {
            this.engine.handleClick();
        }
    }

    public void destroy() {
        this.listener = null;
        if (this.engine != null) {
            this.engine.destroy();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    public void startMidroll(float point) {
        if (this.engine == null) {
            ae.a("Unable to start ad: not loaded yet");
            return;
        }
        if (this.engine.getPlayer() == null) {
            ae.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.startMidroll(point);
    }

    private void handleResult(@Nullable co result, @Nullable String error) {
        if (this.listener == null) {
            return;
        }
        if (result == null || !result.cj()) {
            this.listener.onNoAd(error == null ? "no ad" : error, this);
        } else {
            this.section = result;
            this.engine = at.a(this, this.section, this.adConfig, this.metricFactory);
            this.engine.f(this.loadingTimeoutSeconds);
            this.engine.setVolume(this.volume);
            if (this.player != null) {
                this.engine.setPlayer(this.player);
            }
            this.configureMidpoints(this.videoDuration, this.userMidpoints);
            this.listener.onLoad(this);
        }
    }

    private void start(@NonNull String sectionName) {
        if (this.engine == null) {
            ae.a("Unable to start ad: not loaded yet");
            return;
        }
        if (this.engine.getPlayer() == null) {
            ae.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.start(sectionName);
    }

    public static final class InstreamAdBanner {
        public final float duration;
        public final boolean allowClose;
        public final float allowCloseDelay;
        public final int videoWidth;
        public final int videoHeight;
        @Nullable
        public final String ctaText;
        @NonNull
        public final String id;
        public final boolean allowPause;

        @NonNull
        public static InstreamAdBanner newBanner(@NonNull cf mediaBanner) {
            return new InstreamAdBanner(mediaBanner.getId(), mediaBanner.isAllowClose(), mediaBanner.getAllowCloseDelay(), mediaBanner.getDuration(), mediaBanner.getWidth(), mediaBanner.getHeight(), mediaBanner.getCtaText(), mediaBanner.isAllowPause());
        }

        private InstreamAdBanner(@NonNull String id2, boolean allowClose, float allowCloseDelay, float duration, int width, int height, @Nullable String ctaText, boolean allowPause) {
            this.id = id2;
            this.allowClose = allowClose;
            this.allowCloseDelay = allowCloseDelay;
            this.duration = duration;
            this.videoHeight = height;
            this.videoWidth = width;
            this.ctaText = ctaText;
            this.allowPause = allowPause;
        }
    }

    public static interface InstreamAdListener {
        public void onLoad(@NonNull InstreamAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAd var2);

        public void onBannerStart(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerPause(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerResume(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAd var2);
    }
}

