/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.au;
import com.my.target.bz;
import com.my.target.cf;
import com.my.target.common.BaseAd;
import com.my.target.common.models.AudioData;
import com.my.target.common.models.ShareButtonData;
import com.my.target.cp;
import com.my.target.cr;
import com.my.target.di;
import com.my.target.i;
import com.my.target.ih;
import com.my.target.instreamads.InstreamAudioAdPlayer;
import java.util.ArrayList;
import java.util.List;

public final class InstreamAudioAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @Nullable
    private cp section;
    @Nullable
    private au engine;
    @Nullable
    private InstreamAudioAdPlayer player;
    @Nullable
    private InstreamAudioAdListener listener;
    private int loadingTimeoutSeconds = 10;
    private float volume = 1.0f;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float audioDuration;

    public InstreamAudioAd(int slotId, @NonNull Context context) {
        super(slotId, "instreamaudioads");
        this.context = context;
        ae.c("InstreamAudioAd created. Version: 5.14.4");
    }

    @Nullable
    public InstreamAudioAdListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable InstreamAudioAdListener listener) {
        this.listener = listener;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            ae.a("unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            ae.a("ad loading timeout set to " + loadingTimeout + " seconds");
            this.loadingTimeoutSeconds = loadingTimeout;
        }
        if (this.engine != null) {
            this.engine.f(this.loadingTimeoutSeconds);
        }
    }

    @Nullable
    public InstreamAudioAdPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable InstreamAudioAdPlayer player) {
        this.player = player;
        if (this.engine != null) {
            this.engine.setPlayer(player);
        }
    }

    public float getVolume() {
        if (this.engine != null) {
            return this.engine.getVolume();
        }
        return this.volume;
    }

    public void setVolume(float volume) {
        if (Float.compare(volume, 0.0f) < 0 || Float.compare(volume, 1.0f) > 0) {
            ae.a("unable to set volume" + volume + ", volume must be in range [0..1]");
            return;
        }
        this.volume = volume;
        if (this.engine != null) {
            this.engine.setVolume(volume);
        }
    }

    @NonNull
    public float[] getMidPoints() {
        if (this.midpoints == null) {
            return new float[0];
        }
        return (float[])this.midpoints.clone();
    }

    @Nullable
    public InstreamAudioAdBanner getCurrentBanner() {
        if (this.engine != null) {
            return this.engine.getCurrentBanner();
        }
        return null;
    }

    public void load() {
        if (this.isLoadCalled()) {
            ae.a("InstreamAudioAd doesn't support multiple load");
            return;
        }
        di di2 = this.metricFactory.de();
        i.a(this.adConfig, this.metricFactory, this.loadingTimeoutSeconds).a(this::handleResult).a((cp)((Object)di2), this.context);
    }

    public void configureMidpoints(float audioDuration) {
        this.configureMidpoints(audioDuration, null);
    }

    public void configureMidpoints(float audioDuration, @Nullable float[] midpoints) {
        cr<AudioData> cr2;
        if (audioDuration <= 0.0f) {
            ae.a("midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (this.midpoints != null) {
            ae.a("midpoints already configured");
            return;
        }
        this.userMidpoints = midpoints;
        this.audioDuration = audioDuration;
        if (this.section != null && (cr2 = this.section.w("midroll")) != null) {
            this.midpoints = ih.a(cr2, this.userMidpoints, audioDuration);
            if (this.engine != null) {
                this.engine.a(this.midpoints);
            }
        }
    }

    public void configureMidpointsPercents(float audioDuration, @Nullable float[] midpointsPercents) {
        if (midpointsPercents == null) {
            this.configureMidpoints(audioDuration);
            return;
        }
        this.configureMidpoints(audioDuration, ih.a(audioDuration, midpointsPercents));
    }

    public void pause() {
        if (this.engine != null) {
            this.engine.pause();
        }
    }

    public void resume() {
        if (this.engine != null) {
            this.engine.resume();
        }
    }

    public void stop() {
        if (this.engine != null) {
            this.engine.stop();
        }
    }

    public void skip() {
        if (this.engine != null) {
            this.engine.skip();
        }
    }

    public void skipBanner() {
        if (this.engine != null) {
            this.engine.skipBanner();
        }
    }

    public void destroy() {
        this.listener = null;
        if (this.engine != null) {
            this.engine.destroy();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    public void startMidroll(float point) {
        if (this.engine == null) {
            ae.a("Unable to start ad: not loaded yet");
            return;
        }
        if (this.engine.getPlayer() == null) {
            ae.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.startMidroll(point);
    }

    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        if (this.engine != null) {
            this.engine.handleCompanionClick(instreamAdCompanionBanner);
        }
    }

    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner, @NonNull Context context) {
        if (this.engine != null) {
            this.engine.handleCompanionClick(instreamAdCompanionBanner, context);
        }
    }

    public void handleCompanionShow(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        if (this.engine != null) {
            this.engine.handleCompanionShow(instreamAdCompanionBanner);
        }
    }

    private void handleResult(@Nullable cp result, @Nullable String error) {
        if (this.listener == null) {
            return;
        }
        if (result == null || !result.cj()) {
            this.listener.onNoAd(error == null ? "no ad" : error, this);
        } else {
            this.section = result;
            this.engine = au.a(this, this.section, this.adConfig, this.metricFactory);
            this.engine.f(this.loadingTimeoutSeconds);
            this.engine.setVolume(this.volume);
            if (this.player != null) {
                this.engine.setPlayer(this.player);
            }
            this.configureMidpoints(this.audioDuration, this.userMidpoints);
            this.listener.onLoad(this);
        }
    }

    private void start(@NonNull String sectionName) {
        if (this.engine == null) {
            ae.a("Unable to start ad: not loaded yet");
            return;
        }
        if (this.engine.getPlayer() == null) {
            ae.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.start(sectionName);
    }

    public static final class InstreamAudioAdBanner {
        public final float duration;
        public final boolean allowSeek;
        public final boolean allowPause;
        public final boolean allowSkip;
        public final boolean allowTrackChange;
        @Nullable
        public final String adText;
        @NonNull
        public final ArrayList<ShareButtonData> shareButtonDatas;
        @NonNull
        public final List<InstreamAdCompanionBanner> companionBanners;

        @NonNull
        public static InstreamAudioAdBanner newBanner(@NonNull cf<AudioData> mediaBanner) {
            ArrayList<InstreamAdCompanionBanner> arrayList = new ArrayList<InstreamAdCompanionBanner>();
            for (bz bz2 : mediaBanner.getCompanionBanners()) {
                arrayList.add(InstreamAdCompanionBanner.newBanner(bz2));
            }
            return new InstreamAudioAdBanner(mediaBanner.isAllowSeek(), mediaBanner.isAllowSkip(), mediaBanner.isAllowTrackChange(), mediaBanner.getDuration(), mediaBanner.getAdText(), mediaBanner.isAllowPause(), mediaBanner.getShareButtonDatas(), arrayList);
        }

        private InstreamAudioAdBanner(boolean allowSeek, boolean allowSkip, boolean allowTrackChange, float duration, @Nullable String adText, boolean allowPause, @NonNull ArrayList<ShareButtonData> shareButtonDatas, @NonNull List<InstreamAdCompanionBanner> companionBanners) {
            this.allowSeek = allowSeek;
            this.allowSkip = allowSkip;
            this.allowPause = allowPause;
            this.allowTrackChange = allowTrackChange;
            this.duration = duration;
            this.adText = adText;
            this.shareButtonDatas = shareButtonDatas;
            this.companionBanners = companionBanners;
        }
    }

    public static final class InstreamAdCompanionBanner {
        public final int width;
        public final int height;
        public final int assetWidth;
        public final int assetHeight;
        public final int expandedWidth;
        public final int expandedHeight;
        public final boolean isClickable;
        @Nullable
        public final String staticResource;
        @Nullable
        public final String iframeResource;
        @Nullable
        public final String htmlResource;
        @Nullable
        public final String apiFramework;
        @Nullable
        public final String adSlotID;
        @Nullable
        public final String required;

        @NonNull
        public static InstreamAdCompanionBanner newBanner(@NonNull bz companionBanner) {
            return new InstreamAdCompanionBanner(companionBanner.getWidth(), companionBanner.getHeight(), companionBanner.getAssetWidth(), companionBanner.getAssetHeight(), companionBanner.getExpandedWidth(), companionBanner.getExpandedHeight(), !TextUtils.isEmpty((CharSequence)companionBanner.getTrackingLink()), companionBanner.getStaticResource(), companionBanner.getIframeResource(), companionBanner.getHtmlResource(), companionBanner.getApiFramework(), companionBanner.getAdSlotID(), companionBanner.getRequired());
        }

        private InstreamAdCompanionBanner(int width, int height, int assetWidth, int assetHeight, int expandedWidth, int expandedHeight, boolean isClickable, @Nullable String staticResource, @Nullable String iframeResource, @Nullable String htmlResource, @Nullable String apiFramework, @Nullable String adSlotID, @Nullable String required) {
            this.width = width;
            this.height = height;
            this.assetWidth = assetWidth;
            this.assetHeight = assetHeight;
            this.expandedWidth = expandedWidth;
            this.expandedHeight = expandedHeight;
            this.isClickable = isClickable;
            this.staticResource = staticResource;
            this.iframeResource = iframeResource;
            this.htmlResource = htmlResource;
            this.apiFramework = apiFramework;
            this.adSlotID = adSlotID;
            this.required = required;
        }
    }

    public static interface InstreamAudioAdListener {
        public void onLoad(@NonNull InstreamAudioAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onBannerStart(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAudioAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAudioAd var2);
    }
}

