/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.mediation;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ads.InterstitialAd;
import com.my.target.ae;
import com.my.target.common.CustomParams;
import com.my.target.cq;
import com.my.target.mediation.MediationAdConfig;
import com.my.target.mediation.MediationInterstitialAdAdapter;
import java.util.Map;

public final class MyTargetInterstitialAdAdapter
implements MediationInterstitialAdAdapter {
    @Nullable
    private cq section;
    @Nullable
    private InterstitialAd ad;

    public void setSection(@Nullable cq section) {
        this.section = section;
    }

    @Override
    public void load(@NonNull MediationAdConfig mediationAdConfig, @NonNull MediationInterstitialAdAdapter.MediationInterstitialAdListener listener, @NonNull Context context) {
        int n2;
        String string = mediationAdConfig.getPlacementId();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            String string2 = "failed to request ad, unable to convert slotId " + string + " to int";
            ae.b("MyTargetInterstitialAdAdapter error: " + string2);
            listener.onNoAd(string2, this);
            return;
        }
        this.ad = new InterstitialAd(n2, context);
        this.ad.setMediationEnabled(false);
        this.ad.setListener(new AdListener(listener));
        CustomParams customParams = this.ad.getCustomParams();
        customParams.setAge(mediationAdConfig.getAge());
        customParams.setGender(mediationAdConfig.getGender());
        for (Map.Entry<String, String> entry : mediationAdConfig.getServerParams().entrySet()) {
            customParams.setCustomParam(entry.getKey(), entry.getValue());
        }
        String string3 = mediationAdConfig.getPayload();
        if (this.section != null) {
            ae.a("MyTargetInterstitialAdAdapter: got banner from mediation response");
            this.ad.handleSection(this.section);
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            ae.a("MyTargetInterstitialAdAdapter: load id " + n2);
            this.ad.load();
        } else {
            ae.a("MyTargetInterstitialAdAdapter: load id " + n2 + " from BID " + (String)string3);
            this.ad.loadFromBid(string3);
        }
    }

    @Override
    public void show(@NonNull Context context) {
        if (this.ad == null) {
            return;
        }
        this.ad.show();
    }

    @Override
    public void dismiss() {
        if (this.ad == null) {
            return;
        }
        this.ad.dismiss();
    }

    @Override
    public void destroy() {
        if (this.ad == null) {
            return;
        }
        this.ad.setListener(null);
        this.ad.destroy();
        this.ad = null;
    }

    class AdListener
    implements InterstitialAd.InterstitialAdListener {
        @NonNull
        private final MediationInterstitialAdAdapter.MediationInterstitialAdListener mediationListener;

        AdListener(MediationInterstitialAdAdapter.MediationInterstitialAdListener mediationListener) {
            this.mediationListener = mediationListener;
        }

        @Override
        public void onLoad(@NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: ad loaded");
            this.mediationListener.onLoad(MyTargetInterstitialAdAdapter.this);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: no ad (" + reason + ")");
            this.mediationListener.onNoAd(reason, MyTargetInterstitialAdAdapter.this);
        }

        @Override
        public void onClick(@NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: ad clicked");
            this.mediationListener.onClick(MyTargetInterstitialAdAdapter.this);
        }

        @Override
        public void onDismiss(@NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: ad dismissed");
            this.mediationListener.onDismiss(MyTargetInterstitialAdAdapter.this);
        }

        @Override
        public void onVideoCompleted(@NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: video completed");
            this.mediationListener.onVideoCompleted(MyTargetInterstitialAdAdapter.this);
        }

        @Override
        public void onDisplay(@NonNull InterstitialAd ad2) {
            ae.a("MyTargetInterstitialAdAdapter: ad displayed");
            this.mediationListener.onDisplay(MyTargetInterstitialAdAdapter.this);
        }
    }
}

