/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.mediation;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.common.CustomParams;
import com.my.target.cs;
import com.my.target.mediation.MediationNativeAdAdapter;
import com.my.target.mediation.MediationNativeAdConfig;
import com.my.target.nativeads.NativeAd;
import com.my.target.nativeads.banners.NativePromoBanner;
import java.util.List;
import java.util.Map;

public final class MyTargetNativeAdAdapter
implements MediationNativeAdAdapter {
    @Nullable
    private cs section;
    @Nullable
    private NativeAd ad;

    public void setSection(@Nullable cs section) {
        this.section = section;
    }

    @Override
    public void load(@NonNull MediationNativeAdConfig mediationAdConfig, @NonNull MediationNativeAdAdapter.MediationNativeAdListener listener, @NonNull Context context) {
        int n2;
        String string = mediationAdConfig.getPlacementId();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            String string2 = "failed to request ad, unable to convert slotId " + string + " to int";
            ae.b("MyTargetNativeAdAdapter error: " + string2);
            listener.onNoAd(string2, this);
            return;
        }
        this.ad = new NativeAd(n2, context);
        this.ad.setMediationEnabled(false);
        this.ad.setListener(new AdListener(listener));
        this.ad.setCachePolicy(mediationAdConfig.getCachePolicy());
        CustomParams customParams = this.ad.getCustomParams();
        customParams.setAge(mediationAdConfig.getAge());
        customParams.setGender(mediationAdConfig.getGender());
        for (Map.Entry<String, String> entry : mediationAdConfig.getServerParams().entrySet()) {
            customParams.setCustomParam(entry.getKey(), entry.getValue());
        }
        String string3 = mediationAdConfig.getPayload();
        if (this.section != null) {
            ae.a("MyTargetNativeAdAdapter: got banner from mediation response");
            this.ad.handleSection(this.section);
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            ae.a("MyTargetNativeAdAdapter: load id " + n2);
            this.ad.load();
        } else {
            ae.a("MyTargetNativeAdAdapter: load id " + n2 + " from BID " + (String)string3);
            this.ad.loadFromBid(string3);
        }
    }

    @Override
    public void registerView(@NonNull View view, @Nullable List<View> clickableViews, int adChoicesPlacement) {
        if (this.ad == null) {
            return;
        }
        this.ad.setAdChoicesPlacement(adChoicesPlacement);
        this.ad.registerView(view, clickableViews);
    }

    @Override
    public void unregisterView() {
        if (this.ad == null) {
            return;
        }
        this.ad.unregisterView();
    }

    @Override
    @Nullable
    public View getMediaView(@NonNull Context context) {
        return null;
    }

    @Override
    public void destroy() {
        if (this.ad == null) {
            return;
        }
        this.ad.unregisterView();
        this.ad.setListener(null);
        this.ad = null;
    }

    class AdListener
    implements NativeAd.NativeAdListener {
        @NonNull
        private final MediationNativeAdAdapter.MediationNativeAdListener mediationListener;

        AdListener(MediationNativeAdAdapter.MediationNativeAdListener mediationListener) {
            this.mediationListener = mediationListener;
        }

        @Override
        public void onLoad(@NonNull NativePromoBanner banner, @NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: ad loaded");
            this.mediationListener.onLoad(banner, MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: no ad (" + reason + ")");
            this.mediationListener.onNoAd(reason, MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onClick(@NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: ad clicked");
            this.mediationListener.onClick(MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onShow(@NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: ad shown");
            this.mediationListener.onShow(MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onVideoPlay(@NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: video playing");
            this.mediationListener.onVideoPlay(MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onVideoPause(@NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: video paused");
            this.mediationListener.onVideoPause(MyTargetNativeAdAdapter.this);
        }

        @Override
        public void onVideoComplete(@NonNull NativeAd ad2) {
            ae.a("MyTargetNativeAdAdapter: video completed");
            this.mediationListener.onVideoComplete(MyTargetNativeAdAdapter.this);
        }
    }
}

