/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.mediation;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.common.CustomParams;
import com.my.target.cs;
import com.my.target.mediation.MediationNativeBannerAdAdapter;
import com.my.target.mediation.MediationNativeBannerAdConfig;
import com.my.target.nativeads.NativeBannerAd;
import com.my.target.nativeads.banners.NativeBanner;
import java.util.List;
import java.util.Map;

public final class MyTargetNativeBannerAdAdapter
implements MediationNativeBannerAdAdapter {
    @Nullable
    private cs section;
    @Nullable
    private NativeBannerAd ad;

    public void setSection(@Nullable cs section) {
        this.section = section;
    }

    @Override
    public void load(@NonNull MediationNativeBannerAdConfig mediationAdConfig, @NonNull MediationNativeBannerAdAdapter.MediationNativeBannerAdListener listener, @NonNull Context context) {
        int n2;
        String string = mediationAdConfig.getPlacementId();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            String string2 = "failed to request ad, unable to convert slotId " + string + " to int";
            ae.b("MyTargetNativeBannerAdAdapter error: " + string2);
            listener.onNoAd(string2, this);
            return;
        }
        this.ad = new NativeBannerAd(n2, context);
        this.ad.setMediationEnabled(false);
        this.ad.setListener(new AdListener(listener));
        this.ad.setCachePolicy(mediationAdConfig.getCachePolicy());
        CustomParams customParams = this.ad.getCustomParams();
        customParams.setAge(mediationAdConfig.getAge());
        customParams.setGender(mediationAdConfig.getGender());
        for (Map.Entry<String, String> entry : mediationAdConfig.getServerParams().entrySet()) {
            customParams.setCustomParam(entry.getKey(), entry.getValue());
        }
        String string3 = mediationAdConfig.getPayload();
        if (this.section != null) {
            ae.a("MyTargetNativeBannerAdAdapter: got banner from mediation response");
            this.ad.handleSection(this.section);
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            ae.a("MyTargetNativeBannerAdAdapter: load id " + n2);
            this.ad.load();
        } else {
            ae.a("MyTargetNativeBannerAdAdapter: load id " + n2 + " from BID " + (String)string3);
            this.ad.loadFromBid(string3);
        }
    }

    @Override
    public void registerView(@NonNull View view, @Nullable List<View> clickableViews, int adChoicesPlacement) {
        if (this.ad == null) {
            return;
        }
        this.ad.setAdChoicesPlacement(adChoicesPlacement);
        this.ad.registerView(view, clickableViews);
    }

    @Override
    public void unregisterView() {
        if (this.ad == null) {
            return;
        }
        this.ad.unregisterView();
    }

    @Override
    @Nullable
    public View getIconView(@NonNull Context context) {
        return null;
    }

    @Override
    public void destroy() {
        if (this.ad == null) {
            return;
        }
        this.ad.unregisterView();
        this.ad.setListener(null);
        this.ad = null;
    }

    class AdListener
    implements NativeBannerAd.NativeBannerAdListener {
        @NonNull
        private final MediationNativeBannerAdAdapter.MediationNativeBannerAdListener mediationListener;

        AdListener(MediationNativeBannerAdAdapter.MediationNativeBannerAdListener mediationListener) {
            this.mediationListener = mediationListener;
        }

        @Override
        public void onLoad(@NonNull NativeBanner banner, @NonNull NativeBannerAd ad2) {
            ae.a("MyTargetNativeBannerAdAdapter: ad loaded");
            this.mediationListener.onLoad(banner, MyTargetNativeBannerAdAdapter.this);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull NativeBannerAd ad2) {
            ae.a("MyTargetNativeBannerAdAdapter: no ad (" + reason + ")");
            this.mediationListener.onNoAd(reason, MyTargetNativeBannerAdAdapter.this);
        }

        @Override
        public void onClick(@NonNull NativeBannerAd ad2) {
            ae.a("MyTargetNativeBannerAdAdapter: ad clicked");
            this.mediationListener.onClick(MyTargetNativeBannerAdAdapter.this);
        }

        @Override
        public void onShow(@NonNull NativeBannerAd ad2) {
            ae.a("MyTargetNativeBannerAdAdapter: ad shown");
            this.mediationListener.onShow(MyTargetNativeBannerAdAdapter.this);
        }
    }
}

