/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.mediation;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.ae;
import com.my.target.common.CustomParams;
import com.my.target.cq;
import com.my.target.mediation.MediationAdConfig;
import com.my.target.mediation.MediationRewardedAdAdapter;
import java.util.Map;

public final class MyTargetRewardedAdAdapter
implements MediationRewardedAdAdapter {
    @Nullable
    private cq section;
    @Nullable
    private RewardedAd ad;

    public void setSection(@Nullable cq section) {
        this.section = section;
    }

    @Override
    public void load(@NonNull MediationAdConfig mediationAdConfig, @NonNull MediationRewardedAdAdapter.MediationRewardedAdListener listener, @NonNull Context context) {
        int n2;
        String string = mediationAdConfig.getPlacementId();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            String string2 = "failed to request ad, unable to convert slotId " + string + " to int";
            ae.b("MyTargetRewardedAdAdapter error: " + string2);
            listener.onNoAd(string2, this);
            return;
        }
        this.ad = new RewardedAd(n2, context);
        this.ad.setMediationEnabled(false);
        this.ad.setListener(new AdListener(listener));
        CustomParams customParams = this.ad.getCustomParams();
        customParams.setAge(mediationAdConfig.getAge());
        customParams.setGender(mediationAdConfig.getGender());
        for (Map.Entry<String, String> entry : mediationAdConfig.getServerParams().entrySet()) {
            customParams.setCustomParam(entry.getKey(), entry.getValue());
        }
        String string3 = mediationAdConfig.getPayload();
        if (this.section != null) {
            ae.a("MyTargetRewardedAdAdapter: got banner from mediation response");
            this.ad.handleSection(this.section);
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            ae.a("MyTargetRewardedAdAdapter: load id " + n2);
            this.ad.load();
        } else {
            ae.a("MyTargetRewardedAdAdapter: load id " + n2 + " from BID " + (String)string3);
            this.ad.loadFromBid(string3);
        }
    }

    @Override
    public void show(@NonNull Context context) {
        if (this.ad == null) {
            return;
        }
        this.ad.show();
    }

    @Override
    public void dismiss() {
        if (this.ad == null) {
            return;
        }
        this.ad.dismiss();
    }

    @Override
    public void destroy() {
        if (this.ad == null) {
            return;
        }
        this.ad.setListener(null);
        this.ad.destroy();
        this.ad = null;
    }

    class AdListener
    implements RewardedAd.RewardedAdListener {
        @NonNull
        private final MediationRewardedAdAdapter.MediationRewardedAdListener mediationListener;

        AdListener(MediationRewardedAdAdapter.MediationRewardedAdListener mediationListener) {
            this.mediationListener = mediationListener;
        }

        @Override
        public void onLoad(@NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: ad loaded");
            this.mediationListener.onLoad(MyTargetRewardedAdAdapter.this);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: no ad (" + reason + ")");
            this.mediationListener.onNoAd(reason, MyTargetRewardedAdAdapter.this);
        }

        @Override
        public void onClick(@NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: ad clicked");
            this.mediationListener.onClick(MyTargetRewardedAdAdapter.this);
        }

        @Override
        public void onDismiss(@NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: ad dismissed");
            this.mediationListener.onDismiss(MyTargetRewardedAdAdapter.this);
        }

        @Override
        public void onReward(@NonNull Reward reward, @NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: onReward: " + reward.type);
            this.mediationListener.onReward(reward, MyTargetRewardedAdAdapter.this);
        }

        @Override
        public void onDisplay(@NonNull RewardedAd ad2) {
            ae.a("MyTargetRewardedAdAdapter: ad displayed");
            this.mediationListener.onDisplay(MyTargetRewardedAdAdapter.this);
        }
    }
}

