/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.mediation;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ads.MyTargetView;
import com.my.target.ae;
import com.my.target.common.CustomParams;
import com.my.target.cu;
import com.my.target.mediation.MediationAdConfig;
import com.my.target.mediation.MediationStandardAdAdapter;
import java.util.Map;

public final class MyTargetStandardAdAdapter
implements MediationStandardAdAdapter {
    @Nullable
    private cu section;
    @Nullable
    private MyTargetView myTargetView;

    public void setSection(@Nullable cu section) {
        this.section = section;
    }

    @Override
    public void load(@NonNull MediationAdConfig mediationAdConfig, @NonNull MyTargetView.AdSize adSize, @NonNull MediationStandardAdAdapter.MediationStandardAdListener listener, @NonNull Context context) {
        int n2;
        String string = mediationAdConfig.getPlacementId();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            String string2 = "failed to request ad, unable to convert slotId " + string + " to int";
            ae.b("MyTargetStandardAdAdapter error: " + string2);
            listener.onNoAd(string2, this);
            return;
        }
        this.myTargetView = new MyTargetView(context);
        this.myTargetView.setSlotId(n2);
        this.myTargetView.setAdSize(adSize);
        this.myTargetView.setRefreshAd(false);
        this.myTargetView.setMediationEnabled(false);
        this.myTargetView.setListener(new AdListener(listener));
        CustomParams customParams = this.myTargetView.getCustomParams();
        customParams.setAge(mediationAdConfig.getAge());
        customParams.setGender(mediationAdConfig.getGender());
        for (Map.Entry<String, String> entry : mediationAdConfig.getServerParams().entrySet()) {
            customParams.setCustomParam(entry.getKey(), entry.getValue());
        }
        String string3 = mediationAdConfig.getPayload();
        if (this.section != null) {
            ae.a("MyTargetStandardAdAdapter: got banner from mediation response");
            this.myTargetView.handleSection(this.section, adSize);
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            ae.a("MyTargetStandardAdAdapter: load id " + n2);
            this.myTargetView.load();
        } else {
            ae.a("MyTargetStandardAdAdapter: load id " + n2 + " from BID " + (String)string3);
            this.myTargetView.loadFromBid(string3);
        }
    }

    @Override
    public void destroy() {
        if (this.myTargetView == null) {
            return;
        }
        this.myTargetView.setListener(null);
        this.myTargetView.destroy();
        this.myTargetView = null;
    }

    class AdListener
    implements MyTargetView.MyTargetViewListener {
        @NonNull
        private final MediationStandardAdAdapter.MediationStandardAdListener mediationListener;

        AdListener(MediationStandardAdAdapter.MediationStandardAdListener mediationListener) {
            this.mediationListener = mediationListener;
        }

        @Override
        public void onLoad(@NonNull MyTargetView myTargetView) {
            ae.a("MyTargetStandardAdAdapter: ad loaded");
            this.mediationListener.onLoad((View)myTargetView, MyTargetStandardAdAdapter.this);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            ae.a("MyTargetStandardAdAdapter: no ad (" + reason + ")");
            this.mediationListener.onNoAd(reason, MyTargetStandardAdAdapter.this);
        }

        @Override
        public void onShow(@NonNull MyTargetView myTargetView) {
            ae.a("MyTargetStandardAdAdapter: ad shown");
            this.mediationListener.onShow(MyTargetStandardAdAdapter.this);
        }

        @Override
        public void onClick(@NonNull MyTargetView myTargetView) {
            ae.a("MyTargetStandardAdAdapter: ad clicked");
            this.mediationListener.onClick(MyTargetStandardAdAdapter.this);
        }
    }
}

