/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads;

import android.content.Context;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ae;
import com.my.target.bg;
import com.my.target.cj;
import com.my.target.common.BaseAd;
import com.my.target.common.models.ImageData;
import com.my.target.ct;
import com.my.target.cy;
import com.my.target.cz;
import com.my.target.di;
import com.my.target.ia;
import com.my.target.ie;
import com.my.target.im;
import com.my.target.ir;
import com.my.target.nativeads.banners.NativeAppwallBanner;
import com.my.target.nativeads.views.AppwallAdView;
import com.my.target.w;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class NativeAppwallAd
extends BaseAd {
    private static final String DEFAULT_TITLE = "Apps";
    private static final int DEFAULT_TITLE_BACKGROUND_COLOR = -12232093;
    private static final int DEFAULT_TITLE_SUPPLEMENTARY_COLOR = -13220531;
    private static final int DEFAULT_TITLE_TEXT_COLOR = -1;
    @NonNull
    private final Context context;
    @NonNull
    private final ia clickHandler = ia.fg();
    @NonNull
    private final HashMap<NativeAppwallBanner, cj> bannersMap = new HashMap();
    @NonNull
    private final ArrayList<NativeAppwallBanner> banners = new ArrayList();
    @Nullable
    private AppwallAdListener listener;
    @Nullable
    private ct section;
    @Nullable
    private bg engine;
    @Nullable
    private WeakReference<AppwallAdView> viewWeakReference;
    @NonNull
    private String title = "Apps";
    private int titleBackgroundColor = -12232093;
    private int titleSupplementaryColor = -13220531;
    private int titleTextColor = -1;
    private boolean hideStatusBarInDialog = false;

    public static void loadImageToView(@NonNull ImageData imageData, @NonNull ImageView view) {
        ie.a(imageData, view);
    }

    public NativeAppwallAd(int slotId, @NonNull Context context) {
        super(slotId, "appwall");
        this.context = context;
        this.adConfig.setCachePolicy(0);
        ae.c("NativeAppwallAd created. Version: 5.14.4");
    }

    @Nullable
    public AppwallAdListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable AppwallAdListener listener) {
        this.listener = listener;
    }

    public boolean isHideStatusBarInDialog() {
        return this.hideStatusBarInDialog;
    }

    public void setHideStatusBarInDialog(boolean hideStatusBarInDialog) {
        this.hideStatusBarInDialog = hideStatusBarInDialog;
    }

    public void setAutoLoadImages(boolean autoLoadImages) {
        this.adConfig.setCachePolicy(0);
    }

    public boolean isAutoLoadImages() {
        int n2 = this.adConfig.getCachePolicy();
        return n2 == 0 || n2 == 1;
    }

    public long getCachePeriod() {
        return this.adConfig.getCachePeriod();
    }

    public void setCachePeriod(long cachePeriod) {
        this.adConfig.setCachePeriod(cachePeriod);
    }

    @NonNull
    public ArrayList<NativeAppwallBanner> getBanners() {
        return this.banners;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@NonNull String title) {
        this.title = title;
    }

    public int getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleBackgroundColor(int titleBackgroundColor) {
        this.titleBackgroundColor = titleBackgroundColor;
    }

    public int getTitleSupplementaryColor() {
        return this.titleSupplementaryColor;
    }

    public void setTitleSupplementaryColor(int titleSupplementaryColor) {
        this.titleSupplementaryColor = titleSupplementaryColor;
    }

    public int getTitleTextColor() {
        return this.titleTextColor;
    }

    public void setTitleTextColor(int titleTextColor) {
        this.titleTextColor = titleTextColor;
    }

    public void load() {
        if (this.isLoadCalled()) {
            ae.a("Appwall ad doesn't support multiple load");
            return;
        }
        di di2 = this.metricFactory.de();
        w.a(this.adConfig, this.metricFactory).a(this::handleResult).a((ct)((Object)di2), this.context);
    }

    public boolean hasNotifications() {
        for (NativeAppwallBanner nativeAppwallBanner : this.bannersMap.keySet()) {
            if (!nativeAppwallBanner.isHasNotification()) continue;
            return true;
        }
        return false;
    }

    public void registerAppwallAdView(@NonNull AppwallAdView view) {
        this.unregisterAppwallAdView();
        this.viewWeakReference = new WeakReference<AppwallAdView>(view);
        view.setAppwallAdViewListener(new AppwallAdView.AppwallAdViewListener(){

            @Override
            public void onBannersShow(@NonNull List<NativeAppwallBanner> banners) {
                NativeAppwallAd.this.handleBannersShow(banners);
            }

            @Override
            public void onBannerClick(@NonNull NativeAppwallBanner banner) {
                AppwallAdView appwallAdView;
                NativeAppwallAd.this.handleBannerClick(banner);
                if (NativeAppwallAd.this.viewWeakReference != null && (appwallAdView = (AppwallAdView)((Object)NativeAppwallAd.this.viewWeakReference.get())) != null) {
                    appwallAdView.notifyDataSetChanged();
                }
            }
        });
    }

    public void unregisterAppwallAdView() {
        if (this.viewWeakReference != null) {
            AppwallAdView appwallAdView = (AppwallAdView)((Object)this.viewWeakReference.get());
            if (appwallAdView != null) {
                appwallAdView.setAppwallAdViewListener(null);
            }
            this.viewWeakReference.clear();
            this.viewWeakReference = null;
        }
    }

    public void show() {
        if (this.section != null && this.banners.size() > 0) {
            if (this.engine == null) {
                this.engine = bg.a(this);
            }
            this.engine.f(this.context);
        } else {
            ae.c("NativeAppwallAd.show: No ad");
        }
    }

    public void dismiss() {
        if (this.engine != null) {
            this.engine.dismiss();
        }
    }

    public void destroy() {
        this.unregisterAppwallAdView();
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
        }
        this.listener = null;
    }

    public void handleBannerClick(NativeAppwallBanner banner) {
        cj cj2 = this.bannersMap.get(banner);
        if (cj2 != null) {
            this.clickHandler.b(cj2, this.context);
            if (this.section != null) {
                banner.setHasNotification(false);
                im.a(this.section, this.adConfig).a(cj2, false, this.context);
            }
            if (this.listener != null) {
                this.listener.onClick(banner, this);
            }
        } else {
            ae.a("unable to handle banner click: no internal banner for id " + banner.getId());
        }
    }

    @Nullable
    public String prepareBannerClickLink(NativeAppwallBanner banner) {
        cj cj2 = this.bannersMap.get(banner);
        if (cj2 != null) {
            cz cz2 = cj2.getStatHolder();
            ir.a(cz2.I("click"), this.context);
            if (this.section != null) {
                im.a(this.section, this.adConfig).a(cj2, false, this.context);
            }
            return cj2.getTrackingLink();
        }
        ae.a("unable to handle banner click: no internal banner for id " + banner.getId());
        return null;
    }

    public void handleBannersShow(@NonNull List<NativeAppwallBanner> banners) {
        ArrayList<cy> arrayList = new ArrayList<cy>();
        for (NativeAppwallBanner nativeAppwallBanner : banners) {
            cj cj2 = this.bannersMap.get(nativeAppwallBanner);
            if (cj2 != null) {
                ae.a("Ad shown, banner Id = " + nativeAppwallBanner.getId());
                cz cz2 = cj2.getStatHolder();
                arrayList.addAll(cz2.I("playbackStarted"));
                continue;
            }
            ae.a("unable to handle banner show: no internal banner for id " + nativeAppwallBanner.getId());
        }
        if (arrayList.size() > 0) {
            ir.a(arrayList, this.context);
        }
    }

    public void handleBannerShow(@NonNull NativeAppwallBanner banner) {
        cj cj2 = this.bannersMap.get(banner);
        if (cj2 != null) {
            cz cz2 = cj2.getStatHolder();
            ir.a(cz2.I("playbackStarted"), this.context);
        } else {
            ae.a("unable to handle banner show: no internal banner for id " + banner.getId());
        }
    }

    private void handleResult(@Nullable ct result, @Nullable String error) {
        if (this.listener == null) {
            return;
        }
        if (result == null) {
            this.listener.onNoAd(error == null ? "no ad" : error, this);
        } else {
            this.section = result;
            for (cj cj2 : result.cq()) {
                NativeAppwallBanner nativeAppwallBanner = NativeAppwallBanner.newBanner(cj2);
                this.banners.add(nativeAppwallBanner);
                this.bannersMap.put(nativeAppwallBanner, cj2);
            }
            this.listener.onLoad(this);
        }
    }

    public static interface AppwallAdListener {
        public void onLoad(@NonNull NativeAppwallAd var1);

        public void onNoAd(@NonNull String var1, @NonNull NativeAppwallAd var2);

        public void onClick(@NonNull NativeAppwallBanner var1, @NonNull NativeAppwallAd var2);

        public void onDisplay(@NonNull NativeAppwallAd var1);

        public void onDismiss(@NonNull NativeAppwallAd var1);
    }
}

