/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.banners;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.cg;
import com.my.target.common.models.ImageData;

public class NativeBanner {
    @NonNull
    private String navigationType = "web";
    private float rating;
    private int votes;
    @Nullable
    private String title;
    @Nullable
    private String ctaText;
    @Nullable
    private String description;
    @Nullable
    private String disclaimer;
    @Nullable
    private String ageRestrictions;
    @Nullable
    private String domain;
    @Nullable
    private String advertisingLabel;
    @Nullable
    private ImageData icon;

    @NonNull
    public static NativeBanner newBanner(@NonNull cg nativeAdBanner) {
        return new NativeBanner(nativeAdBanner);
    }

    NativeBanner(@NonNull cg nativeAdBanner) {
        this.navigationType = nativeAdBanner.getNavigationType();
        this.rating = nativeAdBanner.getRating();
        this.votes = nativeAdBanner.getVotes();
        String string = nativeAdBanner.getTitle();
        this.title = !TextUtils.isEmpty((CharSequence)string) ? string : null;
        String string2 = nativeAdBanner.getCtaText();
        this.ctaText = !TextUtils.isEmpty((CharSequence)string2) ? string2 : null;
        String string3 = nativeAdBanner.getDescription();
        this.description = !TextUtils.isEmpty((CharSequence)string3) ? string3 : null;
        String string4 = nativeAdBanner.getDisclaimer();
        this.disclaimer = !TextUtils.isEmpty((CharSequence)string4) ? string4 : null;
        String string5 = nativeAdBanner.getAgeRestrictions();
        this.ageRestrictions = !TextUtils.isEmpty((CharSequence)string5) ? string5 : null;
        String string6 = nativeAdBanner.getDomain();
        this.domain = !TextUtils.isEmpty((CharSequence)string6) ? string6 : null;
        String string7 = nativeAdBanner.getAdvertisingLabel();
        this.advertisingLabel = !TextUtils.isEmpty((CharSequence)string7) ? string7 : null;
        this.icon = nativeAdBanner.getIcon();
    }

    NativeBanner(@Nullable String title, @Nullable String ctaText, @Nullable String description, @Nullable String domain, @Nullable String advertisingLabel, @Nullable ImageData icon, float rating, @Nullable String ageRestrictions, @Nullable String disclaimer, int votes, @NonNull String navigationType) {
        this.title = title;
        this.ctaText = ctaText;
        this.description = description;
        this.domain = domain;
        this.advertisingLabel = advertisingLabel;
        this.icon = icon;
        this.rating = rating;
        this.ageRestrictions = ageRestrictions;
        this.disclaimer = disclaimer;
        this.votes = votes;
        this.navigationType = navigationType;
    }

    NativeBanner() {
    }

    @Nullable
    public ImageData getIcon() {
        return this.icon;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getCtaText() {
        return this.ctaText;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDisclaimer() {
        return this.disclaimer;
    }

    @Nullable
    public String getAgeRestrictions() {
        return this.ageRestrictions;
    }

    public float getRating() {
        return this.rating;
    }

    public int getVotes() {
        return this.votes;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @NonNull
    public String getNavigationType() {
        return this.navigationType;
    }

    @Nullable
    public String getAdvertisingLabel() {
        return this.advertisingLabel;
    }

    public static final class Builder {
        @NonNull
        protected final NativeBanner banner = new NativeBanner();

        @NonNull
        public static Builder createBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        @NonNull
        public Builder setTitle(String title) {
            this.banner.title = title;
            return this;
        }

        @NonNull
        public Builder setCtaText(@Nullable String ctaText) {
            this.banner.ctaText = ctaText;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String ctaText) {
            this.banner.description = ctaText;
            return this;
        }

        @NonNull
        public Builder setDomain(@Nullable String domain) {
            this.banner.domain = domain;
            return this;
        }

        @NonNull
        public Builder setAdvertisingLabel(@Nullable String advertisingLabel) {
            this.banner.advertisingLabel = advertisingLabel;
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable ImageData icon) {
            this.banner.icon = icon;
            return this;
        }

        @NonNull
        public Builder setRating(float rating) {
            this.banner.rating = rating;
            return this;
        }

        @NonNull
        public Builder setAgeRestrictions(@Nullable String ageRestrictions) {
            this.banner.ageRestrictions = ageRestrictions;
            return this;
        }

        @NonNull
        public Builder setDisclaimer(@Nullable String disclaimer) {
            this.banner.disclaimer = disclaimer;
            return this;
        }

        @NonNull
        public Builder setVotes(int votes) {
            this.banner.votes = votes;
            return this;
        }

        @NonNull
        public Builder setNavigationType(@NonNull String navigationType) {
            if ("web".equals(navigationType) || "store".equals(navigationType)) {
                this.banner.navigationType = navigationType;
            }
            return this;
        }

        public NativeBanner build() {
            return this.banner;
        }
    }
}

