/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.banners;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.cg;
import com.my.target.ch;
import com.my.target.common.models.ImageData;
import com.my.target.nativeads.banners.NativeBanner;
import com.my.target.nativeads.banners.NativePromoCard;
import java.util.ArrayList;
import java.util.List;

public class NativePromoBanner
extends NativeBanner {
    private boolean hasVideo;
    @Nullable
    private String category;
    @Nullable
    private String subCategory;
    @Nullable
    private ImageData image;
    @NonNull
    private ArrayList<NativePromoCard> nativePromoCards = new ArrayList();

    @NonNull
    public static NativePromoBanner newBanner(@NonNull cg nativeAdBanner) {
        return new NativePromoBanner(nativeAdBanner);
    }

    private NativePromoBanner(@NonNull cg nativeAdBanner) {
        super(nativeAdBanner);
        this.hasVideo = nativeAdBanner.getVideoBanner() != null;
        String string = nativeAdBanner.getCategory();
        this.category = !TextUtils.isEmpty((CharSequence)string) ? string : null;
        String string2 = nativeAdBanner.getSubCategory();
        this.subCategory = !TextUtils.isEmpty((CharSequence)string2) ? string2 : null;
        this.image = nativeAdBanner.getImage();
        this.processCards(nativeAdBanner);
    }

    private NativePromoBanner(@Nullable String title, @Nullable String ctaText, @Nullable String domain, @Nullable String advertisingLabel, @Nullable ImageData icon, float rating, @Nullable String ageRestrictions, @Nullable String disclaimer, int votes, @NonNull String navigationType, boolean hasVideo, @Nullable String description, @Nullable ImageData image) {
        super(title, ctaText, description, domain, advertisingLabel, icon, rating, ageRestrictions, disclaimer, votes, navigationType);
        this.hasVideo = hasVideo;
        this.image = image;
    }

    private void processCards(@NonNull cg nativeAdBanner) {
        List<ch> list;
        if (!this.hasVideo && !(list = nativeAdBanner.getNativeAdCards()).isEmpty()) {
            for (ch ch2 : list) {
                this.nativePromoCards.add(NativePromoCard.newCard(ch2));
            }
        }
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Nullable
    public String getSubCategory() {
        return this.subCategory;
    }

    @Nullable
    public ImageData getImage() {
        return this.image;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    @NonNull
    public ArrayList<NativePromoCard> getCards() {
        return this.nativePromoCards;
    }

    public static final class Builder {
        @NonNull
        private String navigationType = "web";
        @Nullable
        private String title;
        @Nullable
        private String ctaText;
        @Nullable
        private String domain;
        @Nullable
        private String advertisingLabel;
        @Nullable
        private ImageData icon;
        @Nullable
        private String ageRestrictions;
        @Nullable
        private String disclaimer;
        @Nullable
        private String description;
        @Nullable
        private ImageData image;
        private float rating;
        private int votes;
        private boolean hasVideo;

        @NonNull
        public static Builder createBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        @NonNull
        public Builder setHasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @NonNull
        public Builder setImage(@Nullable ImageData image) {
            this.image = image;
            return this;
        }

        @NonNull
        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        @NonNull
        public Builder setCtaText(@Nullable String ctaText) {
            this.ctaText = ctaText;
            return this;
        }

        @NonNull
        public Builder setDomain(@Nullable String domain) {
            this.domain = domain;
            return this;
        }

        @NonNull
        public Builder setAdvertisingLabel(@Nullable String advertisingLabel) {
            this.advertisingLabel = advertisingLabel;
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable ImageData icon) {
            this.icon = icon;
            return this;
        }

        @NonNull
        public Builder setRating(float rating) {
            this.rating = rating;
            return this;
        }

        @NonNull
        public Builder setAgeRestrictions(@Nullable String ageRestrictions) {
            this.ageRestrictions = ageRestrictions;
            return this;
        }

        @NonNull
        public Builder setDisclaimer(@Nullable String disclaimer) {
            this.disclaimer = disclaimer;
            return this;
        }

        @NonNull
        public Builder setVotes(int votes) {
            this.votes = votes;
            return this;
        }

        @NonNull
        public Builder setNavigationType(@NonNull String navigationType) {
            if ("web".equals(navigationType) || "store".equals(navigationType)) {
                this.navigationType = navigationType;
            }
            return this;
        }

        @NonNull
        public NativePromoBanner build() {
            return new NativePromoBanner(this.title, this.ctaText, this.domain, this.advertisingLabel, this.icon, this.rating, this.ageRestrictions, this.disclaimer, this.votes, this.navigationType, this.hasVideo, this.description, this.image);
        }
    }
}

