/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.StateSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.is;
import com.my.target.nativeads.NativeAppwallAd;
import com.my.target.nativeads.banners.NativeAppwallBanner;
import com.my.target.nativeads.views.AppwallAdTeaserView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AppwallAdView
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener,
AbsListView.OnScrollListener,
AdapterView.OnItemClickListener {
    private static final int BACKGROUND_COLOR = -1118482;
    @NonNull
    private final ListView listView;
    @NonNull
    private final is uiUtils;
    @NonNull
    private final HashMap<NativeAppwallBanner, Boolean> viewMap = new HashMap();
    @Nullable
    private AppwallAdViewListener appwallAdViewListener;

    public AppwallAdView(@NonNull Context context) {
        super(context);
        this.setVerticalFadingEdgeEnabled(false);
        this.setBackgroundColor(-1);
        this.uiUtils = is.ab(context);
        this.listView = new ListView(context);
        this.initLayout();
    }

    public void setAppwallAdViewListener(@Nullable AppwallAdViewListener listener) {
        this.appwallAdViewListener = listener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.countVisibleBanners();
    }

    public void setupView(@NonNull NativeAppwallAd appwalAd) {
        this.listView.setAdapter((ListAdapter)new AppwallAdapter(this.getContext(), appwalAd.getBanners()));
    }

    public void notifyDataSetChanged() {
        ((AppwallAdapter)this.listView.getAdapter()).notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        NativeAppwallBanner nativeAppwallBanner = (NativeAppwallBanner)this.listView.getAdapter().getItem(position);
        if (this.appwallAdViewListener != null) {
            this.appwallAdViewListener.onBannerClick(nativeAppwallBanner);
        }
    }

    public void onGlobalLayout() {
        this.countVisibleBanners();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.countVisibleBanners();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    private void initLayout() {
        int n2 = this.uiUtils.U(4);
        int n3 = this.uiUtils.U(4);
        this.listView.setDividerHeight(0);
        this.listView.setVerticalFadingEdgeEnabled(false);
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.listView.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.listView.setPadding(0, n2, 0, n3);
        this.listView.setClipToPadding(false);
        this.addView((View)this.listView, -1, -1);
        this.listView.setBackgroundColor(-1118482);
    }

    private void countVisibleBanners() {
        if (this.listView.getAdapter() == null) {
            return;
        }
        int n2 = this.listView.getFirstVisiblePosition();
        int n3 = this.listView.getLastVisiblePosition();
        ArrayList<NativeAppwallBanner> arrayList = new ArrayList<NativeAppwallBanner>();
        for (int i2 = n2; i2 <= n3; ++i2) {
            NativeAppwallBanner nativeAppwallBanner = (NativeAppwallBanner)this.listView.getAdapter().getItem(i2);
            if (this.viewMap.get(nativeAppwallBanner) != null) continue;
            arrayList.add(nativeAppwallBanner);
            this.viewMap.put(nativeAppwallBanner, true);
        }
        if (arrayList.size() > 0 && this.appwallAdViewListener != null) {
            this.appwallAdViewListener.onBannersShow(arrayList);
        }
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class AppwallCardPlaceholder
    extends FrameLayout {
        @NonNull
        private final AppwallAdTeaserView view;
        @NonNull
        private final LinearLayout rootLayout;

        public AppwallCardPlaceholder(@NonNull AppwallAdTeaserView view, Context context) {
            super(context);
            is is2 = is.ab(context);
            this.view = view;
            int n2 = is2.U(9);
            int n3 = is2.U(4);
            int n4 = is2.U(2);
            this.rootLayout = new LinearLayout(context);
            this.rootLayout.setOrientation(1);
            this.rootLayout.setBackgroundColor(-1118482);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(n2, n3, n2, n3);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.rootLayout.addView((View)view);
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(n4);
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                GradientDrawable gradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1118482, -1118482});
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable2);
                stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)gradientDrawable);
                view.setBackground((Drawable)stateListDrawable);
            } else {
                View view2 = new View(context);
                LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, n3);
                int[] nArray = new int[]{-3355444, -1118482};
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, nArray);
                view2.setBackgroundDrawable((Drawable)gradientDrawable);
                view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                this.rootLayout.addView(view2);
                GradientDrawable gradientDrawable3 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                gradientDrawable3.setStroke(1, -3355444);
                GradientDrawable gradientDrawable4 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1118482, -1118482});
                gradientDrawable4.setStroke(1, -3355444);
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable4);
                stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)gradientDrawable3);
                view.setBackgroundDrawable((Drawable)stateListDrawable);
                layoutParams.setMargins(0, n3, 0, 0);
                this.rootLayout.setPadding(n2, 0, n2, 0);
            }
            this.addView((View)this.rootLayout, -2, -2);
        }

        @NonNull
        public AppwallAdTeaserView getView() {
            return this.view;
        }
    }

    public static class AppwallAdapter
    extends ArrayAdapter<NativeAppwallBanner> {
        AppwallAdapter(@NonNull Context context, @NonNull List<NativeAppwallBanner> banners) {
            super(context, 0, banners);
        }

        @NonNull
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            NativeAppwallBanner nativeAppwallBanner = (NativeAppwallBanner)this.getItem(position);
            if (convertView == null) {
                AppwallAdTeaserView appwallAdTeaserView = new AppwallAdTeaserView(this.getContext());
                convertView = new AppwallCardPlaceholder(appwallAdTeaserView, this.getContext());
            }
            if (nativeAppwallBanner != null) {
                ((AppwallCardPlaceholder)((Object)convertView)).getView().setNativeAppwallBanner(nativeAppwallBanner);
            }
            return convertView;
        }
    }

    public static interface AppwallAdViewListener {
        public void onBannersShow(@NonNull List<NativeAppwallBanner> var1);

        public void onBannerClick(@NonNull NativeAppwallBanner var1);
    }
}

