/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.gf;
import com.my.target.is;

public class IconAdView
extends FrameLayout {
    @NonNull
    private final gf imageView;
    private int placeholderWidth;
    private int placeholderHeight;

    public void setPlaceHolderDimension(int placeholderWidth, int placeholderHeight) {
        this.placeholderWidth = placeholderWidth;
        this.placeholderHeight = placeholderHeight;
        this.imageView.setPlaceholderDimensions(placeholderWidth, placeholderHeight);
    }

    public IconAdView(@NonNull Context context) {
        this(context, null);
    }

    public IconAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.imageView = new gf(context);
        is.a((View)this.imageView, "nativeads_icon");
        this.addView((View)this.imageView);
    }

    @NonNull
    public ImageView getImageView() {
        return this.imageView;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.placeholderWidth == 0 || this.placeholderHeight == 0) {
            this.measureBasedOnIconImage(widthMeasureSpec, heightMeasureSpec);
        } else {
            float f2 = (float)this.placeholderWidth / (float)this.placeholderHeight;
            this.measureBasedOnRatio(widthMeasureSpec, heightMeasureSpec, f2);
        }
    }

    protected void onLayout(boolean changed, int l2, int t2, int r, int b2) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            if (n2 == 0 || n3 == 0) continue;
            int n4 = (r - l2 - n2) / 2;
            int n5 = (b2 - t2 - n3) / 2;
            int n6 = n4 + n2;
            int n7 = n5 + n3;
            view.layout(n4, n5, n6, n7);
        }
    }

    private void measureBasedOnIconImage(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int n6 = this.getChildCount();
        if (n2 == 0 && n3 == 0) {
            this.setMeasuredDimension(0, 0);
        }
        this.imageView.measure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n3, (int)Integer.MIN_VALUE));
        int n7 = this.imageView.getMeasuredWidth();
        int n8 = this.imageView.getMeasuredHeight();
        if (n5 != 0x40000000) {
            n3 = n8;
        }
        if (n4 != 0x40000000) {
            n2 = n7;
        }
        if (n6 > 1) {
            for (int i2 = 1; i2 < n6; ++i2) {
                this.getChildAt(i2).measure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n3, (int)Integer.MIN_VALUE));
            }
        }
        this.setMeasuredDimension(n2, n3);
    }

    @SuppressLint(value={"WrongCall"})
    private void measureBasedOnRatio(int widthMeasureSpec, int heightMeasureSpec, float mediaViewSizeRatio) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int n6 = this.getChildCount();
        if (n4 == 0 && n5 == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (n4 == 0) {
            n2 = (int)((float)n3 * mediaViewSizeRatio);
        } else if (n5 == 0) {
            n3 = (int)((float)n2 / mediaViewSizeRatio);
        } else if (n5 != 0x40000000) {
            n3 = (int)((float)n2 / mediaViewSizeRatio);
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < n6; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            int n7 = Integer.MIN_VALUE;
            int n8 = Integer.MIN_VALUE;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams != null) {
                if (layoutParams.width == -1) {
                    n7 = 0x40000000;
                }
                if (layoutParams.height == -1) {
                    n8 = 0x40000000;
                }
            }
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n2, (int)n7);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n3, (int)n8);
            view.measure(widthMeasureSpec, heightMeasureSpec);
            if (view.getMeasuredHeight() <= 0) continue;
            bl2 = true;
        }
        if (bl2) {
            this.setMeasuredDimension(n2, n3);
        } else {
            this.setMeasuredDimension(0, 0);
        }
    }
}

