/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.fm;
import com.my.target.ga;
import com.my.target.gf;
import com.my.target.is;

public class MediaAdView
extends FrameLayout {
    public static final int COLOR_PLACEHOLDER_GRAY = -1118482;
    @NonNull
    private final gf imageView;
    @NonNull
    private final ProgressBar progressBar;
    @NonNull
    private final ga playButton;
    private int placeholderWidth;
    private int placeholderHeight;
    private float mediaAspectRatio;

    public MediaAdView(@NonNull Context context) {
        super(context);
        this.imageView = new gf(context);
        this.playButton = new ga(context);
        this.progressBar = new ProgressBar(context, null, 0x1010077);
        this.initViews(context);
    }

    public MediaAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.imageView = new gf(context);
        this.playButton = new ga(context);
        this.progressBar = new ProgressBar(context, null, 0x1010077);
        this.initViews(context);
    }

    public MediaAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.imageView = new gf(context);
        this.playButton = new ga(context);
        this.progressBar = new ProgressBar(context, null, 0x1010077);
        this.initViews(context);
    }

    @NonNull
    public ProgressBar getProgressBarView() {
        return this.progressBar;
    }

    @NonNull
    public ImageView getImageView() {
        return this.imageView;
    }

    @NonNull
    public View getPlayButtonView() {
        return this.playButton;
    }

    public void setPlaceHolderDimension(int placeholderWidth, int placeholderHeight) {
        this.placeholderWidth = placeholderWidth;
        this.placeholderHeight = placeholderHeight;
        this.imageView.setPlaceholderDimensions(placeholderWidth, placeholderHeight);
        this.mediaAspectRatio = (float)placeholderHeight != 0.0f ? (float)placeholderWidth / (float)placeholderHeight : 0.0f;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l2) {
        super.setOnClickListener(l2);
        this.playButton.setOnClickListener(l2);
    }

    public float getMediaAspectRatio() {
        return this.mediaAspectRatio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (this.placeholderWidth == 0 || this.placeholderHeight == 0) {
            if (n4 != 0x40000000) {
                n2 = 0;
            }
            if (n5 != 0x40000000) {
                n3 = 0;
            }
            this.setMeasuredDimension(n2, n3);
            return;
        }
        float f2 = (float)this.placeholderWidth / (float)this.placeholderHeight;
        if (n4 == 0 && n5 == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (n4 == 0) {
            n2 = (int)((float)n3 * f2);
        } else if (n5 == 0) {
            n3 = (int)((float)n2 / f2);
        } else if (n5 != 0x40000000) {
            n3 = (int)((float)n2 / f2);
        }
        int n6 = this.getChildCount();
        boolean bl2 = false;
        for (int i2 = 0; i2 < n6; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            int n7 = Integer.MIN_VALUE;
            int n8 = Integer.MIN_VALUE;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams != null) {
                if (layoutParams.width == -1) {
                    n7 = 0x40000000;
                }
                if (layoutParams.height == -1) {
                    n8 = 0x40000000;
                }
            }
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n2, (int)n7);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n3, (int)n8);
            view.measure(widthMeasureSpec, heightMeasureSpec);
            if (view.getMeasuredHeight() <= 0) continue;
            bl2 = true;
        }
        if (bl2) {
            this.setMeasuredDimension(n2, n3);
        } else {
            this.setMeasuredDimension(0, 0);
        }
    }

    protected void onLayout(boolean changed, int l2, int t2, int r, int b2) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            if (n2 == 0 || n3 == 0) continue;
            int n4 = (r - l2 - n2) / 2;
            int n5 = (b2 - t2 - n3) / 2;
            int n6 = n4 + n2;
            int n7 = n5 + n3;
            view.layout(n4, n5, n6, n7);
        }
    }

    private void initViews(@NonNull Context context) {
        is.a((View)this.imageView, "media_image");
        is.a((View)this.progressBar, "progress_bar");
        is.a(this.playButton, "play_button");
        this.setBackgroundColor(-1118482);
        this.progressBar.setVisibility(8);
        Drawable drawable = this.progressBar.getIndeterminateDrawable();
        if (drawable != null) {
            drawable.setColorFilter(-16733198, PorterDuff.Mode.SRC_ATOP);
        }
        is is2 = is.ab(context);
        this.playButton.a(fm.F(is2.U(80)), false);
        this.playButton.setVisibility(8);
        this.addView((View)this.imageView);
        this.addView(this.playButton, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.addView((View)this.progressBar, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
    }
}

