/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.StateSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.is;
import com.my.target.nativeads.views.MediaAdView;
import com.my.target.nativeads.views.PromoCardView;

public class NativeAdCardView
extends LinearLayout
implements PromoCardView {
    private static final int CTA_ID = is.fP();
    private static final int STANDARD_BLUE = -16748844;
    private static final int MARGIN_DP = 12;
    @NonNull
    private final MediaAdView mediaAdView;
    @NonNull
    private final TextView titleView;
    @NonNull
    private final TextView descriptionView;
    @NonNull
    private final Button ctaButton;
    @NonNull
    private final is uiUtils;
    @NonNull
    private final RelativeLayout containerLayout;
    @NonNull
    private final LinearLayout textContainerLayout;
    @NonNull
    private final View.OnClickListener elementClickListener = new View.OnClickListener(){

        public void onClick(View v2) {
            if (NativeAdCardView.this.cardClickListener != null) {
                NativeAdCardView.this.cardClickListener.onClick((View)NativeAdCardView.this);
            }
        }
    };
    @Nullable
    private View.OnClickListener cardClickListener;

    public NativeAdCardView(@NonNull Context context) {
        super(context);
        this.mediaAdView = new MediaAdView(context);
        this.titleView = new TextView(context);
        this.descriptionView = new TextView(context);
        this.containerLayout = new RelativeLayout(context);
        this.ctaButton = new Button(context);
        this.uiUtils = is.ab(context);
        this.textContainerLayout = new LinearLayout(context);
        is.a((View)this, "card_view");
        is.a((View)this.mediaAdView, "card_media_view");
        is.a((View)this.titleView, "card_title_text");
        is.a((View)this.descriptionView, "card_description_text");
        is.a((View)this.ctaButton, "card_cta_text");
        this.initView();
    }

    @Override
    @NonNull
    public MediaAdView getMediaAdView() {
        return this.mediaAdView;
    }

    @Override
    @NonNull
    public TextView getTitleTextView() {
        return this.titleView;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l2) {
        this.cardClickListener = l2;
        super.setOnClickListener(l2);
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            view.setOnClickListener(this.elementClickListener);
        }
    }

    @Override
    @NonNull
    public TextView getDescriptionTextView() {
        return this.descriptionView;
    }

    @Override
    @NonNull
    public Button getCtaButtonView() {
        return this.ctaButton;
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev2) {
        float f2 = ev2.getX();
        float f3 = ev2.getY();
        return f2 > (float)this.mediaAdView.getLeft() && f2 < (float)this.mediaAdView.getRight() && f3 > (float)this.mediaAdView.getTop() && f3 < (float)this.mediaAdView.getBottom();
    }

    private void initView() {
        this.setOrientation(1);
        this.setPadding(this.uiUtils.U(8), this.uiUtils.U(8), this.uiUtils.U(8), this.uiUtils.U(8));
        this.setClickable(true);
        is.a((View)this, 0, -3806472);
        is.a((View)this.containerLayout, 0, -3806472, -3355444, this.uiUtils.U(1), 0);
        this.ctaButton.setId(CTA_ID);
        this.ctaButton.setMaxEms(10);
        this.ctaButton.setLines(1);
        this.ctaButton.setEllipsize(TextUtils.TruncateAt.END);
        this.ctaButton.setPadding(this.uiUtils.U(10), 0, this.uiUtils.U(10), 0);
        this.ctaButton.setTextSize(2, 12.0f);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, this.uiUtils.U(30));
        layoutParams.addRule(11, -1);
        layoutParams.addRule(15, -1);
        layoutParams.setMargins(this.uiUtils.U(12), this.uiUtils.U(12), this.uiUtils.U(12), this.uiUtils.U(12));
        this.ctaButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.ctaButton.setTransformationMethod(null);
        if (Build.VERSION.SDK_INT >= 21) {
            this.ctaButton.setStateListAnimator(null);
        }
        this.ctaButton.setTextColor(-16748844);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{0, 0});
        gradientDrawable.setStroke(this.uiUtils.U(1), -16748844);
        gradientDrawable.setCornerRadius((float)this.uiUtils.U(1));
        GradientDrawable gradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-3806472, -3806472});
        gradientDrawable2.setStroke(this.uiUtils.U(1), -16748844);
        gradientDrawable2.setCornerRadius((float)this.uiUtils.U(1));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable2);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)gradientDrawable);
        this.ctaButton.setBackgroundDrawable((Drawable)stateListDrawable);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams2.addRule(0, CTA_ID);
        this.textContainerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.textContainerLayout.setGravity(16);
        this.textContainerLayout.setOrientation(1);
        this.titleView.setTextColor(-16777216);
        this.titleView.setTextSize(2, 14.0f);
        this.titleView.setTypeface(null, 1);
        this.titleView.setLines(2);
        this.titleView.setEllipsize(TextUtils.TruncateAt.END);
        this.titleView.setPadding(this.uiUtils.U(12), this.uiUtils.U(6), this.uiUtils.U(1), this.uiUtils.U(1));
        this.descriptionView.setTextColor(-16777216);
        this.descriptionView.setTextSize(2, 12.0f);
        this.descriptionView.setLines(1);
        this.descriptionView.setEllipsize(TextUtils.TruncateAt.END);
        this.descriptionView.setPadding(this.uiUtils.U(12), this.uiUtils.U(1), this.uiUtils.U(1), this.uiUtils.U(12));
        this.addView((View)this.mediaAdView);
        this.addView((View)this.containerLayout);
        this.containerLayout.addView((View)this.ctaButton);
        this.containerLayout.addView((View)this.textContainerLayout);
        this.textContainerLayout.addView((View)this.titleView);
        this.textContainerLayout.addView((View)this.descriptionView);
    }
}

