/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.R;
import com.my.target.ae;
import com.my.target.common.models.ImageData;
import com.my.target.common.views.StarsRatingView;
import com.my.target.fw;
import com.my.target.iq;
import com.my.target.is;
import com.my.target.nativeads.banners.NativePromoBanner;
import com.my.target.nativeads.banners.NativePromoCard;
import com.my.target.nativeads.factories.NativeViewsFactory;
import com.my.target.nativeads.views.IconAdView;
import com.my.target.nativeads.views.MediaAdView;
import com.my.target.nativeads.views.PromoCardRecyclerView;
import com.my.target.nativeads.views.PromoCardView;
import java.util.List;

public class NativeAdView
extends ViewGroup {
    private static final int STANDARD_BLUE = -16748844;
    @NonNull
    private final TextView ageTextView;
    @NonNull
    private final TextView advertTextView;
    @NonNull
    private final IconAdView iconAdView;
    @NonNull
    private final TextView titleTextView;
    @NonNull
    private final TextView urlTextView;
    @NonNull
    private final TextView descriptionTextView;
    @NonNull
    private final StarsRatingView ratingView;
    @NonNull
    private final TextView votesTextView;
    @NonNull
    private final Button ctaButton;
    @NonNull
    private final TextView disclaimerTextView;
    @NonNull
    private final LinearLayout centerLayout;
    @NonNull
    private final LinearLayout topLayout;
    @NonNull
    private final LinearLayout ratingLayout;
    @Nullable
    private MediaAdView mediaAdView;
    @Nullable
    private PromoCardRecyclerView promoCardRecyclerView;
    @Nullable
    private PromoCardRecyclerView.PromoCardAdapter cardAdapter;
    private final int ctaHeight;
    private final int smallMargin;
    private final int iconDimensions;
    private final int advertisingLabelLeftMargin;
    private final int ratingHeight;
    private final int innerMargins;
    private final boolean useExtendedCard;

    public NativeAdView(@NonNull Context context) {
        this(context, null);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, false);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean useExtendedCard) {
        super(context, attrs, defStyleAttr);
        this.useExtendedCard = useExtendedCard;
        this.ageTextView = new fw(context);
        this.advertTextView = new TextView(context);
        this.iconAdView = NativeViewsFactory.getIconAdView(context);
        this.titleTextView = new TextView(context);
        this.urlTextView = new TextView(context);
        this.descriptionTextView = new TextView(context);
        this.ratingView = new StarsRatingView(context);
        this.votesTextView = new TextView(context);
        this.disclaimerTextView = new TextView(context);
        this.ctaButton = new Button(context);
        is is2 = is.ab(context);
        this.centerLayout = new LinearLayout(context);
        this.topLayout = new LinearLayout(context);
        this.ratingLayout = new LinearLayout(context);
        this.setId(R.id.nativeads_ad_view);
        this.advertTextView.setId(R.id.nativeads_advertising);
        this.titleTextView.setId(R.id.nativeads_title);
        this.descriptionTextView.setId(R.id.nativeads_description);
        this.ratingView.setId(R.id.nativeads_rating);
        this.urlTextView.setId(R.id.nativeads_domain);
        this.disclaimerTextView.setId(R.id.nativeads_disclaimer);
        this.ctaButton.setId(R.id.nativeads_call_to_action);
        this.iconAdView.setId(R.id.nativeads_icon);
        this.ageTextView.setId(R.id.nativeads_age_restrictions);
        this.votesTextView.setId(R.id.nativeads_votes);
        this.ratingView.setId(R.id.nativeads_rating);
        is.a((View)this.votesTextView, "votes_text");
        int n2 = is2.U(4);
        this.setPadding(n2, n2, n2, is2.U(8));
        this.smallMargin = is2.U(8);
        this.advertisingLabelLeftMargin = is2.U(9);
        this.iconDimensions = is2.U(54);
        this.ratingHeight = is2.U(12);
        int n3 = is2.U(10);
        this.ctaHeight = is2.U(40);
        this.innerMargins = is2.U(4);
        this.ageTextView.setId(R.id.nativeads_age_restrictions);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(0);
        gradientDrawable.setStroke(1, -13421773);
        int n4 = is2.U(2);
        this.ageTextView.setBackgroundDrawable((Drawable)gradientDrawable);
        this.ageTextView.setGravity(17);
        this.ageTextView.setPadding(n4, 0, 0, 0);
        this.ctaButton.setPadding(n3, 0, n3, 0);
        this.ctaButton.setMaxEms(8);
        this.ctaButton.setLines(1);
        this.ctaButton.setEllipsize(TextUtils.TruncateAt.END);
        this.ctaButton.setTransformationMethod(null);
        is.a((View)this, -1, -3806472);
        GradientDrawable gradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{0, 0});
        gradientDrawable2.setStroke(is2.o(1.5f), -16748844);
        gradientDrawable2.setCornerRadius((float)is2.U(1));
        GradientDrawable gradientDrawable3 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-3806472, -3806472});
        gradientDrawable3.setStroke(is2.o(1.5f), -16748844);
        gradientDrawable3.setCornerRadius((float)is2.U(1));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable3);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)gradientDrawable2);
        this.ctaButton.setBackgroundDrawable((Drawable)stateListDrawable);
        this.setClickable(true);
        if (useExtendedCard) {
            this.promoCardRecyclerView = NativeViewsFactory.getPromoCardRecyclerView(this.getContext());
            this.promoCardRecyclerView.setId(R.id.nativeads_media_view);
            this.addView((View)this.promoCardRecyclerView);
        } else {
            this.mediaAdView = NativeViewsFactory.getMediaAdView(this.getContext());
            this.mediaAdView.setId(R.id.nativeads_media_view);
            this.addView((View)this.mediaAdView);
        }
        this.addView((View)this.iconAdView);
        this.addView((View)this.ctaButton);
        this.addView((View)this.centerLayout);
        this.addView((View)this.topLayout);
        this.topLayout.addView((View)this.ageTextView);
        this.topLayout.addView((View)this.advertTextView);
        this.centerLayout.addView((View)this.titleTextView);
        this.centerLayout.addView((View)this.urlTextView);
        this.centerLayout.addView((View)this.ratingLayout);
        this.ratingLayout.addView((View)this.ratingView);
        this.ratingLayout.addView((View)this.votesTextView);
        this.addView((View)this.descriptionTextView);
        this.addView((View)this.disclaimerTextView);
        this.updateDefaultParams();
        iq.fJ();
    }

    @NonNull
    public TextView getAdvertisingTextView() {
        return this.advertTextView;
    }

    @NonNull
    public TextView getAgeRestrictionTextView() {
        return this.ageTextView;
    }

    @NonNull
    public Button getCtaButtonView() {
        return this.ctaButton;
    }

    @NonNull
    public TextView getDescriptionTextView() {
        return this.descriptionTextView;
    }

    @NonNull
    public TextView getDisclaimerTextView() {
        return this.disclaimerTextView;
    }

    @NonNull
    public TextView getDomainOrCategoryTextView() {
        return this.urlTextView;
    }

    @NonNull
    public IconAdView getIconImageView() {
        return this.iconAdView;
    }

    @Nullable
    public MediaAdView getMediaAdView() {
        return this.mediaAdView;
    }

    @Nullable
    public PromoCardRecyclerView getPromoCardRecyclerView() {
        return this.promoCardRecyclerView;
    }

    @NonNull
    public StarsRatingView getStarsRatingView() {
        return this.ratingView;
    }

    @NonNull
    public TextView getTitleTextView() {
        return this.titleTextView;
    }

    @NonNull
    public TextView getVotesTextView() {
        return this.votesTextView;
    }

    public void setupView(@Nullable NativePromoBanner banner) {
        if (banner == null) {
            return;
        }
        ae.a("Setup banner");
        ImageData imageData = banner.getIcon();
        if (imageData != null) {
            this.iconAdView.setVisibility(0);
        } else {
            this.iconAdView.setVisibility(8);
        }
        if (this.useExtendedCard && this.promoCardRecyclerView != null) {
            this.ctaButton.setVisibility(8);
            this.disclaimerTextView.setVisibility(8);
            this.promoCardRecyclerView.setPromoCardAdapter(this.useAdapter(banner.getCards()));
        } else {
            this.setText(banner.getCtaText(), (TextView)this.ctaButton);
        }
        if ("web".equals(banner.getNavigationType())) {
            if (!this.useExtendedCard) {
                this.ratingView.setVisibility(8);
                this.votesTextView.setVisibility(8);
                this.setText(banner.getDomain(), this.urlTextView);
            }
        } else if ("store".equals(banner.getNavigationType())) {
            String string = banner.getCategory();
            String string2 = banner.getSubCategory();
            String string3 = "";
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string3 = string3 + string;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    string3 = string3 + ", ";
                }
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string3 = string3 + string2;
            }
            is.a((View)this.urlTextView, "category_text");
            this.setText(string3, this.urlTextView);
            if (banner.getRating() > 0.0f && banner.getRating() <= 5.0f) {
                this.ratingView.setVisibility(0);
                if (banner.getVotes() > 0) {
                    this.setText(String.valueOf(banner.getVotes()), this.votesTextView);
                } else {
                    this.votesTextView.setVisibility(8);
                }
                this.ratingView.setRating(banner.getRating());
            }
        }
        this.setText(banner.getDisclaimer(), this.disclaimerTextView);
        this.setText(banner.getTitle(), this.titleTextView);
        this.setText(banner.getDescription(), this.descriptionTextView);
        this.setText(banner.getAdvertisingLabel(), this.advertTextView);
        this.setText(banner.getAgeRestrictions(), this.ageTextView);
    }

    @NonNull
    private PromoCardRecyclerView.PromoCardAdapter useAdapter(@NonNull List<NativePromoCard> cards) {
        if (this.cardAdapter == null) {
            this.cardAdapter = new PromoCardRecyclerView.PromoCardAdapter(){

                @Override
                @NonNull
                public PromoCardView getPromoCardView() {
                    return NativeViewsFactory.getNativeAdCardView(NativeAdView.this.getContext());
                }
            };
        }
        this.cardAdapter.setCards(cards);
        return this.cardAdapter;
    }

    private void updateDefaultParams() {
        int n2 = -6710887;
        this.ageTextView.setTextColor(n2);
        this.ageTextView.setBackgroundColor(0);
        this.ageTextView.setLines(1);
        this.ageTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.ageTextView.setTextSize(2, 10.0f);
        this.advertTextView.setTextSize(2, 12.0f);
        this.advertTextView.setTextColor(n2);
        this.advertTextView.setLines(1);
        this.advertTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.advertTextView.setPadding(this.advertisingLabelLeftMargin, 0, 0, 0);
        this.titleTextView.setTextColor(-16777216);
        this.titleTextView.setTextSize(2, 16.0f);
        this.titleTextView.setTypeface(null, 1);
        this.titleTextView.setLines(1);
        this.titleTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.urlTextView.setTextColor(n2);
        this.urlTextView.setTextSize(2, 14.0f);
        this.urlTextView.setLines(1);
        this.urlTextView.setIncludeFontPadding(false);
        this.urlTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.descriptionTextView.setTextColor(-16777216);
        this.descriptionTextView.setTextSize(2, 15.0f);
        this.descriptionTextView.setMaxLines(3);
        this.descriptionTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.votesTextView.setTextColor(n2);
        this.votesTextView.setTextSize(2, 12.0f);
        this.votesTextView.setLines(1);
        this.votesTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.votesTextView.setPadding(this.innerMargins, 0, 0, 0);
        this.disclaimerTextView.setTextColor(n2);
        this.disclaimerTextView.setTextSize(2, 12.0f);
        this.disclaimerTextView.setMaxLines(2);
        this.disclaimerTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.ctaButton.setTextColor(-16748844);
        this.ctaButton.setLines(1);
        this.ctaButton.setTextSize(2, 16.0f);
        this.ctaButton.setEllipsize(TextUtils.TruncateAt.END);
        this.ratingView.setStarSize(this.ratingHeight);
        this.centerLayout.setOrientation(1);
        this.topLayout.setOrientation(0);
        this.topLayout.setGravity(16);
        this.ratingLayout.setOrientation(0);
        this.ratingLayout.setGravity(16);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = n2 - this.getPaddingLeft() - this.getPaddingRight();
        int n5 = n3 - this.getPaddingTop() - this.getPaddingBottom();
        is.b((View)this.topLayout, n4 - this.advertisingLabelLeftMargin, n5, Integer.MIN_VALUE);
        this.iconAdView.measure(View.MeasureSpec.makeMeasureSpec((int)this.iconDimensions, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.iconDimensions, (int)Integer.MIN_VALUE));
        is.b((View)this.centerLayout, n4 - this.iconAdView.getMeasuredWidth() - this.innerMargins, n5 - this.topLayout.getMeasuredHeight() - this.smallMargin, Integer.MIN_VALUE);
        if (this.useExtendedCard && this.promoCardRecyclerView != null) {
            this.promoCardRecyclerView.measure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n5, (int)Integer.MIN_VALUE));
            n3 = this.topLayout.getMeasuredHeight() + this.innerMargins + is.c(this.centerLayout.getMeasuredHeight(), this.iconAdView.getMeasuredHeight()) + this.promoCardRecyclerView.getMeasuredHeight() + this.getPaddingTop() + this.getPaddingBottom();
        } else if (this.mediaAdView != null) {
            int n6;
            this.mediaAdView.measure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n5, (int)Integer.MIN_VALUE));
            this.ctaButton.measure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.ctaHeight, (int)0x40000000));
            is.b((View)this.descriptionTextView, n4 - this.ctaButton.getMeasuredWidth() - this.innerMargins, n5, Integer.MIN_VALUE);
            is.b((View)this.disclaimerTextView, n4, n5, Integer.MIN_VALUE);
            n3 = this.topLayout.getMeasuredHeight() + this.innerMargins + is.c(this.centerLayout.getMeasuredHeight(), this.iconAdView.getMeasuredHeight()) + this.mediaAdView.getMeasuredHeight() + this.smallMargin + this.getPaddingBottom() + is.c(this.descriptionTextView.getMeasuredHeight(), this.ctaButton.getMeasuredHeight()) + this.getPaddingTop() + this.getPaddingBottom();
            int n7 = n6 = this.disclaimerTextView.getVisibility() == 0 ? this.disclaimerTextView.getMeasuredHeight() : 0;
            if (n6 > 0) {
                n3 += n6;
                n3 += this.smallMargin;
            }
        }
        this.setMeasuredDimension(n2, n3);
    }

    protected void onLayout(boolean changed, int l2, int t2, int r, int b2) {
        int n2 = this.getPaddingLeft();
        int n3 = this.getPaddingTop();
        is.b((View)this.topLayout, n3, n2);
        int n4 = is.c(this.iconAdView.getMeasuredHeight(), this.centerLayout.getMeasuredHeight());
        int n5 = this.topLayout.getBottom() + this.innerMargins;
        int n6 = n5 + (n4 - this.iconAdView.getMeasuredHeight()) / 2;
        is.b((View)this.iconAdView, n6, n2);
        int n7 = n5 + (n4 - this.centerLayout.getMeasuredHeight()) / 2;
        int n8 = is.c(this.iconAdView.getRight() + this.innerMargins, n2);
        is.b((View)this.centerLayout, n7, n8);
        int n9 = n5 + n4 + this.smallMargin;
        if (this.useExtendedCard && this.promoCardRecyclerView != null) {
            is.b((View)this.promoCardRecyclerView, n5 + n4 + this.innerMargins, n2);
        } else {
            is.b((View)this.mediaAdView, n9, n2);
            int n10 = is.c(this.descriptionTextView.getMeasuredHeight(), this.ctaButton.getMeasuredHeight());
            int n11 = (this.mediaAdView != null ? this.mediaAdView.getBottom() : n9) + this.getPaddingBottom();
            int n12 = (n10 - this.descriptionTextView.getMeasuredHeight()) / 2 + n11;
            int n13 = (n10 - this.ctaButton.getMeasuredHeight()) / 2 + n11;
            is.b((View)this.descriptionTextView, n12, n2);
            is.c((View)this.ctaButton, n13, this.getMeasuredWidth() - this.getPaddingRight());
            is.b((View)this.disclaimerTextView, n11 + n10 + this.smallMargin, n2);
        }
    }

    private void setText(@Nullable String text, @NonNull TextView textView) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            textView.setText((CharSequence)text);
            textView.setVisibility(0);
        } else {
            textView.setVisibility(8);
        }
    }
}

