/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.R;
import com.my.target.ae;
import com.my.target.common.models.ImageData;
import com.my.target.common.views.StarsRatingView;
import com.my.target.fw;
import com.my.target.iq;
import com.my.target.is;
import com.my.target.nativeads.banners.NativeBanner;
import com.my.target.nativeads.views.IconAdView;

public class NativeBannerAdView
extends ViewGroup {
    private static final int STANDARD_GREY = -6710887;
    private static final int STANDARD_BLUE = -16748844;
    @NonNull
    private final TextView ageTextView;
    @NonNull
    private final TextView advertTextView;
    @NonNull
    private final IconAdView iconAdView;
    @NonNull
    private final TextView titleTextView;
    @NonNull
    private final TextView urlTextView;
    @NonNull
    private final StarsRatingView ratingView;
    @NonNull
    private final TextView votesTextView;
    @NonNull
    private final Button ctaButton;
    @NonNull
    private final TextView disclaimerTextView;
    @NonNull
    private final LinearLayout centerLayout;
    @NonNull
    private final LinearLayout topLayout;
    private final int ctaHeight;
    private final int smallMargin;
    private final int innerMargins;
    private final int iconDimensions;
    private final int advertisingLabelLeftMargin;
    private final int adChoicesHeight;

    public NativeBannerAdView(@NonNull Context context) {
        this(context, null);
    }

    public NativeBannerAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeBannerAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ageTextView = new fw(context);
        this.advertTextView = new TextView(context);
        this.iconAdView = new IconAdView(context);
        this.titleTextView = new TextView(context);
        this.urlTextView = new TextView(context);
        this.ratingView = new StarsRatingView(context);
        this.votesTextView = new TextView(context);
        this.disclaimerTextView = new TextView(context);
        this.ctaButton = new Button(context);
        this.centerLayout = new LinearLayout(context);
        this.topLayout = new LinearLayout(context);
        LinearLayout linearLayout = new LinearLayout(context);
        is is2 = is.ab(context);
        this.setId(R.id.nativeads_ad_view);
        this.ageTextView.setId(R.id.nativeads_age_restrictions);
        this.advertTextView.setId(R.id.nativeads_advertising);
        this.iconAdView.setId(R.id.nativeads_icon);
        this.titleTextView.setId(R.id.nativeads_title);
        this.urlTextView.setId(R.id.nativeads_domain);
        this.ratingView.setId(R.id.nativeads_rating);
        this.votesTextView.setId(R.id.nativeads_votes);
        this.disclaimerTextView.setId(R.id.nativeads_disclaimer);
        this.ctaButton.setId(R.id.nativeads_call_to_action);
        is.a((View)this.votesTextView, "votes_text");
        int n2 = is2.U(4);
        this.setPadding(n2, n2, n2, n2);
        this.smallMargin = is2.U(2);
        this.advertisingLabelLeftMargin = is2.U(4);
        this.iconDimensions = is2.U(54);
        this.adChoicesHeight = is2.U(20);
        int n3 = is2.U(12);
        int n4 = is2.U(10);
        this.ctaHeight = is2.U(40);
        this.innerMargins = is2.U(4);
        this.ctaButton.setPadding(n4, 0, n4, 0);
        this.ctaButton.setTransformationMethod(null);
        this.ctaButton.setMaxEms(8);
        this.ctaButton.setLines(1);
        this.ctaButton.setEllipsize(TextUtils.TruncateAt.END);
        this.ctaButton.setTextColor(-16748844);
        this.ctaButton.setTextSize(2, 16.0f);
        is.a((View)this, -1, -3806472);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{0, 0});
        gradientDrawable.setStroke(is2.o(1.5f), -16748844);
        gradientDrawable.setCornerRadius((float)is2.U(2));
        GradientDrawable gradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-3806472, -3806472});
        gradientDrawable2.setStroke(is2.o(1.5f), -16748844);
        gradientDrawable2.setCornerRadius((float)is2.U(2));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable2);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)gradientDrawable);
        if (Build.VERSION.SDK_INT >= 16) {
            this.ctaButton.setBackground((Drawable)stateListDrawable);
        } else {
            this.ctaButton.setBackgroundDrawable((Drawable)stateListDrawable);
        }
        this.setClickable(true);
        this.ageTextView.setTextColor(-6710887);
        GradientDrawable gradientDrawable3 = new GradientDrawable();
        gradientDrawable3.setColor(0);
        gradientDrawable3.setStroke(1, -13421773);
        int n5 = is2.U(2);
        this.ageTextView.setBackgroundDrawable((Drawable)gradientDrawable3);
        this.ageTextView.setGravity(17);
        this.ageTextView.setPadding(n5, 0, 0, 0);
        this.ageTextView.setBackgroundColor(0);
        this.ageTextView.setMaxEms(10);
        this.ageTextView.setLines(1);
        this.ageTextView.setTextSize(2, 10.0f);
        this.advertTextView.setTextSize(2, 10.0f);
        this.advertTextView.setTextColor(-6710887);
        this.advertTextView.setLines(1);
        this.advertTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.advertTextView.setPadding(this.advertisingLabelLeftMargin, 0, 0, 0);
        this.titleTextView.setTextColor(-16777216);
        this.titleTextView.setTextSize(2, 16.0f);
        this.titleTextView.setTypeface(null, 1);
        this.titleTextView.setMaxLines(2);
        this.titleTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.urlTextView.setTextColor(-6710887);
        this.urlTextView.setTextSize(2, 14.0f);
        this.urlTextView.setLines(1);
        this.urlTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.urlTextView.setIncludeFontPadding(false);
        this.votesTextView.setTextColor(-6710887);
        this.votesTextView.setTextSize(2, 12.0f);
        this.votesTextView.setLines(1);
        this.votesTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.votesTextView.setPadding(is2.U(4), 0, 0, 0);
        this.disclaimerTextView.setTextColor(-6710887);
        this.disclaimerTextView.setTextSize(2, 12.0f);
        this.disclaimerTextView.setMaxLines(2);
        this.disclaimerTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.ratingView.setStarSize(n3);
        this.topLayout.setOrientation(0);
        this.topLayout.setGravity(16);
        this.centerLayout.setOrientation(1);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        this.addView((View)this.iconAdView);
        this.addView((View)this.ctaButton);
        this.addView((View)this.centerLayout);
        this.addView((View)this.topLayout);
        this.topLayout.addView((View)this.ageTextView);
        this.topLayout.addView((View)this.advertTextView);
        this.centerLayout.addView((View)this.titleTextView);
        this.centerLayout.addView((View)linearLayout);
        this.centerLayout.addView((View)this.disclaimerTextView);
        linearLayout.addView((View)this.urlTextView);
        linearLayout.addView((View)this.ratingView);
        linearLayout.addView((View)this.votesTextView);
        iq.fK();
    }

    @NonNull
    public TextView getAgeRestrictionTextView() {
        return this.ageTextView;
    }

    @NonNull
    public TextView getAdvertisingTextView() {
        return this.advertTextView;
    }

    @NonNull
    public IconAdView getIconImageView() {
        return this.iconAdView;
    }

    @NonNull
    public TextView getTitleTextView() {
        return this.titleTextView;
    }

    @NonNull
    public TextView getDomainTextView() {
        return this.urlTextView;
    }

    @NonNull
    public Button getCtaButtonView() {
        return this.ctaButton;
    }

    @NonNull
    public TextView getVotesTextView() {
        return this.votesTextView;
    }

    @NonNull
    public StarsRatingView getStarsRatingView() {
        return this.ratingView;
    }

    @NonNull
    public TextView getDisclaimerTextView() {
        return this.disclaimerTextView;
    }

    public void setupView(@Nullable NativeBanner banner) {
        if (banner == null) {
            return;
        }
        ae.a("Setup banner");
        ImageData imageData = banner.getIcon();
        if (imageData != null) {
            this.iconAdView.setVisibility(0);
        } else {
            this.iconAdView.setVisibility(8);
        }
        if ("web".equals(banner.getNavigationType())) {
            this.setText(banner.getDomain(), this.urlTextView);
            this.ratingView.setVisibility(8);
            this.votesTextView.setVisibility(8);
        } else if ("store".equals(banner.getNavigationType())) {
            if (banner.getRating() > 0.0f && banner.getRating() <= 5.0f) {
                this.ratingView.setRating(banner.getRating());
                this.ratingView.setVisibility(0);
                this.setText(String.valueOf(banner.getVotes()), this.votesTextView);
                this.urlTextView.setVisibility(8);
                if (banner.getVotes() > 0) {
                    this.votesTextView.setVisibility(0);
                } else {
                    this.votesTextView.setVisibility(8);
                }
                is.a((View)this.votesTextView, "votes_text");
            } else {
                this.ratingView.setVisibility(8);
            }
        }
        this.setText(banner.getTitle(), this.titleTextView);
        this.setText(banner.getAdvertisingLabel(), this.advertTextView);
        this.setText(banner.getCtaText(), (TextView)this.ctaButton);
        this.setText(banner.getAgeRestrictions(), this.ageTextView);
        this.setText(banner.getDisclaimer(), this.disclaimerTextView);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = n2 - this.getPaddingLeft() - this.getPaddingRight();
        int n5 = n3 - this.getPaddingTop() - this.getPaddingBottom();
        is.b((View)this.topLayout, n4 - this.advertisingLabelLeftMargin, n5, Integer.MIN_VALUE);
        this.iconAdView.measure(View.MeasureSpec.makeMeasureSpec((int)this.iconDimensions, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.iconDimensions, (int)Integer.MIN_VALUE));
        this.ctaButton.measure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.ctaHeight, (int)0x40000000));
        is.b((View)this.centerLayout, n4 - this.iconAdView.getMeasuredWidth() - this.ctaButton.getMeasuredWidth() - this.innerMargins * 2, n5 - this.topLayout.getMeasuredHeight() - this.smallMargin, Integer.MIN_VALUE);
        int n6 = this.topLayout.getMeasuredHeight() + this.innerMargins;
        if ((is.c(this.iconAdView.getMeasuredHeight(), this.centerLayout.getMeasuredHeight()) - this.ctaButton.getMeasuredHeight()) / 2 + this.topLayout.getMeasuredHeight() < this.adChoicesHeight) {
            n6 = this.adChoicesHeight;
        }
        n3 = n6 + is.c(this.centerLayout.getMeasuredHeight(), this.iconAdView.getMeasuredHeight(), this.ctaButton.getMeasuredHeight()) + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(n2, n3);
    }

    protected void onLayout(boolean changed, int l2, int t2, int r, int b2) {
        int n2 = this.getPaddingLeft();
        int n3 = this.getPaddingTop();
        is.b((View)this.topLayout, n3, n2);
        int n4 = is.c(this.iconAdView.getMeasuredHeight(), this.centerLayout.getMeasuredHeight(), this.ctaButton.getMeasuredHeight());
        int n5 = this.topLayout.getBottom() + this.innerMargins;
        if ((is.c(this.iconAdView.getMeasuredHeight(), this.centerLayout.getMeasuredHeight()) - this.ctaButton.getMeasuredHeight()) / 2 + this.topLayout.getMeasuredHeight() < this.adChoicesHeight) {
            n5 = n3 + this.adChoicesHeight;
        }
        int n6 = n5 + (n4 - this.iconAdView.getMeasuredHeight()) / 2;
        is.b((View)this.iconAdView, n6, n2);
        int n7 = n5 + (n4 - this.ctaButton.getMeasuredHeight()) / 2;
        is.c((View)this.ctaButton, n7, this.getMeasuredWidth() - this.getPaddingRight());
        int n8 = n5 + (n4 - this.centerLayout.getMeasuredHeight()) / 2;
        int n9 = is.c(this.iconAdView.getRight() + this.innerMargins, n2);
        is.b((View)this.centerLayout, n8, n9);
    }

    private void setText(@Nullable String text, @NonNull TextView textView) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            textView.setText((CharSequence)text);
            textView.setVisibility(0);
        } else {
            textView.setVisibility(8);
        }
    }
}

