/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.views;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.my.target.ae;
import com.my.target.common.models.ImageData;
import com.my.target.gf;
import com.my.target.gm;
import com.my.target.gq;
import com.my.target.ie;
import com.my.target.iu;
import com.my.target.nativeads.banners.NativePromoCard;
import com.my.target.nativeads.views.PromoCardView;
import java.util.ArrayList;
import java.util.List;

public class PromoCardRecyclerView
extends RecyclerView
implements gq {
    private static final float MIN_CARD_VISIBILITY = 50.0f;
    @NonNull
    private final gm layoutManager;
    @NonNull
    private final CardAdapterListener cardClickListener = new CardAdapterListener(){

        public void onClick(View v2) {
            PromoCardRecyclerView.this.clickOnCard(v2);
        }

        @Override
        public void onCardRender(int position) {
            PromoCardRecyclerView.this.renderCard(position);
        }
    };
    @NonNull
    private final PagerSnapHelper snapHelper;
    @Nullable
    private gq.a onPromoCardSliderListener;
    private boolean moving;
    private int displayedCardNum = -1;
    @Nullable
    private PromoCardAdapter promoCardAdapter;

    public PromoCardRecyclerView(Context context) {
        super(context);
        this.layoutManager = new gm(this.getContext());
        this.setHasFixedSize(true);
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView((RecyclerView)this);
    }

    public PromoCardRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.layoutManager = new gm(this.getContext());
        this.setHasFixedSize(true);
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView((RecyclerView)this);
    }

    public PromoCardRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.layoutManager = new gm(this.getContext());
        this.setHasFixedSize(true);
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView((RecyclerView)this);
    }

    @Override
    @NonNull
    public int[] getVisibleCardNumbers() {
        int[] nArray;
        int n2 = this.layoutManager.findFirstVisibleItemPosition();
        int n3 = this.layoutManager.findLastVisibleItemPosition();
        if (n2 < 0 || n3 < 0) {
            return new int[0];
        }
        if (iu.t(this.layoutManager.findViewByPosition(n2)) < 50.0) {
            ++n2;
        }
        if (iu.t(this.layoutManager.findViewByPosition(n3)) < 50.0) {
            --n3;
        }
        if (n2 > n3) {
            return new int[0];
        }
        if (n2 == n3) {
            nArray = new int[]{n2};
        } else {
            nArray = new int[n3 - n2 + 1];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = n2++;
            }
        }
        return nArray;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter instanceof PromoCardAdapter) {
            this.setPromoCardAdapter((PromoCardAdapter)adapter);
        } else {
            ae.a("You must use setPromoCardAdapter(PromoCardAdapter) method with custom CardRecyclerView");
        }
    }

    public void setPromoCardAdapter(@Nullable PromoCardAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.promoCardAdapter = adapter;
        this.promoCardAdapter.setClickListener(this.cardClickListener);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        super.swapAdapter((RecyclerView.Adapter)this.promoCardAdapter, true);
    }

    @Override
    public void setPromoCardSliderListener(@Nullable gq.a promoClickListener) {
        this.onPromoCardSliderListener = promoClickListener;
    }

    @Override
    public void dispose() {
        if (this.promoCardAdapter != null) {
            this.promoCardAdapter.dispose();
        }
    }

    @Override
    @Nullable
    public Parcelable getState() {
        return this.layoutManager.onSaveInstanceState();
    }

    @Override
    public void restoreState(@NonNull Parcelable position) {
        this.layoutManager.onRestoreInstanceState(position);
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        boolean bl2 = this.moving = state != 0;
        if (!this.moving) {
            this.checkCardChanged();
        }
    }

    private void clickOnCard(View v2) {
        if (this.moving) {
            return;
        }
        if ((v2 = this.layoutManager.findContainingItemView(v2)) == null) {
            return;
        }
        if (this.layoutManager.j(v2)) {
            int n2 = this.layoutManager.getPosition(v2);
            if (this.onPromoCardSliderListener != null && n2 >= 0) {
                this.onPromoCardSliderListener.b(v2, n2);
            }
        } else {
            int[] nArray = this.snapHelper.calculateDistanceToFinalSnap((RecyclerView.LayoutManager)this.layoutManager, v2);
            if (nArray != null) {
                this.smoothScrollBy(nArray[0], 0);
            }
        }
    }

    private void renderCard(int position) {
        if (this.onPromoCardSliderListener != null) {
            this.onPromoCardSliderListener.b(position, this.getContext());
        }
    }

    private void checkCardChanged() {
        int n2 = this.layoutManager.findFirstCompletelyVisibleItemPosition();
        if (n2 < 0) {
            return;
        }
        if (this.displayedCardNum != n2) {
            this.displayedCardNum = n2;
            if (this.onPromoCardSliderListener != null && this.layoutManager.findViewByPosition(this.displayedCardNum) != null) {
                this.onPromoCardSliderListener.b(new int[]{this.displayedCardNum}, this.getContext());
            }
        }
    }

    static interface CardAdapterListener
    extends View.OnClickListener {
        public void onCardRender(int var1);
    }

    static class PromoCardViewHolder
    extends RecyclerView.ViewHolder {
        @NonNull
        private final PromoCardView promoCardView;

        PromoCardViewHolder(@NonNull PromoCardView itemView) {
            super(itemView.getView());
            itemView.getView().setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
            this.promoCardView = itemView;
        }

        @NonNull
        PromoCardView getPromoCardView() {
            return this.promoCardView;
        }
    }

    public static abstract class PromoCardAdapter
    extends RecyclerView.Adapter<PromoCardViewHolder> {
        @NonNull
        private final List<NativePromoCard> nativePromoCards = new ArrayList<NativePromoCard>();
        @Nullable
        private CardAdapterListener cardAdapterListener;

        public void setCards(@NonNull List<NativePromoCard> nativePromoCards) {
            this.nativePromoCards.clear();
            this.nativePromoCards.addAll(nativePromoCards);
            this.notifyDataSetChanged();
        }

        public void setClickListener(@Nullable CardAdapterListener cardClickListener) {
            this.cardAdapterListener = cardClickListener;
        }

        @NonNull
        public List<NativePromoCard> getNativePromoCards() {
            return this.nativePromoCards;
        }

        @NonNull
        public PromoCardViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new PromoCardViewHolder(this.getPromoCardView());
        }

        public void onBindViewHolder(@NonNull PromoCardViewHolder holder, int position) {
            NativePromoCard nativePromoCard;
            if (position < this.nativePromoCards.size() && (nativePromoCard = this.nativePromoCards.get(position)) != null) {
                this.setBannerToView(nativePromoCard, holder.getPromoCardView());
                if (this.cardAdapterListener != null) {
                    this.cardAdapterListener.onCardRender(position);
                }
            }
            holder.getPromoCardView().getView().setContentDescription((CharSequence)("card_" + position));
            holder.getPromoCardView().getView().setOnClickListener((View.OnClickListener)this.cardAdapterListener);
            holder.getPromoCardView().getCtaButtonView().setOnClickListener((View.OnClickListener)this.cardAdapterListener);
        }

        public void onViewRecycled(@NonNull PromoCardViewHolder holder) {
            ImageData imageData;
            NativePromoCard nativePromoCard;
            int n2 = holder.getLayoutPosition();
            gf gf2 = (gf)holder.getPromoCardView().getMediaAdView().getImageView();
            gf2.setImageData(null);
            if (n2 > 0 && n2 < this.nativePromoCards.size() && (nativePromoCard = this.nativePromoCards.get(n2)) != null && (imageData = nativePromoCard.getImage()) != null) {
                ie.b(imageData, gf2);
            }
            holder.getPromoCardView().getView().setOnClickListener(null);
            holder.getPromoCardView().getCtaButtonView().setOnClickListener(null);
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
        }

        public int getItemCount() {
            return this.nativePromoCards.size();
        }

        @NonNull
        public abstract PromoCardView getPromoCardView();

        private void dispose() {
            this.cardAdapterListener = null;
        }

        private void setBannerToView(@NonNull NativePromoCard nativePromoCard, @NonNull PromoCardView promoCardView) {
            if (nativePromoCard.getImage() != null) {
                promoCardView.getMediaAdView().setPlaceHolderDimension(nativePromoCard.getImage().getWidth(), nativePromoCard.getImage().getHeight());
                if (nativePromoCard.getImage().getData() != null) {
                    promoCardView.getMediaAdView().getImageView().setImageBitmap(nativePromoCard.getImage().getData());
                } else {
                    ie.a(nativePromoCard.getImage(), promoCardView.getMediaAdView().getImageView());
                }
            }
            promoCardView.getTitleTextView().setText((CharSequence)nativePromoCard.getTitle());
            promoCardView.getDescriptionTextView().setText((CharSequence)nativePromoCard.getDescription());
            String string = nativePromoCard.getCtaText();
            promoCardView.getCtaButtonView().setText((CharSequence)string);
            promoCardView.getCtaButtonView().setContentDescription((CharSequence)string);
        }
    }
}

