/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.ads;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.R;
import com.my.target.a;
import com.my.target.b0;
import com.my.target.common.CustomParams;
import com.my.target.d6;
import com.my.target.e0;
import com.my.target.k1;
import com.my.target.l3;
import com.my.target.x2;
import com.my.target.y8;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MyTargetView
extends FrameLayout {
    @NonNull
    private final a adConfig;
    @NonNull
    private final AtomicBoolean isLoaded = new AtomicBoolean();
    @Nullable
    private MyTargetViewListener listener;
    @Nullable
    private k1 engine;
    @NonNull
    private AdSize adSize;
    private boolean fixedSize = false;
    private boolean attached;

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)typedArray, (int)var3_3);
        void var3_3;
        TypedArray typedArray;
        void var1_1;
        e0.c("MyTargetView created. Version: 5.15.0");
        this.adConfig = a.newConfig(0, "");
        this.adSize = AdSize.getAdSizeForCurrentOrientation((Context)var1_1);
        if (attrs == null) {
            return;
        }
        void v02 = typedArray;
        typedArray = null;
        try {
            typedArray = var1_1.obtainStyledAttributes((AttributeSet)v02, R.styleable.MyTargetView);
        }
        catch (Throwable throwable) {
            e0.a("unable to get view attributes: " + throwable.getMessage());
        }
        if (typedArray == null) {
            return;
        }
        MyTargetView myTargetView = this;
        int n9 = typedArray.getInt(R.styleable.MyTargetView_myTarget_slotId, 0);
        myTargetView.adConfig.setSlotId(n9);
        myTargetView.adConfig.setRefreshAd(typedArray.getBoolean(R.styleable.MyTargetView_myTarget_isRefreshAd, true));
        n9 = typedArray.getInt(R.styleable.MyTargetView_myTarget_adSize, -1);
        if (n9 >= 0) {
            if (n9 != 3) {
                this.fixedSize = true;
            }
            this.adSize = AdSize.access$100(n9, (Context)var1_1);
        }
        typedArray.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private void handleResult(@Nullable x2 result, @Nullable String error, @NonNull l3.a metricFactory) {
        void var3_3;
        Object object;
        void var1_1;
        MyTargetViewListener myTargetViewListener = this.listener;
        if (myTargetViewListener == null) {
            return;
        }
        if (var1_1 == null) {
            if (object == null) {
                object = "no ad";
            }
            myTargetViewListener.onNoAd((String)object, this);
            return;
        }
        object = this.engine;
        if (object != null) {
            ((k1)object).a();
        }
        MyTargetView myTargetView = this;
        this.engine = object = k1.a(myTargetView, myTargetView.adConfig, (l3.a)var3_3);
        ((k1)object).a(this.attached);
        myTargetView.engine.b((x2)var1_1);
        myTargetView.adConfig.setBidId(null);
    }

    private void setFormat() {
        AdSize adSize = this.adSize;
        if (adSize == AdSize.ADSIZE_320x50) {
            this.adConfig.setFormat("standard_320x50");
        } else if (adSize == AdSize.ADSIZE_300x250) {
            this.adConfig.setFormat("standard_300x250");
        } else if (adSize == AdSize.ADSIZE_728x90) {
            this.adConfig.setFormat("standard_728x90");
        } else {
            this.adConfig.setFormat("standard");
        }
    }

    private void updateAdaptiveSize() {
        Object object = this_.getContext();
        Point point = y8.b((Context)object);
        float f10 = point.y;
        if (point.x == this_.adSize.width && (float)this_.adSize.height <= f10 * 0.15f) {
            return;
        }
        MyTargetView myTargetView = this_;
        Object this_ = AdSize.getAdSizeForCurrentOrientation((Context)object);
        myTargetView.adSize = this_;
        object = myTargetView.engine;
        if (object != null) {
            ((k1)object).a((AdSize)this_);
        }
    }

    @Nullable
    public MyTargetViewListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable MyTargetViewListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public boolean isMediationEnabled() {
        return this.adConfig.isMediationEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void setMediationEnabled(boolean mediationEnabled) {
        void var1_1;
        this.adConfig.setMediationEnabled((boolean)var1_1);
    }

    @NonNull
    public CustomParams getCustomParams() {
        return this.adConfig.getCustomParams();
    }

    @NonNull
    public AdSize getSize() {
        return this.adSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        Object object;
        void var1_1;
        if (adSize == null) {
            e0.a("AdSize cannot be null");
            return;
        }
        if (this.fixedSize && AdSize.access$000(this.adSize, (AdSize)var1_1)) {
            return;
        }
        this.fixedSize = true;
        if (this.isLoaded.get() && (AdSize.access$000(this.adSize, (AdSize)(object = AdSize.ADSIZE_300x250)) || AdSize.access$000((AdSize)var1_1, (AdSize)object))) {
            e0.a("unable to switch size to/from 300x250");
            return;
        }
        object = this.engine;
        if (object != null) {
            ((k1)object).a((AdSize)var1_1);
            object = this.getChildAt(0);
            if (object instanceof d6) {
                object.requestLayout();
            }
        }
        this.adSize = var1_1;
        this.setFormat();
    }

    /*
     * WARNING - void declaration
     */
    public void setSlotId(int slotId) {
        void var1_1;
        if (this.isLoaded.get()) {
            return;
        }
        this.adConfig.setSlotId((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshAd(boolean refreshAd) {
        void var1_1;
        this.adConfig.setRefreshAd((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId) {
        void var1_1;
        this.init((int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, boolean isRefreshAd) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, 0, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, int adSize) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, int adSize, boolean isRefreshAd) {
        void var3_3;
        void var1_1;
        void var2_2;
        MyTargetView myTargetView = this;
        myTargetView.setAdSize(AdSize.access$100((int)var2_2, this.getContext()));
        myTargetView.adConfig.setSlotId((int)var1_1);
        myTargetView.adConfig.setRefreshAd((boolean)var3_3);
        e0.a("MyTargetView initialized");
    }

    public final void load() {
        if (!this.isLoaded.compareAndSet(false, true)) {
            e0.a("MyTargetView doesn't support multiple load");
            return;
        }
        MyTargetView myTargetView = this;
        l3.a a10 = l3.a(myTargetView.adConfig.getSlotId());
        l3 l32 = a10.a();
        e0.a("MyTargetView load");
        myTargetView.setFormat();
        b0.a(myTargetView.adConfig, a10).a((result, error) -> {
            void var1_1;
            void var3_3;
            void var2_2;
            this.handleResult((x2)var2_2, (String)var3_3, (l3.a)var1_1);
        }).b(l32, this.getContext());
    }

    /*
     * WARNING - void declaration
     */
    public void loadFromBid(@NonNull String bidId) {
        void var1_1;
        MyTargetView myTargetView = this;
        myTargetView.adConfig.setBidId((String)var1_1);
        myTargetView.adConfig.setRefreshAd(false);
        myTargetView.load();
    }

    public final void handleSection(@NonNull x2 section, @NonNull AdSize adSize) {
        MyTargetView myTargetView = this;
        l3.a a10 = l3.a(myTargetView.adConfig.getSlotId());
        l3 l32 = a10.a();
        b0.a(section, myTargetView.adConfig, a10).a((result, error) -> {
            void var1_1;
            void var3_3;
            void var2_2;
            this.handleResult((x2)var2_2, (String)var3_3, (l3.a)var1_1);
        }).b(l32, this.getContext());
    }

    @Nullable
    public String getAdSource() {
        k1 this_ = ((MyTargetView)((Object)this_)).engine;
        if (this_ != null) {
            return this_.b();
        }
        return null;
    }

    public float getAdSourcePriority() {
        k1 this_ = ((MyTargetView)((Object)this_)).engine;
        if (this_ != null) {
            return this_.c();
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        void var1_1;
        MyTargetView myTargetView = this_;
        super.onWindowFocusChanged((boolean)var1_1);
        k1 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.b((boolean)var1_1);
        }
    }

    public void onAttachedToWindow() {
        MyTargetView myTargetView = this_;
        super.onAttachedToWindow();
        myTargetView.attached = true;
        k1 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.a(true);
        }
    }

    public void onDetachedFromWindow() {
        MyTargetView myTargetView = this_;
        super.onDetachedFromWindow();
        myTargetView.attached = false;
        k1 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.a(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        void var2_2;
        void var1_1;
        if (!this.fixedSize) {
            this.updateAdaptiveSize();
        }
        super.onMeasure((int)var1_1, (int)var2_2);
    }

    public void destroy() {
        k1 k12 = this.engine;
        if (k12 != null) {
            k12.a();
            this.engine = null;
        }
        this.listener = null;
    }

    public static interface MyTargetViewListener {
        public void onLoad(@NonNull MyTargetView var1);

        public void onNoAd(@NonNull String var1, @NonNull MyTargetView var2);

        public void onShow(@NonNull MyTargetView var1);

        public void onClick(@NonNull MyTargetView var1);
    }

    public static final class AdSize {
        public static final int BANNER_320x50 = 0;
        public static final int BANNER_300x250 = 1;
        public static final int BANNER_728x90 = 2;
        public static final int BANNER_ADAPTIVE = 3;
        public static final AdSize ADSIZE_320x50 = new AdSize(320, 50, 0);
        public static final AdSize ADSIZE_300x250 = new AdSize(300, 250, 1);
        public static final AdSize ADSIZE_728x90 = new AdSize(728, 90, 2);
        private static final int MIN_HEIGHT = 50;
        private static final float MAX_HEIGHT_PROPORTION = 0.15f;
        private final int width;
        private final int height;
        private final int widthPixels;
        private final int heightPixels;
        private final int type;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, int maxHeight, @NonNull Context context) {
            void var1_2;
            void var2_3;
            Point point = y8.b((Context)var2_3);
            float f10 = y8.a();
            return AdSize.getSize((float)width * f10, Math.min((float)var1_2 * f10, (float)point.y * 0.15f));
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, @NonNull Context context) {
            void var1_2;
            Point point = y8.b((Context)var1_2);
            return AdSize.getSize((float)width * y8.a(), (float)point.y * 0.15f);
        }

        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(@NonNull Context context) {
            Context context2 = y8.b(context);
            return AdSize.getSize(context2.x, (float)context2.y * 0.15f);
        }

        @NonNull
        private static AdSize getSize(float w9, float h9) {
            float f10;
            float f11;
            float f12 = y8.a();
            f10 = Math.max(Math.min(w9 > 524.0f ? f11 / 728.0f * 90.0f : f11 / 320.0f * 50.0f, f10), f12 * 50.0f);
            int n9 = (int)(f11 / f12);
            int n10 = (int)(f10 / f12);
            int n11 = (int)f11;
            int n12 = (int)f10;
            return new AdSize(n9, n10, n11, n12, 3);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        private static AdSize fromInt(int adSize, @NonNull Context context) {
            void var1_1;
            int n9;
            return adSize != 1 ? (n9 != 2 ? (n9 != 3 ? ADSIZE_320x50 : AdSize.getAdSizeForCurrentOrientation((Context)var1_1)) : ADSIZE_728x90) : ADSIZE_300x250;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isSame(@NonNull AdSize adSize, @NonNull AdSize adSize2) {
            AdSize adSize3;
            void var1_1;
            return adSize.height == var1_1.height && adSize3.width == var1_1.width && adSize3.type == var1_1.type;
        }

        /*
         * WARNING - void declaration
         */
        private AdSize(int widthDp, int heightDp, int widthPixels, int heightPixels, int type) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.widthPixels = var3_3;
            this.heightPixels = var4_4;
            this.type = var5_5;
        }

        /*
         * WARNING - void declaration
         */
        private AdSize(int widthDp, int heightDp, int type) {
            void var3_4;
            void var2_3;
            void var1_2;
            this.width = var1_2;
            this.height = var2_3;
            float f10 = y8.a();
            this.widthPixels = (int)((float)var1_2 * f10);
            this.heightPixels = (int)((float)var2_3 * f10);
            this.type = var3_4;
        }

        /*
         * WARNING - void declaration
         */
        public static /* synthetic */ boolean access$000(AdSize x02, AdSize x12) {
            void var1_1;
            return AdSize.isSame(x02, (AdSize)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static /* synthetic */ AdSize access$100(int x02, Context x12) {
            void var1_1;
            return AdSize.fromInt(x02, (Context)var1_1);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidthPixels() {
            return this.widthPixels;
        }

        public int getHeightPixels() {
            return this.heightPixels;
        }

        public int getType() {
            return this.type;
        }
    }
}

