/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common.models;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.LruCache;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.e0;
import com.my.target.u1;

public final class ImageData
extends u1<Bitmap> {
    private static final int MIN_CACHE_SIZE = 0x500000;
    private static final int DEFAULT_CACHE_SIZE = 0x1E00000;
    @NonNull
    private static volatile LruCache<ImageData, Bitmap> memcache = new BitmapCache(0x1E00000);
    private volatile boolean useCache;

    @AnyThread
    public static void setCacheSize(int sizeInBytes) {
        int n9;
        if (sizeInBytes < 0x500000) {
            e0.a("setting cache size ignored: size should be >=5242880");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            memcache.resize(n9);
        } else {
            memcache = new BitmapCache(n9);
        }
    }

    @AnyThread
    public static void clearCache() {
        memcache.evictAll();
    }

    @NonNull
    public static ImageData newImageData(@NonNull String url) {
        String string;
        return new ImageData(string);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static ImageData newImageData(@NonNull String url, int width, int height) {
        void var2_2;
        void var1_1;
        String string;
        return new ImageData(string, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ImageData(@NonNull String url) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImageData(@NonNull String url, int width, int height) {
        super((String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var2_2;
        this.height = var3_3;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.getData();
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmap(@Nullable Bitmap bitmap) {
        void var1_1;
        this.setData((Bitmap)var1_1);
    }

    @Override
    @Nullable
    public Bitmap getData() {
        if (this.useCache) {
            return (Bitmap)memcache.get((Object)this);
        }
        return (Bitmap)super.getData();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setData(@Nullable Bitmap data) {
        void var1_1;
        if (this.useCache) {
            if (var1_1 == null) {
                memcache.remove((Object)this);
            } else {
                memcache.put((Object)this, (Object)var1_1);
            }
        } else {
            super.setData(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void useCache(boolean use) {
        void var1_1;
        if (use == this.useCache) {
            return;
        }
        this.useCache = var1_1;
        if (var1_1 != false) {
            Bitmap bitmap = (Bitmap)super.getData();
            if (bitmap != null) {
                super.setData(null);
                memcache.put((Object)this, (Object)bitmap);
            }
        } else {
            super.setData((Bitmap)memcache.remove((Object)this));
        }
    }

    @NonNull
    public String toString() {
        return "ImageData{url='" + this.url + '\'' + ", width=" + this.width + ", height=" + this.height + ", bitmap=" + this.getData() + '}';
    }

    public static class BitmapCache
    extends LruCache<ImageData, Bitmap> {
        /*
         * WARNING - void declaration
         */
        public BitmapCache(int maxSize) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int sizeOf(ImageData key, Bitmap value) {
            void var2_2;
            if (Build.VERSION.SDK_INT >= 19) {
                return var2_2.getAllocationByteCount();
            }
            return var2_2.getByteCount();
        }
    }
}

