/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.e0;

public class StarsRatingView
extends View {
    private static final float ACCURACY = 0.2f;
    private static final int ORANGE = -552162;
    private static final int GRAY = -3355444;
    private static final float RAY_LENGTH = 0.45f;
    private static final Paint STAR_PAINT = new Paint();
    private int starSize;
    private float starPadding;
    private float rating;
    @Nullable
    private Bitmap starsBitmap;
    private boolean bitmapCreating;

    /*
     * WARNING - void declaration
     */
    public StarsRatingView(@NonNull Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    private void createBitmap() {
        Canvas canvas;
        StarsRatingView starsRatingView;
        StarsRatingView starsRatingView2;
        StarsRatingView starsRatingView3;
        int n9;
        float f10;
        if (this.starSize <= 0) {
            return;
        }
        StarsRatingView starsRatingView4 = this;
        int n10 = (int)Math.floor(starsRatingView4.rating);
        int n11 = (int)Math.ceil(5.0f - starsRatingView4.rating);
        float f11 = n10;
        int n12 = starsRatingView4.rating - f10 >= 0.2f ? 1 : 0;
        try {
            n9 = n12;
            StarsRatingView starsRatingView5 = this;
            starsRatingView3 = starsRatingView5;
            StarsRatingView starsRatingView6 = starsRatingView5;
            starsRatingView2 = starsRatingView5;
            starsRatingView = starsRatingView5;
            n12 = starsRatingView5.starSize;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            e0.a("Unable to create rating bitmap because of OOME");
            return;
        }
        float f12 = (float)n12 + this.starPadding;
        starsRatingView6.starsBitmap = Bitmap.createBitmap((int)((int)(f12 * 5.0f)), (int)n12, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas(this.starsBitmap);
        starsRatingView.drawStars(0, starsRatingView2.starSize, -552162, canvas2, n10);
        n10 = this.starSize;
        int n13 = (int)(0.0f + ((float)n10 + this.starPadding) * f11);
        starsRatingView3.drawStars(n13, n10, -3355444, canvas2, n11);
        if (n9 != 0) {
            StarsRatingView starsRatingView7 = this;
            n10 = starsRatingView7.starSize;
            float f13 = starsRatingView7.rating;
            this.drawOrangePartStar(n13, n10, (float)((double)f13 - Math.floor(f13)), canvas2);
        }
        this.invalidate();
        this.bitmapCreating = false;
    }

    /*
     * WARNING - void declaration
     */
    private void drawStars(int startPosition, int height, int color, @NonNull Canvas canvas, int count) {
        void var5_5;
        void var2_2;
        void var1_1;
        void var3_3;
        StarsRatingView starsRatingView = starsRatingView2;
        StarsRatingView starsRatingView2 = STAR_PAINT;
        starsRatingView2.setColor((int)var3_3);
        canvas.drawPath(starsRatingView.drawStarPath((int)var1_1, (float)(var2_2 / 2), (int)var5_5), (Paint)starsRatingView2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private Path drawStarPath(int offset, float radius, int count) {
        int n9;
        Path path;
        Path path2 = path;
        new Path().setFillType(Path.FillType.EVEN_ODD);
        double d10 = 0.6283185307179586;
        for (int i9 = 0; i9 < n9; ++i9) {
            void var2_2;
            void var1_1;
            float f10 = i9;
            float f11 = (float)var1_1 + var2_2 + f10 * var2_2 * 2.0f + f10 * this.starPadding;
            f10 = var2_2 * 0.45f;
            double d11 = f11;
            double d12 = (double)var2_2;
            float f12 = (float)(d11 + d12 * Math.sin(0.0));
            void var14_12 = var2_2 * 2.0f;
            double d13 = d12;
            path2.moveTo(f12, (float)(var14_12 - (float)(d13 + d13 * Math.cos(0.0))));
            double d14 = f10;
            f10 = (float)(d11 + d14 * Math.sin(d10));
            path2.lineTo(f10, (float)(var14_12 - (float)(d12 + d14 * Math.cos(d10))));
            for (int i10 = 1; i10 < 5; ++i10) {
                double d15 = i10;
                d15 = 1.2566370614359172 * d15;
                double d16 = d12;
                f12 = (float)(d11 + d12 * Math.sin(d15));
                path2.lineTo(f12, (float)(var14_12 - (float)(d16 + d16 * Math.cos(d15))));
                f12 = (float)(d11 + d14 * Math.sin(d15 += d10));
                path2.lineTo(f12, (float)(var14_12 - (float)(d12 + d14 * Math.cos(d15))));
            }
        }
        Path path3 = path2;
        path3.close();
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    private void drawOrangePartStar(int startPosition, int height, float orangePart, @NonNull Canvas canvas) {
        Canvas canvas2;
        void var3_6;
        void var1_1;
        Rect rect;
        void var2_4;
        StarsRatingView starsRatingView = starsRatingView2;
        StarsRatingView starsRatingView2 = STAR_PAINT;
        starsRatingView2.setColor(-552162);
        Path path = starsRatingView.drawStarPath(0, (float)(var2_4 / 2), 1);
        Rect rect2 = rect;
        void v22 = var1_1;
        float f10 = (float)var2_4 * var3_6;
        rect = new Rect((int)v22, 0, (int)((float)v22 + f10), (int)var2_4);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)f10), (int)var2_4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas3 = canvas2;
        canvas3(bitmap);
        canvas2.drawPath(path, (Paint)starsRatingView2);
        canvas.drawBitmap(bitmap, null, rect2, (Paint)starsRatingView2);
    }

    static {
        STAR_PAINT.setAntiAlias(true);
        STAR_PAINT.setStyle(Paint.Style.FILL);
    }

    /*
     * WARNING - void declaration
     */
    public void setStarSize(int starSize) {
        void var1_1;
        this.starSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRating(float rating) {
        void var1_1;
        this.setContentDescription(Float.toString((float)var1_1));
        if (!(rating > 5.0f) && !(var1_1 < 0.0f)) {
            this.rating = var1_1;
        } else {
            e0.a("Rating is out of bounds: " + (float)var1_1);
            this.rating = 0.0f;
        }
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStarsPadding(float padding) {
        void var1_1;
        this.starPadding = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n9 = this.starSize;
        if (n9 <= 0) {
            void var2_2;
            this.starSize = n9 = View.MeasureSpec.getSize((int)var2_2);
        }
        this.setMeasuredDimension((int)((float)(n9 * 5) + this.starPadding * 4.0f), n9);
    }

    /*
     * WARNING - void declaration
     */
    public void onDraw(Canvas canvas) {
        if (this.rating > 0.0f) {
            Bitmap bitmap = this.starsBitmap;
            if (bitmap == null) {
                if (this.starSize > 0 && !this.bitmapCreating) {
                    StarsRatingView starsRatingView = this;
                    starsRatingView.bitmapCreating = true;
                    starsRatingView.post(starsRatingView::createBitmap);
                }
            } else {
                void var1_1;
                var1_1.drawBitmap(bitmap, 0.0f, 0.0f, null);
            }
        }
    }
}

