/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.a;
import com.my.target.common.BaseAd;
import com.my.target.common.models.VideoData;
import com.my.target.e0;
import com.my.target.f;
import com.my.target.g2;
import com.my.target.instreamads.InstreamAdPlayer;
import com.my.target.l3;
import com.my.target.n8;
import com.my.target.q2;
import com.my.target.r2;
import com.my.target.t0;
import com.my.target.t5;
import com.my.target.u2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InstreamAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @Nullable
    private r2 section;
    @Nullable
    private t0 engine;
    @Nullable
    private InstreamAdPlayer player;
    @Nullable
    private InstreamAdListener listener;
    private int loadingTimeoutSeconds = 10;
    private boolean isFullscreen;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float videoDuration;
    private float volume = 1.0f;

    /*
     * WARNING - void declaration
     */
    public InstreamAd(int slotId, @NonNull Context context) {
        super((int)var1_1, "instreamads");
        void var2_2;
        void var1_1;
        this.context = var2_2;
        e0.c("InstreamAd created. Version: 5.15.0");
    }

    private void handleResult(@Nullable r2 result, @Nullable String error) {
        Object object;
        if (this.listener == null) {
            return;
        }
        if (object != null && ((r2)object).d()) {
            InstreamAd instreamAd = this;
            InstreamAdListener instreamAdListener = object;
            InstreamAd instreamAd2 = this;
            instreamAd2.section = object;
            object = instreamAd2.adConfig;
            this.engine = object = t0.a(instreamAd, (r2)((Object)instreamAdListener), (a)object, instreamAd2.metricFactory);
            ((t0)object).a(this.loadingTimeoutSeconds);
            instreamAd.engine.a(this.volume);
            object = instreamAd.player;
            if (object != null) {
                this.engine.a((InstreamAdPlayer)object);
            }
            InstreamAd instreamAd3 = this;
            float f10 = instreamAd3.videoDuration;
            instreamAd3.configureMidpoints(f10, instreamAd3.userMidpoints);
            instreamAd3.listener.onLoad(this);
        } else {
            String string;
            object = this.listener;
            if (string == null) {
                string = "no ad";
            }
            object.onNoAd(string, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(@NonNull String sectionName) {
        void var1_1;
        t0 t02 = this.engine;
        if (t02 == null) {
            e0.a("Unable to start ad: not loaded yet");
            return;
        }
        if (t02.b() == null) {
            e0.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.a((String)var1_1);
    }

    @NonNull
    public List<String> getVideoSectionNames() {
        ArrayList arrayList;
        ArrayList this_;
        if (((InstreamAd)((Object)this_)).section == null) {
            return Collections.EMPTY_LIST;
        }
        InstreamAd instreamAd = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        ArrayList<u2<VideoData>> arrayList22 = instreamAd.section.c();
        if (arrayList22.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        for (u2 u22 : arrayList22) {
            if (u22.a() <= 0 && !u22.i()) continue;
            arrayList2.add(u22.h());
        }
        return arrayList2;
    }

    @Nullable
    public InstreamAdListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable InstreamAdListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            e0.a("unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            void var1_1;
            e0.a("ad loading timeout set to " + (int)var1_1 + " seconds");
            this.loadingTimeoutSeconds = var1_1;
        }
        t0 t02 = this.engine;
        if (t02 != null) {
            t02.a(this.loadingTimeoutSeconds);
        }
    }

    public int getVideoQuality() {
        return this.adConfig.getVideoQuality();
    }

    /*
     * WARNING - void declaration
     */
    public void setVideoQuality(int videoQuality) {
        void var1_1;
        this.adConfig.setVideoQuality((int)var1_1);
    }

    @Nullable
    public InstreamAdPlayer getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayer(@Nullable InstreamAdPlayer player) {
        void var1_1;
        ((InstreamAd)((Object)this_)).player = var1_1;
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((InstreamAdPlayer)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void swapPlayer(@Nullable InstreamAdPlayer player) {
        void var1_1;
        ((InstreamAd)((Object)this_)).player = var1_1;
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.b((InstreamAdPlayer)var1_1);
        }
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    /*
     * WARNING - void declaration
     */
    public void setFullscreen(boolean fullscreen) {
        void var1_1;
        ((InstreamAd)((Object)this_)).isFullscreen = var1_1;
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((boolean)var1_1);
        }
    }

    public float getVolume() {
        t0 t02 = this.engine;
        if (t02 != null) {
            return t02.c();
        }
        return this.volume;
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(float volume) {
        void var1_1;
        if (Float.compare(volume, 0.0f) >= 0 && Float.compare((float)var1_1, 1.0f) <= 0) {
            ((InstreamAd)((Object)t02)).volume = var1_1;
            t0 t02 = ((InstreamAd)((Object)t02)).engine;
            if (t02 != null) {
                t02.a((float)var1_1);
            }
            return;
        }
        e0.a("unable to set volume" + (float)var1_1 + ", volume must be in range [0..1]");
    }

    @NonNull
    public float[] getMidPoints() {
        Object this_ = ((InstreamAd)this_).midpoints;
        if (((InstreamAd)this_).midpoints == null) {
            return new float[0];
        }
        return (float[])this_.clone();
    }

    public void load() {
        if (this.isLoadCalled()) {
            e0.a("InstreamAd doesn't support multiple load");
            return;
        }
        InstreamAd instreamAd = this;
        l3 l32 = instreamAd.metricFactory.a();
        InstreamAd instreamAd2 = this;
        l3.a a10 = instreamAd2.metricFactory;
        f.a(instreamAd.adConfig, a10, instreamAd2.loadingTimeoutSeconds).a(this::handleResult).b(l32, this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float videoDuration) {
        void var1_1;
        this.configureMidpoints((float)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float videoDuration, @Nullable float[] midpoints) {
        void var1_1;
        q2 q22;
        if (videoDuration <= 0.0f) {
            e0.a("midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (((InstreamAd)object).midpoints != null) {
            e0.a("midpoints already configured");
            return;
        }
        ((InstreamAd)object).userMidpoints = q22;
        ((InstreamAd)object).videoDuration = var1_1;
        q22 = ((InstreamAd)object).section;
        if (q22 != null && (q22 = q22.a("midroll")) != null) {
            InstreamAd instreamAd = object;
            float[] fArray = n8.a(q22, ((InstreamAd)object).userMidpoints, (float)var1_1);
            Object object = fArray;
            instreamAd.midpoints = fArray;
            t0 t02 = instreamAd.engine;
            if (t02 != null) {
                t02.a((float[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpointsPercents(float videoDuration, @Nullable float[] midpointsPercents) {
        void var2_2;
        void var1_1;
        if (midpointsPercents == null) {
            this.configureMidpoints((float)var1_1);
            return;
        }
        this.configureMidpoints((float)var1_1, n8.a((float)var1_1, (float[])var2_2));
    }

    public void useDefaultPlayer() {
        this.useDefaultPlayer(true);
    }

    /*
     * WARNING - void declaration
     */
    public void useDefaultPlayer(boolean useExoPlayer) {
        void var1_1;
        t5 t52 = new t5(this.context);
        t52.setUseExoPlayer((boolean)var1_1);
        this.setPlayer(t52);
    }

    public void pause() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.e();
        }
    }

    public void resume() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.g();
        }
    }

    public void stop() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.j();
        }
    }

    public void skip() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.h();
        }
    }

    public void skipBanner() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.i();
        }
    }

    public void handleClick() {
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.d();
        }
    }

    public void destroy() {
        ((InstreamAd)((Object)this_)).listener = null;
        t0 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    /*
     * WARNING - void declaration
     */
    public void startMidroll(float point) {
        void var1_1;
        t0 t02 = this.engine;
        if (t02 == null) {
            e0.a("Unable to start ad: not loaded yet");
            return;
        }
        if (t02.b() == null) {
            e0.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.b((float)var1_1);
    }

    public static final class InstreamAdBanner {
        public final float duration;
        public final boolean allowClose;
        public final float allowCloseDelay;
        public final int videoWidth;
        public final int videoHeight;
        @Nullable
        public final String ctaText;
        @NonNull
        public final String id;
        public final boolean allowPause;

        @NonNull
        public static InstreamAdBanner newBanner(@NonNull g2 mediaBanner) {
            String string;
            g2 g22 = string;
            string = g22.getId();
            boolean bl = g22.isAllowClose();
            float f10 = g22.getAllowCloseDelay();
            float f11 = g22.getDuration();
            int n9 = g22.getWidth();
            int n10 = g22.getHeight();
            String string2 = g22.getCtaText();
            boolean bl2 = g22.isAllowPause();
            return new InstreamAdBanner(string, bl, f10, f11, n9, n10, string2, bl2);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdBanner(@NonNull String id2, boolean allowClose, float allowCloseDelay, float duration, int width, int height, @Nullable String ctaText, boolean allowPause) {
            void var8_8;
            void var7_7;
            void var5_5;
            void var6_6;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.allowClose = var2_2;
            this.allowCloseDelay = var3_3;
            this.duration = var4_4;
            this.videoHeight = var6_6;
            this.videoWidth = var5_5;
            this.ctaText = var7_7;
            this.allowPause = var8_8;
        }
    }

    public static interface InstreamAdListener {
        public void onLoad(@NonNull InstreamAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAd var2);

        public void onBannerStart(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerPause(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerResume(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAd var2);
    }
}

