/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.a;
import com.my.target.a2;
import com.my.target.common.BaseAd;
import com.my.target.common.models.AudioData;
import com.my.target.common.models.ShareButtonData;
import com.my.target.e0;
import com.my.target.g2;
import com.my.target.i;
import com.my.target.instreamads.InstreamAudioAdPlayer;
import com.my.target.l3;
import com.my.target.n8;
import com.my.target.q2;
import com.my.target.s2;
import com.my.target.u0;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InstreamAudioAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @Nullable
    private s2 section;
    @Nullable
    private u0 engine;
    @Nullable
    private InstreamAudioAdPlayer player;
    @Nullable
    private InstreamAudioAdListener listener;
    private int loadingTimeoutSeconds = 10;
    private float volume = 1.0f;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float audioDuration;

    /*
     * WARNING - void declaration
     */
    public InstreamAudioAd(int slotId, @NonNull Context context) {
        super((int)var1_1, "instreamaudioads");
        void var2_2;
        void var1_1;
        this.context = var2_2;
        e0.c("InstreamAudioAd created. Version: 5.15.0");
    }

    private void handleResult(@Nullable s2 result, @Nullable String error) {
        Object object;
        if (this.listener == null) {
            return;
        }
        if (object != null && ((s2)object).d()) {
            InstreamAudioAd instreamAudioAd = this;
            InstreamAudioAdListener instreamAudioAdListener = object;
            InstreamAudioAd instreamAudioAd2 = this;
            instreamAudioAd2.section = object;
            object = instreamAudioAd2.adConfig;
            this.engine = object = u0.a(instreamAudioAd, (s2)((Object)instreamAudioAdListener), (a)object, instreamAudioAd2.metricFactory);
            ((u0)object).a(this.loadingTimeoutSeconds);
            instreamAudioAd.engine.a(this.volume);
            object = instreamAudioAd.player;
            if (object != null) {
                this.engine.a((InstreamAudioAdPlayer)object);
            }
            InstreamAudioAd instreamAudioAd3 = this;
            float f10 = instreamAudioAd3.audioDuration;
            instreamAudioAd3.configureMidpoints(f10, instreamAudioAd3.userMidpoints);
            instreamAudioAd3.listener.onLoad(this);
        } else {
            String string;
            object = this.listener;
            if (string == null) {
                string = "no ad";
            }
            object.onNoAd(string, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(@NonNull String sectionName) {
        void var1_1;
        u0 u02 = this.engine;
        if (u02 == null) {
            e0.a("Unable to start ad: not loaded yet");
            return;
        }
        if (u02.c() == null) {
            e0.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.a((String)var1_1);
    }

    @Nullable
    public InstreamAudioAdListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable InstreamAudioAdListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            e0.a("unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            void var1_1;
            e0.a("ad loading timeout set to " + (int)var1_1 + " seconds");
            this.loadingTimeoutSeconds = var1_1;
        }
        u0 u02 = this.engine;
        if (u02 != null) {
            u02.a(this.loadingTimeoutSeconds);
        }
    }

    @Nullable
    public InstreamAudioAdPlayer getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayer(@Nullable InstreamAudioAdPlayer player) {
        void var1_1;
        ((InstreamAudioAd)((Object)this_)).player = var1_1;
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((InstreamAudioAdPlayer)var1_1);
        }
    }

    public float getVolume() {
        u0 u02 = this.engine;
        if (u02 != null) {
            return u02.d();
        }
        return this.volume;
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(float volume) {
        void var1_1;
        if (Float.compare(volume, 0.0f) >= 0 && Float.compare((float)var1_1, 1.0f) <= 0) {
            ((InstreamAudioAd)((Object)u02)).volume = var1_1;
            u0 u02 = ((InstreamAudioAd)((Object)u02)).engine;
            if (u02 != null) {
                u02.a((float)var1_1);
            }
            return;
        }
        e0.a("unable to set volume" + (float)var1_1 + ", volume must be in range [0..1]");
    }

    @NonNull
    public float[] getMidPoints() {
        Object this_ = ((InstreamAudioAd)this_).midpoints;
        if (((InstreamAudioAd)this_).midpoints == null) {
            return new float[0];
        }
        return (float[])this_.clone();
    }

    @Nullable
    public InstreamAudioAdBanner getCurrentBanner() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            return this_.b();
        }
        return null;
    }

    public void load() {
        if (this.isLoadCalled()) {
            e0.a("InstreamAudioAd doesn't support multiple load");
            return;
        }
        InstreamAudioAd instreamAudioAd = this;
        l3 l32 = instreamAudioAd.metricFactory.a();
        InstreamAudioAd instreamAudioAd2 = this;
        l3.a a10 = instreamAudioAd2.metricFactory;
        i.a(instreamAudioAd.adConfig, a10, instreamAudioAd2.loadingTimeoutSeconds).a(this::handleResult).b(l32, this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration) {
        void var1_1;
        this.configureMidpoints((float)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration, @Nullable float[] midpoints) {
        void var1_1;
        q2 q22;
        if (audioDuration <= 0.0f) {
            e0.a("midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (((InstreamAudioAd)object).midpoints != null) {
            e0.a("midpoints already configured");
            return;
        }
        ((InstreamAudioAd)object).userMidpoints = q22;
        ((InstreamAudioAd)object).audioDuration = var1_1;
        q22 = ((InstreamAudioAd)object).section;
        if (q22 != null && (q22 = q22.a("midroll")) != null) {
            InstreamAudioAd instreamAudioAd = object;
            float[] fArray = n8.a(q22, ((InstreamAudioAd)object).userMidpoints, (float)var1_1);
            Object object = fArray;
            instreamAudioAd.midpoints = fArray;
            u0 u02 = instreamAudioAd.engine;
            if (u02 != null) {
                u02.a((float[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpointsPercents(float audioDuration, @Nullable float[] midpointsPercents) {
        void var2_2;
        void var1_1;
        if (midpointsPercents == null) {
            this.configureMidpoints((float)var1_1);
            return;
        }
        this.configureMidpoints((float)var1_1, n8.a((float)var1_1, (float[])var2_2));
    }

    public void pause() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.e();
        }
    }

    public void resume() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.g();
        }
    }

    public void stop() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.j();
        }
    }

    public void skip() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.h();
        }
    }

    public void skipBanner() {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.i();
        }
    }

    public void destroy() {
        ((InstreamAudioAd)((Object)this_)).listener = null;
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    /*
     * WARNING - void declaration
     */
    public void startMidroll(float point) {
        void var1_1;
        u0 u02 = this.engine;
        if (u02 == null) {
            e0.a("Unable to start ad: not loaded yet");
            return;
        }
        if (u02.c() == null) {
            e0.a("Unable to start ad: player has not set");
            return;
        }
        this.engine.b((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner, @NonNull Context context) {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var2_2;
            void var1_1;
            this_.a((InstreamAdCompanionBanner)var1_1, (Context)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionShow(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        u0 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.c((InstreamAdCompanionBanner)var1_1);
        }
    }

    public static final class InstreamAudioAdBanner {
        public final float duration;
        public final boolean allowSeek;
        public final boolean allowPause;
        public final boolean allowSkip;
        public final boolean allowTrackChange;
        @Nullable
        public final String adText;
        @NonNull
        public final ArrayList<ShareButtonData> shareButtonDatas;
        @NonNull
        public final List<InstreamAdCompanionBanner> companionBanners;

        @NonNull
        public static InstreamAudioAdBanner newBanner(@NonNull g2<AudioData> mediaBanner) {
            g2<AudioData> g22;
            ArrayList<InstreamAdCompanionBanner> arrayList;
            ArrayList<InstreamAdCompanionBanner> arrayList2 = arrayList;
            arrayList = new ArrayList<InstreamAdCompanionBanner>();
            Iterator<a2> iterator = mediaBanner.getCompanionBanners().iterator();
            while (iterator.hasNext()) {
                arrayList2.add(InstreamAdCompanionBanner.newBanner(iterator.next()));
            }
            g2<AudioData> g23 = g22;
            boolean bl = g23.isAllowSeek();
            boolean bl2 = g23.isAllowSkip();
            boolean bl3 = g23.isAllowTrackChange();
            float f10 = g23.getDuration();
            String string = g23.getAdText();
            boolean bl4 = g23.isAllowPause();
            ArrayList<ShareButtonData> arrayList3 = g23.getShareButtonDatas();
            return new InstreamAudioAdBanner(bl, bl2, bl3, f10, string, bl4, arrayList3, arrayList2);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAudioAdBanner(boolean allowSeek, boolean allowSkip, boolean allowTrackChange, float duration, @Nullable String adText, boolean allowPause, @NonNull ArrayList<ShareButtonData> shareButtonDatas, @NonNull List<InstreamAdCompanionBanner> companionBanners) {
            void var8_8;
            void var7_7;
            void var5_5;
            void var4_4;
            void var3_3;
            void var6_6;
            void var2_2;
            void var1_1;
            this.allowSeek = var1_1;
            this.allowSkip = var2_2;
            this.allowPause = var6_6;
            this.allowTrackChange = var3_3;
            this.duration = var4_4;
            this.adText = var5_5;
            this.shareButtonDatas = var7_7;
            this.companionBanners = var8_8;
        }
    }

    public static final class InstreamAdCompanionBanner {
        public final int width;
        public final int height;
        public final int assetWidth;
        public final int assetHeight;
        public final int expandedWidth;
        public final int expandedHeight;
        public final boolean isClickable;
        @Nullable
        public final String staticResource;
        @Nullable
        public final String iframeResource;
        @Nullable
        public final String htmlResource;
        @Nullable
        public final String apiFramework;
        @Nullable
        public final String adSlotID;
        @Nullable
        public final String required;

        @NonNull
        public static InstreamAdCompanionBanner newBanner(@NonNull a2 companionBanner) {
            a2 a22;
            a2 a23 = a22;
            int n9 = a23.getWidth();
            int n10 = a23.getHeight();
            int n11 = a23.getAssetWidth();
            int n12 = a23.getAssetHeight();
            int n13 = a23.getExpandedWidth();
            int n14 = a23.getExpandedHeight();
            boolean bl = TextUtils.isEmpty((CharSequence)a23.getTrackingLink()) ^ true;
            String string = a23.getStaticResource();
            String string2 = a23.getIframeResource();
            String string3 = a23.getHtmlResource();
            String string4 = a23.getApiFramework();
            String string5 = a23.getAdSlotID();
            String string6 = a23.getRequired();
            return new InstreamAdCompanionBanner(n9, n10, n11, n12, n13, n14, bl, string, string2, string3, string4, string5, string6);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdCompanionBanner(int width, int height, int assetWidth, int assetHeight, int expandedWidth, int expandedHeight, boolean isClickable, @Nullable String staticResource, @Nullable String iframeResource, @Nullable String htmlResource, @Nullable String apiFramework, @Nullable String adSlotID, @Nullable String required) {
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.assetWidth = var3_3;
            this.assetHeight = var4_4;
            this.expandedWidth = var5_5;
            this.expandedHeight = var6_6;
            this.isClickable = var7_7;
            this.staticResource = var8_8;
            this.iframeResource = var9_9;
            this.htmlResource = var10_10;
            this.apiFramework = var11_11;
            this.adSlotID = var12_12;
            this.required = var13_13;
        }
    }

    public static interface InstreamAudioAdListener {
        public void onLoad(@NonNull InstreamAudioAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onBannerStart(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAudioAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAudioAd var2);
    }
}

